/**
 * @license Copyright (c) 2003-2017, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function( config ) {
	// Define changes to default configuration here.
	// For complete reference see:
	// http://docs.ckeditor.com/#!/api/CKEDITOR.config

	// The toolbar groups arrangement, optimized for two toolbar rows.
	config.toolbarGroups = [
		// { name: 'clipboard',   groups: [ 'clipboard', 'undo' ] },
		{ name: 'clipboard',   groups: [ 'clipboard', 'undo' ] },
		{ name: 'editing',     groups: [ 'find', 'selection', 'spellchecker' ] },
		{ name: 'links' },
		{ name: 'insert' },
		{ name: 'forms' },
		{ name: 'tools' },
		{ name: 'document',	   groups: [ 'mode', 'document', 'doctools' ] },
		{ name: 'others' },
		'/',
		{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
		{ name: 'paragraph',   groups: [ 'list', 'indent', 'blocks', 'align', 'bidi' ] },
		{ name: 'styles' },
		{ name: 'colors' },
		{ name: 'about' }
	];

	// Remove some buttons provided by the standard plugins, which are
	// not needed in the Standard(s) toolbar.
	// config.removeButtons = 'Underline,Subscript,Superscript,';
	//config.removeButtons = 'Underline,Subscript,Superscript,Paste,PasteText,PasteFromWord,Source';
	// config.removeButtons = 'Underline,Subscript,Superscript,Paste,PasteText,PasteFromWord,Save,Table,ExportPdf,Smiley,Templates,NewPage,Print,Preview,Iframe,Form,Checkbox,Radio,TextField,Textarea,ImageButton,Select,HiddenField,Button,Language,About';
	config.removeButtons = 'Underline,Subscript,Superscript,Save,Table,ExportPdf,Smiley,Templates,NewPage,Print,Iframe,Form,Textarea,Checkbox,TextField,ImageButton,Select,HiddenField,Button,Language,About';


	// Set the most common block elements.
	config.format_tags = 'p;h1;h2;h3;h4;pre';

	// Simplify the dialog windows.
	config.removeDialogTabs = 'image:advanced;link:advanced';

    config.allowedContent = true;
	config.removePlugins = 'exportpdf';
    config.extraPlugins = 'justify,colorbutton,pastefromword,pastetools,colorbutton,panelbutton,floatpanel';
	// config.extraPlugins = 'pastefromword';
	// config.extraPlugins = 'pastetools';
	
	// config.extraPlugins = 'colorbutton';
	// config.extraPlugins = 'panelbutton';
	// config.extraPlugins = 'floatpanel';
};
