<style>
.loader1 {
    display: none;
  border: 5px solid #f3f3f3; /* Light grey */
  border-top: 5px solid #3498db; /* Blue */
  border-radius: 50% !important;
  width: 28px;
  height: 28px;
  animation: spin 2s linear infinite;
}
.loader2 {
    display: none;
  border: 5px solid #f3f3f3; /* Light grey */
  border-top: 5px solid #3498db; /* Blue */
  border-radius: 50% !important;
  width: 28px;
  height: 28px;
  animation: spin 2s linear infinite;
}

@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}
.file-upload {
  background-color: #ffffff;
  width: 600px;
  margin: 0 auto;
  padding: 20px;
}

.file-upload-btn {
    width: 50%;
    margin: 10px !important;
    margin: 0;
    color: #fff;
    background: #7ebbff;
    border: none;
    padding: 10px;
    border-radius: 4px;
    border-bottom: 4px solid #528ccd;
    transition: all .5s ease;
    outline: none;
    text-transform: uppercase;
    /* margin-top: 5px; */
    font-weight: 700;
    position: relative;
}

.file-upload-btn:hover {
    background: #fff;
    color: #7ebbff;
    transition: all .2s ease;
    cursor: pointer;
    border-bottom: 4px solid #528ccd;
}

.file-upload-btn:active {
  border: 0;
  transition: all .5s ease;
}

.file-upload-content {
  display: none;
  text-align: center;
}

.file-upload-input {
  position: absolute;
  margin: 0;
  padding: 0;
  width: 100%;
  height: 100%;
  outline: none;
  opacity: 0;
  cursor: pointer;
}

.image-upload-wrap {
    margin-top: 20px;
    border: 4px dashed #7ebbff;
    position: relative;
}

.image-dropping,
.image-upload-wrap:hover {
    background-color: #7ebbff29;
    border: 4px dashed #7ebbff;
}

.image-title-wrap {
  padding: 0 15px 15px 15px;
  color: #222;
}

.drag-text {
  text-align: center;
}

.drag-text h3 {
  font-weight: 100;
  text-transform: uppercase;
  color: #7ebbff;
  padding: 60px 0;
}

.file-upload-image {
  max-height: 200px;
  max-width: 200px;
  margin: auto;
  padding: 20px;
}

.remove-image {
  width: 200px;
  margin: 0;
  color: #fff;
  background: #cd4535;
  border: none;
  padding: 10px;
  border-radius: 4px;
  border-bottom: 4px solid #b02818;
  transition: all .2s ease;
  outline: none;
  text-transform: uppercase;
  font-weight: 700;
}

.remove-image:hover {
  background: #c13b2a;
  color: #ffffff;
  transition: all .2s ease;
  cursor: pointer;
}

.remove-image:active {
  border: 0;
  transition: all .2s ease;
}
.upload_loader{
    position: absolute;
    top: 5px;
    bottom: 5px;

    
}
</style>

<?global $config;
?>
<section class="wrapper">
  <!-- page start-->
    <div class="row">
        <div class="col-lg-12">
            <section class="panel" style="text-align : center;">
              	        <p><span style="color:red">Note:</span> Use UTF-8 Encoded CSV in case your data contains special characters(For example: Chinese language characters)</p>
                        <p><strong>Please do not close this window till the progress is 100% else process will fail..<strong></p>
            </section>
            
            <div id="filelist">Your browser doesn't have Flash, Silverlight or HTML5 support.</div>
            <br />
            
            <div id="container">
                <a id="pickfiles" href="javascript:;">[Select files]</a> 
                <a id="uploadfiles" href="javascript:;">[Upload files]</a>
            </div>
            
            <br />
            <pre id="console"></pre>
        </div>
    </div>
  <!-- page end-->
</section>
<script src="https://demolinks2.com/crisp-tech/assets/admin/scripts/plupload.full.min.js"></script>
<script type="text/javascript">
// Custom example logic

var uploader = new plupload.Uploader({
	runtimes : 'html5,flash,silverlight,html4',
	browse_button : 'pickfiles', // you can pass an id...
	container: document.getElementById('container'), // ... or DOM Element itself
	url : base_url + 'upload/do_upload?' + '<?echo $this->uri->segment(2)?>',
	flash_swf_url : base_url + '/assets/admin/scripts/Moxie.swf',
	silverlight_xap_url : '/assets/admin/scripts/Moxie.xap',
	chunk_size: '2048kb',
    max_retries: 3,
	
	filters : {
		max_file_size : '500mb',
		mime_types: [
			// {title : "Image files", extensions : "jpg,gif,png"},
			// {title : "Zip files", extensions : "zip"}
			{title : "CSV", extensions : "csv"}
		],
	},

	init: {
		PostInit: function() {
			document.getElementById('filelist').innerHTML = '';

			document.getElementById('uploadfiles').onclick = function() {
				uploader.start();
				return false;
			};
		},

		FilesAdded: function(up, files) {
			plupload.each(files, function(file) {
				document.getElementById('filelist').innerHTML += '<div id="' + file.id + '">' + file.name + ' (' + plupload.formatSize(file.size) + ') <b></b></div>';
			});
		},

		UploadProgress: function(up, file) {
			document.getElementById(file.id).getElementsByTagName('b')[0].innerHTML = '<span>' + file.percent + "%</span>";
      if(file.percent == 100)
      {

        AdminToastr.success('Success', "Upload completed successfully. Products will continue to update in background. Progress can be viewed in the background process section..");
        //   setTimeout(function () {
        //     alert('Page will now reload. After that please login again');
        //   location.reload(true);
        // }, 5000);
      }
      // console.log(file.percent);
		},

		Error: function(up, err) {
			document.getElementById('console').appendChild(document.createTextNode("\nError #" + err.code + ": " + err.message));
		}
	}
});

uploader.init();

</script>