<?
class Model_time_slots extends MY_Model
{
    /**
     * TKD time_slots MODEL
     *
     * @package     time_slots Model
     * @version     1.0
     * @since       2017
     */

    protected $_table = 'time_slots';
    protected $_field_prefix = 'time_slots_';
    protected $_pk = 'time_slots_id';
    protected $_status_field = 'time_slots_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "time_slots_id,time_slots_course_id,time_slots_status";

        parent::__construct();
    }


    /*
     * table       Table Name
     * Name        FIeld Name
     * label       Field Label / Textual Representation in form and DT headings
     * type        Field type : hidden, text, textarea, editor, etc etc. 
     *                           Implementation in form_generator.php
     * type_dt     Type used by prepare_datatables method in controller to prepare DT value
     *                           If left blank, prepare_datatable Will opt to use 'type'
     * attributes  HTML Field Attributes
     * js_rules    Rules to be aplied in JS (form validation)
     * rules       Server side Validation. Supports CI Native rules
     */
    public function get_fields($specific_field = "")
    {
        // Use when add new image
        $is_required_image = (($this->uri->segment(4) != null) && intval($this->uri->segment(4))) ? '' : 'required';

        $fields = array(

            'time_slots_id' => array(
                'table' => $this->_table,
                'name' => 'time_slots_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),
            'time_slots_seats' => array(
                'table' => $this->_table,
                'name' => 'time_slots_seats',
                'label' => 'Seats',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            'time_slots_type' => array(
                'table' => $this->_table,
                'name' => 'time_slots_type',
                'label' => ' Type',
                'type' => 'dropdown',
                'attributes' => array(),
                'js_rules' => 'required',
                'list_data' => array(
                    '1' => 'Morning/Evening ',
                    '2' => 'Weekend',
                ),
                'rules' => ''
            ),
            'time_slots_course_id' => array(
                'table' => $this->_table,
                'name' => 'time_slots_course_id',
                'label' => 'Course',
                'type' => 'dropdown',
                'attributes' => array(),
                'js_rules' => 'required',
                'list_data' => $this->model_course->find_all_list_active(array(), "course_name"),
                'rules' => 'required|trim|htmlentities'
            ),

            'time_slots_start_date' => array(
                'table' => $this->_table,
                'name' => 'time_slots_start_date',
                'label' => 'Start Date',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),
            'time_slots_end_date' => array(
                'table' => $this->_table,
                'name' => 'time_slots_end_date',
                'label' => 'End Date',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'time_slots_start_time' => array(
                'table' => $this->_table,
                'name' => 'time_slots_start_time',
                'label' => 'Moring Start Time',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'time_slots_end_time' => array(
                'table' => $this->_table,
                'name' => 'time_slots_end_time',
                'label' => 'Moring End Time',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'time_slots_evening_start_time' => array(
                'table' => $this->_table,
                'name' => 'time_slots_evening_start_time',
                'label' => 'Evning Start Time',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'time_slots_evening_end_time' => array(
                'table' => $this->_table,
                'name' => 'time_slots_evening_end_time',
                'label' => 'Evning End Time',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'time_slots_day_or_date' => array(
                'table' => $this->_table,
                'name' => 'time_slots_day_or_date',
                'label' => ' Day Or Date',
                'type' => 'dropdown',
                'attributes' => array(),
                'js_rules' => 'required',
                'list_data' => array(
                    '1' => 'Date Wise',
                    '2' => 'Day Wise',
                ),
                'rules' => ''
            ),


            'time_slots_day' => array(
                'table' => $this->_table,
                'name' => 'time_slots_day',
                'label' => 'Day',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            
            'time_slots_status' => array(
                'table' => $this->_table,
                'name' => 'time_slots_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(
                    0 => "<span class='label label-danger'>Inactive</span>",
                    1 => "<span class='label label-primary'>Active</span>"
                ),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>