<?

class Model_signup extends MY_Model
{

    protected $_table = 'signup';
    protected $_field_prefix = 'signup_';
    protected $_pk = 'signup_id';
    protected $_status_field = 'signup_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "signup_id,signup_fullname,signup_userid,signup_status";
        // $this->relations['tax_exempted_state'] = array(
        //     "type"=>"has_many",
        //     "own_key"=>"tax_exempted_signup_id",   // item_category column
        //     "other_key"=>"tax_exempted_state", // item_category column
        // );
        
        // Call the Model constructor
        parent::__construct();
    }

     public function login($data)
    {
        // Get CodeIgnier Instance
        $CI = & get_instance();

        $params['where']['signup_email'] = $data['signup_email'];
        $params['where']['signup_password'] =$data['signup_password'];
        $signup = $this->find_one($params , true);

        // debug('$signup');
        // debug($data,1);

        if (!$signup) {
            $CI->form_validation->set_message('signup_check', 'Incorrect signupname or ID');
            return FALSE;
        } else {
            $this->set_signup_session($signup);
            return true;
        }

    }

    public function auto_login($user_id)
    {
        // Set params
        $params['where']['signup_id'] = $user_id;
        // Query
        $user = $this->model_signup->find_one_active($params);
        // Get CodeIgnier Instance

        $this->set_user_session($user);
    }

    // Set Session for login user
    public function set_user_session($signup)
    {
        // debug($signup,1);
        // Set data
        $array = array(
            'signup_id' => $signup['signup_id'],
            'signup_type' => $signup['signup_type'],
            'signup_userid'=>$signup['signup_userid'],
            'signup_firstname' => ucfirst($signup['signup_firstname']),
            'signup_lastname' => ucfirst($signup['signup_lastname']),
            'signup_company' => $signup['signup_company'],
            'signup_email' => $signup['signup_email'],
            'signup_username' => $signup['signup_username'],
            'signup_address' => $signup['signup_address'],
            'signup_zip' => $signup['signup_zip'],
            'signup_city' => $signup['signup_city'],
            'signup_state' => $signup['signup_state'],
            'signup_country' => $signup['signup_country'],
            'signup_contact' => $signup['signup_contact'],
            'signup_image' => $signup['signup_logo_image_path'] . $signup['signup_logo_image'],
            'signup_createdon'=>$signup['signup_createdon'],
            'signup_user'=>$signup['signup_user'],
            'User_logged_in'=>1,
            
            //'type'=>'1' // for teacher and parents
        );
        // Set session
        $this->session->set_userdata('userdata', $array);
// debug($this->session,1);
    }

    // Update user session
    public function update_user_session($signup)
    {
        // Get user session
        $user_session = $this->session->userdata('userdata');
        // Loop each session
        foreach($signup as $key=>$value):
            $user_session[$key] = $value;
            $this->session->set_userdata('userdata',$user_session);
        endforeach;
    }

    // Get total members
    public function get_total_members()
    {
        // Set params
        $params['where_string'] = " signup_status!=2";
        $result = $this->find_count($params);
        return $result;
    }

    public function get_fields($specific_field = "")
    {
        // Use when add new image
        $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';

        $data =  array(
            
            'signup_id' => array(
                'table' => $this->_table,
                'name' => 'signup_id',
                'label' => 'ID',
                'primary' => 'primary',
                'type' => 'hidden',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim'
            ),
            
            // 'signup_password' => array(
            //     'table' => $this->_table,
            //     'name' => 'signup_password',
            //     'label' => 'Account Password',
            //     'type' => (!empty($is_required_image)?'password':'hidden'),
            //     'default' => '',
                
            //     'attributes' => array(),
            //     'rules' => 'trim|min_length[6]|md5'
            // ),
         

           'signup_firstname' => array(
                'table' => $this->_table,
                'name' => 'signup_firstname',
                'label' => 'First Name',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'required|strtolower|trim|htmlentities|min_length[3]'
            ),           

            'signup_lastname' => array(
                'table' => $this->_table,
                'name' => 'signup_lastname',
                'label' => 'Last Name',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'required|strtolower|trim|htmlentities|min_length[3]'
            ),           

            'signup_email' => array(
                'table' => $this->_table,
                'name' => 'signup_email',
                'label' => 'Email',
                'type' => (!empty($is_required_image)?'text':'readonly'),
                'attributes'   => array('class'=>'readonlytxt'),
                'js_rules' => '',
                'rules' => 'required|valid_email|strtolower|trim|htmlentities|is_unique[' . $this->_table . '.' . $this->_field_prefix . 'email]'
            ),       
            
            'signup_phone' => array(
                'table' => $this->_table,
                'name' => 'signup_phone',
                'label' => 'Phone',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'required|strtolower|trim|htmlentities|min_length[3]'
            ), 
            'signup_alt_phone' => array(
                'table' => $this->_table,
                'name' => 'signup_alt_phone',
                'label' => 'Alt Phone',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'strtolower|trim|htmlentities|min_length[3]'
            ), 
            
            'signup_mailing_address1' => array(
                'table' => $this->_table,
                'name' => 'signup_mailing_address1',
                'label' => 'Mailing Address 1',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'strtolower|trim|htmlentities|min_length[3]'
            ),  

            'signup_mailing_address2' => array(
                'table' => $this->_table,
                'name' => 'signup_mailing_address2',
                'label' => 'Mailing Address 2',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'strtolower|trim|htmlentities|min_length[3]'
            ),  

            'signup_mailing_city' => array(
                'table' => $this->_table,
                'name' => 'signup_mailing_city',
                'label' => 'Mailing City',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'strtolower|trim|htmlentities|min_length[3]'
            ),  

            'signup_mailing_state' => array(
                'table' => $this->_table,
                'name' => 'signup_mailing_state',
                'label' => 'Mailing state',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'strtolower|trim|htmlentities|min_length[3]'
            ),  

            'signup_mailing_zip' => array(
                'table' => $this->_table,
                'name' => 'signup_mailing_zip',
                'label' => 'Mailing Zip',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'strtolower|trim|htmlentities|min_length[3]'
            ),  

            'signup_description' => array(
                'table' => $this->_table,
                'name' => 'signup_description',
                'label' => 'Comments',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'strtolower|trim|htmlentities|min_length[3]'
            ), 


            'signup_stepping' => array(
                'table' => $this->_table,
                'name' => 'signup_stepping',
                'label' => 'Dynamic Phlebotomy',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'strtolower|trim|htmlentities|min_length[3]'
            ), 

            'signup_dob' => array(
                'table' => $this->_table,
                'name' => 'signup_dob',
                'label' => 'Date of Birth',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'strtolower|trim|htmlentities|min_length[3]'
            ),  

            'signup_diploma' => array(
                'table' => $this->_table,
                'name' => 'signup_diploma',
                'label' => 'HS Diploma or GED?',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => ''
            ),  
            'signup_amount' => array(
                'table' => $this->_table,
                'name' => 'signup_amount',
                'label' => 'Amount',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => ''
            ),
            'signup_payment_comments' => array(
                'table' => $this->_table,
                'name' => 'signup_payment_comments',
                'label' => 'Payment Comments',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => ''
            ),
            'signup_merchant' => array(
                'table' => $this->_table,
                'name' => 'signup_merchant',
                'label' => 'Merchant',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => ''
            ),

  'signup_merchant_response' => array(
                'table' => $this->_table,
                'name' => 'signup_merchant_response',
                'label' => 'Response',
                'type' => 'textarea',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => ''
            ),
            

            
            
            
            
            'signup_payment_status'=> array(
                'table' => $this->_table,
                'name' => 'signup_payment_status',
                'label' => 'Payment Status',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                   'list_data' => array(
                       0 => "<span class='label label-danger'>Pending</span>" ,
                       1 =>  "<span class='label label-primary'>Commpleted</span>"
                   ) ,
                'default' => '0',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),
            
            
            'signup_notification'=> array(
                'table' => $this->_table,
                'name' => 'signup_notification',
                'label' => 'Notification',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                   'list_data' => array(
                       0 => "<span class='label label-danger'>No</span>" ,
                       1 =>  "<span class='label label-primary'>Yes</span>"
                   ) ,
                'default' => '0',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),
       
            
           'signup_status'=> array(
                'table' => $this->_table,
                'name' => 'signup_status',
                'label' => 'Status',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                   'list_data' => array(
                       0 => "<span class='label label-danger'>Inactive</span>" ,
                       1 =>  "<span class='label label-primary'>Active</span>"
                   ) ,
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),
        );

        if($this->uri->segment(4)!=null){
            unset($data['signup_password']);
        }

        if ($specific_field)
            return $data[$specific_field];
        else
            return $data;
    }
}

?>