<?
class Model_product extends MY_Model {
    /**
     *
     * @package     product Model
     * 
     * @version     1.0
     * @since       2017
     */

    protected $_table    = 'product';
    protected $_field_prefix    = 'product_';
    protected $_pk    = 'product_id';
    protected $_status_field    = 'product_status';
    public $relations = array();
    public $pagination_params = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor
        //$this->pagination_params['fields'] = "product_id,product_category_id,product_subcategory_id,product_childcategory_id,product_name,product_stock,product_price,CONCAT(product_image_path,product_image) AS product_image,product_status";
        $this->pagination_params['fields'] = "product_id,product_name,CONCAT('$',product_price) AS product_price,CONCAT(product_image_path,product_image) AS product_image,product_status";
        
        parent::__construct();

    }
    
    public function get_available_products(){
          
        $result = $this->find_all_active();
        return $result;
    }
    
    public function get_subcategoryIDs($categoryId= '')
    {
       $categoryIDs = array();
       array_push($categoryIDs, $categoryId);
       $param['where']['category_parent_id'] = $categoryId;
       $sub_categories1 = $this->model_category->find_all_active($param);
       
       if (!empty($sub_categories1)):
            foreach ($sub_categories1 as $sub_category):
                array_push($categoryIDs, $sub_category['category_id']);
                $param['where']['category_parent_id'] = $sub_category['category_id'];
                $sub_categories2 = $this->model_category->find_all_active($param);
                
                if (!empty($sub_categories2)):
                    foreach ($sub_categories2 as $sub_category):
                        array_push($categoryIDs, $sub_category['category_id']);
                        $param['where']['category_parent_id'] = $sub_category['category_id'];
                        $sub_categories3 = $this->model_category->find_all_active($param);
                    endforeach;
                endif;
            endforeach;
        endif;
        return $categoryIDs;
    }

    public function get_all_products_with_wishlist($paginationStart, $limit)
    {
        $userid = $this->userid;    
        $products = array();         

        $products = $this->db->query('SELECT  p.*, 
                                                c.*,
                                            CASE 
                                                WHEN w.wishlist_product_id IS NOT NULL THEN 1 
                                                ELSE 0 
                                            END AS is_wishlist
                                        FROM fb_product p                                    
                                        LEFT JOIN fb_category c ON p.product_category_id = c.category_id
                                        LEFT JOIN fb_wishlist w ON w.wishlist_product_id = p.product_id AND w.wishlist_user_id = '.$userid.'
                                        WHERE p.product_status = 1
                                        ORDER BY product_id DESC
                                        LIMIT '.$limit.'
                                        OFFSET '.$paginationStart.';')->result_array();   

        return $products;
   
    }  
    public function get_products($paginationStart, $limit)
    {
       
        $products = array(); 
        $param['order'] = 'product_id DESC';
        $param['limit'] = $limit;
        $param['offset'] = $paginationStart;
        $products = $this->model_product->find_all_active($param);
        return $products;
    }
    public function get_all_product_count_by_category_IDs($categoryId)
    {
        $product_count = 0;
        if(!empty($categoryId)):
            $categoryIDs = join(', ', $this->get_subcategoryIDs($categoryId));
            $products = array();
            $product_count = $this->db->query("SELECT COUNT(product_id) AS total_products FROM `fb_product` 
            WHERE `product_category_id` IN ($categoryIDs) AND `product_status` = 1 ")->row();
            // debug($product_count,1);
        endif;
        return $product_count;
    }
    
    public function get_products_with_sub_category($categoryId,$paginationStart, $limit)
    {
        $userid = $this->userid;   
  
        $products = array();  
      

        $products = $this->db->query('SELECT  p.*, c.*
                                                FROM fb_product p
                                                INNER JOIN fb_category c ON p.product_category_id = c.category_id
                                                WHERE c.category_id = '.$categoryId.'
                                                UNION
                                                SELECT p.*, c.*
                                                FROM fb_product p
                                                INNER JOIN fb_category child ON p.product_category_id = child.category_id
                                                INNER JOIN fb_category parent ON child.category_parent_id = parent.category_id
                                                INNER JOIN fb_category c ON p.product_category_id = c.category_id
                                                WHERE parent.category_id = '.$categoryId.'
                                                ORDER BY product_id DESC
                                                LIMIT '.$limit.'
                                                OFFSET '.$paginationStart.'; ')->result_array();
                    

        return $products;   
    }
    public function get_products_with_sub_category_without_pagination($categoryId,$limit)
    {
        $userid = $this->userid;   
  
        $products = array();  
      

        $products = $this->db->query('SELECT  p.*, c.*
                                                FROM fb_product p
                                                INNER JOIN fb_category c ON p.product_category_id = c.category_id
                                                WHERE c.category_id = '.$categoryId.'
                                                UNION
                                                SELECT p.*, c.*
                                                FROM fb_product p
                                                INNER JOIN fb_category child ON p.product_category_id = child.category_id
                                                INNER JOIN fb_category parent ON child.category_parent_id = parent.category_id
                                                INNER JOIN fb_category c ON p.product_category_id = c.category_id
                                                WHERE parent.category_id = '.$categoryId.'
                                                ORDER BY product_id DESC
                                                LIMIT '.$limit.'; ')->result_array();
                    

        return $products;   
    }
    public function get_sorted_products($categoryId, $paginationStart, $limit, $param=array())
    {
        $userid = $this->userid;
        $products = array();
        $param['joins'][0] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'left'
        );
        $param['joins'][1] = array(
            'table' => 'wishlist',
            'joint' => 'wishlist.wishlist_product_id = product.product_id AND wishlist_user_id = '.$userid.'',
            'type' => 'left'
        );
        // $param['where']['product_category_id'] = $categoryId;
        $param['where']['product_category_id'] = $categoryId;
        // $param['order'] = 'product_price ASC';
        $param['limit'] = $limit;
        $param['offset'] = $paginationStart;

        

        $products = $this->model_product->find_all_active($param);
        // debug(count($products));
        // echo $this->db->last_query();
        // debug($products,1);
        return $products;
    }

    public function get_products_by_vendor($vendorId,$paginationStart, $limit)
    {
        $userid = $this->userid;  
  
        $products = array();         
     
        $products = $this->db->query('SELECT  p.*,
                                            CASE 
                                                WHEN w.wishlist_product_id IS NOT NULL THEN 1 
                                                ELSE 0 
                                            END AS is_wishlist
                                        FROM fb_product p
                                        LEFT JOIN fb_wishlist w ON w.wishlist_product_id = p.product_id AND w.wishlist_user_id = '.$userid.'
                                        WHERE p.product_user_id = '.$vendorId.'
                                        AND p.product_status = 1                                       
                                        ORDER BY product_id DESC
                                        LIMIT '.$limit.'
                                        OFFSET '.$paginationStart.'; ')->result_array();                                                  

        return $products;
   
    }
    public function get_sorted_products_with_price($categoryId, $paginationStart, $limit, $min, $max)
    {
        $userid = $this->userid;
        $products = array(); 

        $products = $this->db->query('SELECT  p.*, 
                                        c.*,
                                        CASE 
                                            WHEN w.wishlist_product_id IS NOT NULL THEN 1 
                                            ELSE 0 
                                        END AS is_wishlist
                                    FROM fb_product p
                                    INNER JOIN fb_category c ON p.product_category_id = c.category_id
                                    LEFT JOIN fb_wishlist w ON w.wishlist_product_id = p.product_id AND w.wishlist_user_id = '.$userid.'
                                    WHERE c.category_id = '.$categoryId.'
                                    AND product_price > '.$min.'
                                    AND product_price <  '.$max.'
                                    UNION
                                    SELECT p.*, 
                                            c.*,
                                        CASE 
                                            WHEN w.wishlist_product_id IS NOT NULL THEN 1 
                                            ELSE 0 
                                        END AS is_wishlist
                                    FROM fb_product p

                                    INNER JOIN fb_category child ON p.product_category_id = child.category_id
                                    INNER JOIN fb_category parent ON child.category_parent_id = parent.category_id
                                    INNER JOIN fb_category c ON p.product_category_id = c.category_id
                                    LEFT JOIN fb_wishlist w ON w.wishlist_product_id = p.product_id AND w.wishlist_user_id = '.$userid.'
                                    WHERE parent.category_id = '.$categoryId.'
                                    AND product_price > '.$min.'
                                    AND product_price <  '.$max.'
                                    ORDER BY product_id DESC
                                    LIMIT '.$limit.'
                                    OFFSET '.$paginationStart.'; ')->result_array(); 
            // debug($this->db->last_query(),1);

        return $products;
    }

    public function get_sorted_products_by_brand($manufacturerId, $paginationStart, $limit, $param=array())
    {
        $products = array();
        $param['joins'][0] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'left'
        );
        $param['joins'][1] = array(
            'table' => 'manufacturer',
            'joint' => 'manufacturer.manufacturer_id = product.product_manufacturer_id',
            'type' => 'left');
        $param['where_in']['product_manufacturer_id'] = $manufacturerId;
        $param['limit'] = $limit;
        $param['offset'] = $paginationStart;

        

        $products = $this->model_product->find_all_active($param);      
        return $products;
    }

    public function get_products_by_brands($manufacturerId, $paginationStart, $limit) // not used
    {
        $products = array();
        $param['joins'][0] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'left'
        );
        $param['joins'][1] = array(
            'table' => 'manufacturer',
            'joint' => 'manufacturer.manufacturer_id = product.product_manufacturer_id',
            'type' => 'left');
        // $param['where']['product_category_id'] = $categoryId;
        $param['where']['product_manufacturer_id'] = $manufacturerId;
        $param['order'] = 'product_id DESC';
        $param['limit'] = $limit;
        $param['offset'] = $paginationStart;

        

        $products = $this->model_product->find_all_active($param);
        // debug(count($products));
        // echo $this->db->last_query();
        // debug($products,1);
        return $products;
    }

    // Get pagination data
    public function get_pagination_data($limit = '', $offset = '', $param = array() ,$keyword = '', $category_ids = '')
    {
        $param['fields'] = "product_id,product_category_id,product_name,product_slug,product_price,product_old_price,product_overview,product_detail,product_info,
        product_image,,product_image_thumb,product_image_path,product_createdon";
        $prefix = $this->db->dbprefix;

        // LEFT JOIN
        // $param['joins'][] = array(
        //     'table' => 'category',
        //     'joint' => 'category.category_id = product.product_category_id',
        //     'type' => 'right'
        // );
        // For search
        if(!empty($_GET['search'])  && $_GET['search'] != ''){
            $param['where_like'][] = array(
                'column'=>'product_name',
                'value'=>$keyword,
                'type'=>'both',
            );
        }
        // For search
        // if(!empty($category_id>0)){
        //     $param['where']['category_id'] = $category_id;
        // }
        $param['order'] = 'product_id DESC';
        $param['limit'] = $limit;
        $param['offset'] = $offset;
        $param['where_in'] = $category_ids;

        // debug($param,1);

        // Query data
        $data = $this->find_all_active($param);
        // debug($data,1);

        return $data;
    }


    public function get_feature_products()
    {
        $param['joins'][0] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'left'
        );
        $param['joins'][1] = array(
            'table' => 'manufacturer',
            'joint' => 'manufacturer.manufacturer_id = product.product_manufacturer_id',
            'type' => 'left');
            
        $param['where']['product_is_featured'] = STATUS_ACTIVE;
        $param['order'] = 'product_id DESC';
        $param['limit'] = 10;

        $result = $this->find_all_active($param);

        return $result;
    }
    
    public function get_most_selling_products()
    {
        $products = array();
        $param['joins'][0] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'left'
        );
        $param['joins'][1] = array(
            'table' => 'manufacturer',
            'joint' => 'manufacturer.manufacturer_id = product.product_manufacturer_id',
            'type' => 'left');
            
        $param['where']['product_most_selling'] = STATUS_ACTIVE;
        $param['order'] = 'product_id DESC';
        $param['limit'] = 10;
        
        $result = $this->find_all_active($param);

        return $result;
    }

    public function get_total_count_accessories($params = array() , $keyword='', $category_id=0)
    {

        // debug($keyword,1);

        // For search
        if(!empty($keyword)){
            $params['where_like'][] = array(
                'column'=>'product_name',
                'value'=>$keyword,
                'type'=>'both',
            );
        }
        // For search
        if(!empty($category_id>0)){
            $params['where']['category_id'] = $category_id;
        }

        // For Category
        if(!empty($_GET['product_category_id'])  && $_GET['product_category_id'] != ''){
            $params['where']['product_category_id'] = $_GET['product_category_id'];
        }
        // For Brand
        // if(!empty($_GET['product_brand_id'])  && $_GET['product_brand_id'] != ''){
        //     $params['where']['product_brand_id'] = $_GET['product_brand_id'];
        // }
        // // For Style
        // if(!empty($_GET['product_style_id'])  && $_GET['product_style_id'] != ''){
        //     $params['where']['product_style_id'] = $_GET['product_style_id'];
        // }

        /*$params['joins'][] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'right'
        );*/


         $params['where']['product_is_accessories'] = STATUS_ACTIVE;
        // Set params
        // SORT
        if(!empty($_GET['sort'])  && $_GET['sort'] != ''){
            $params['order'] = 'product_name ' . $_GET['sort'];
        }
        else{
            $params['order'] = 'product_id DESC';
        }


        return $this->find_count_active($params);
    }

    // Get pagination data
    public function get_pagination_data_accessories($limit = '', $offset = '', $param = array() ,$keyword = '', $category_id=0)
    {
        $param['fields'] = "product_id,product_category_id,product_name,product_slug,product_price,product_overview,
        product_image,,product_image_thumb,product_image_path,product_createdon,product_type,product_price,product_old_price";
        $prefix = $this->db->dbprefix;

        // LEFT JOIN
        /*$param['joins'][] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'right'
        );*/
        // For search
        if(!empty($_GET['search'])  && $_GET['search'] != ''){
            $param['where_like'][] = array(
                'column'=>'product_name',
                'value'=>$keyword,
                'type'=>'both',
            );
        }
        // For search
        if(!empty($category_id>0)){
            $param['where']['category_id'] = $category_id;
        }

        // For Category
        if(!empty($_GET['product_category_id'])  && $_GET['product_category_id'] != ''){
            $param['where']['product_category_id'] = $_GET['product_category_id'];
        }
        // For Brand
        if(!empty($_GET['product_brand_id'])  && $_GET['product_brand_id'] != ''){
            $param['where']['product_brand_id'] = $_GET['product_brand_id'];
        }
        // For Style
        if(!empty($_GET['product_style_id'])  && $_GET['product_style_id'] != ''){
            $param['where']['product_style_id'] = $_GET['product_style_id'];
        }


        $param['where']['product_is_accessories'] = STATUS_ACTIVE;
        // SORT
        if(!empty($_GET['sort'])  && $_GET['sort'] != ''){
            $param['order'] = 'product_name ' . $_GET['sort'];
        }
        else{
            $param['order'] = 'product_id DESC';
        }
        $param['limit'] = $limit;
        $param['offset'] = $offset;

        // debug($param,1);

        // Query data
        $data = $this->find_all_active($param);
        // debug($data,1);

        return $data;
    }

    public function get_total_count_merchandise($params = array() , $keyword='', $category_id=0)
    {

        // debug($keyword,1);

        // For search
        if(!empty($keyword)){
            $params['where_like'][] = array(
                'column'=>'product_name',
                'value'=>$keyword,
                'type'=>'both',
            );
        }
        // For search
        if(!empty($category_id>0)){
            $params['where']['category_id'] = $category_id;
        }

        // For Category
        if(!empty($_GET['product_category_id'])  && $_GET['product_category_id'] != ''){
            $params['where']['product_category_id'] = $_GET['product_category_id'];
        }
        // For Brand
        if(!empty($_GET['product_brand_id'])  && $_GET['product_brand_id'] != ''){
            $params['where']['product_brand_id'] = $_GET['product_brand_id'];
        }
        // For Style
        if(!empty($_GET['product_style_id'])  && $_GET['product_style_id'] != ''){
            $params['where']['product_style_id'] = $_GET['product_style_id'];
        }

        /*$params['joins'][] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'right'
        );*/


        $params['where']['product_is_merchandise'] = STATUS_ACTIVE;
        // Set params
        // SORT
        if(!empty($_GET['sort'])  && $_GET['sort'] != ''){
            $params['order'] = 'product_name ' . $_GET['sort'];
        }
        else{
            $params['order'] = 'product_id DESC';
        }


        return $this->find_count_active($params);
    }

    // Get pagination data
    public function get_pagination_data_merchandise($limit = '', $offset = '', $param = array() ,$keyword = '', $category_id=0)
    {
        $param['fields'] = "product_id,product_category_id,product_name,product_slug,product_price,product_overview,
        product_image,,product_image_thumb,product_image_path,product_createdon,product_type,product_price,product_old_price";
        $prefix = $this->db->dbprefix;

        // LEFT JOIN
        /*$param['joins'][] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'right'
        );*/
        // For search
        if(!empty($_GET['search'])  && $_GET['search'] != ''){
            $param['where_like'][] = array(
                'column'=>'product_name',
                'value'=>$keyword,
                'type'=>'both',
            );
        }
        // For search
        if(!empty($category_id>0)){
            $param['where']['category_id'] = $category_id;
        }

        // For Category
        if(!empty($_GET['product_category_id'])  && $_GET['product_category_id'] != ''){
            $param['where']['product_category_id'] = $_GET['product_category_id'];
        }
        // For Brand
        if(!empty($_GET['product_brand_id'])  && $_GET['product_brand_id'] != ''){
            $param['where']['product_brand_id'] = $_GET['product_brand_id'];
        }
        // For Style
        if(!empty($_GET['product_style_id'])  && $_GET['product_style_id'] != ''){
            $param['where']['product_style_id'] = $_GET['product_style_id'];
        }


        $param['where']['product_is_merchandise'] = STATUS_ACTIVE;
        // SORT
        if(!empty($_GET['sort'])  && $_GET['sort'] != ''){
            $param['order'] = 'product_name ' . $_GET['sort'];
        }
        else{
            $param['order'] = 'product_id DESC';
        }
        $param['limit'] = $limit;
        $param['offset'] = $offset;

        // debug($param,1);

        // Query data
        $data = $this->find_all_active($param);
        // debug($data,1);

        return $data;
    }

    public function get_total_count_search($params = array() , $keyword='', $category_id=0)
    {

        // debug($keyword,1);

        // For search
        if(!empty($keyword)){
            $params['where_like'][] = array(
                'column'=>'product_name',
                'value'=>$keyword,
                'type'=>'both',
            );
        }
        // For search
        if(!empty($category_id>0)){
            $params['where']['category_id'] = $category_id;
        }

        // For Category
        if(!empty($_GET['product_category_id'])  && $_GET['product_category_id'] != ''){
            $params['where']['product_category_id'] = $_GET['product_category_id'];
        }
        // For Brand
        if(!empty($_GET['product_brand_id'])  && $_GET['product_brand_id'] != ''){
            $params['where']['product_brand_id'] = $_GET['product_brand_id'];
        }
        // For Style
        if(!empty($_GET['product_style_id'])  && $_GET['product_style_id'] != ''){
            $params['where']['product_style_id'] = $_GET['product_style_id'];
        }

        /*$params['joins'][] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'right'
        );*/


        //$params['where']['product_is_merchandise'] = STATUS_ACTIVE;
        // Set params
        // SORT
        if(!empty($_GET['sort'])  && $_GET['sort'] != ''){
            $params['order'] = 'product_name ' . $_GET['sort'];
        }
        else{
            $params['order'] = 'product_id DESC';
        }


        return $this->find_count_active($params);
    }

    // Get pagination data
    public function get_pagination_data_search($limit = '', $offset = '', $param = array() ,$keyword = '', $category_id=0)
    {
        $param['fields'] = "product_id,product_category_id,product_name,product_slug,product_price,product_overview,
        product_image,product_image_thumb,product_image_path,product_createdon,product_price";
        $prefix = $this->db->dbprefix;

        // LEFT JOIN
        /*$param['joins'][] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'right'
        );*/
        // For search
        if(!empty($_GET['search'])  && $_GET['search'] != ''){
            $param['where_like'][] = array(
                'column'=>'product_name',
                'value'=>$keyword,
                'type'=>'both',
            );
        }
        // For search
        if(!empty($category_id>0)){
            $param['where']['category_id'] = $category_id;
        }

        // For Category
        if(!empty($_GET['product_category_id'])  && $_GET['product_category_id'] != ''){
            $param['where']['product_category_id'] = $_GET['product_category_id'];
        }
        // For Brand
        if(!empty($_GET['product_brand_id'])  && $_GET['product_brand_id'] != ''){
            $param['where']['product_brand_id'] = $_GET['product_brand_id'];
        }
        // For Style
        if(!empty($_GET['product_style_id'])  && $_GET['product_style_id'] != ''){
            $param['where']['product_style_id'] = $_GET['product_style_id'];
        }


        //$param['where']['product_is_merchandise'] = STATUS_ACTIVE;
        // SORT
        if(!empty($_GET['sort'])  && $_GET['sort'] != ''){
            $param['order'] = 'product_name ' . $_GET['sort'];
        }
        else{
            $param['order'] = 'product_id DESC';
        }
        $param['limit'] = $limit;
        $param['offset'] = $offset;

        // debug($param,1);

        // Query data
        $data = $this->find_all_active($param);
        // debug($data,1);

        return $data;
    }

    public function get_total_count($params = array() , $keyword='', $category_id=0)
    {

        // debug($keyword,1);

        // For search
        if(!empty($keyword)){
            $params['where_like'][] = array(
                'column'=>'product_name',
                'value'=>$keyword,
                'type'=>'both',
            );
        }
        // For search
        if(!empty($category_id>0)){
            $params['where']['category_id'] = $category_id;
        }

        // $params['joins'][] = array(
        //     'table' => 'category',
        //     'joint' => 'category.category_id = product.product_category_id',
        //     'type' => 'right'
        // );


        // $params['where']['product_id'] = $id;
        // Set params
        $params['order'] = 'product_id DESC';


        return $this->find_count_active($params);
    }

    public function get_total_count_promotion($params = array() , $keyword='', $category_id=0)
    {

        // debug($keyword,1);

        // For search
        if(!empty($keyword)){
            $params['where_like'][] = array(
                'column'=>'product_name',
                'value'=>$keyword,
                'type'=>'both',
            );
        }
        // For search
        if(!empty($category_id>0)){
            $params['where']['category_id'] = $category_id;
        }

        $params['joins'][] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'right'
        );


        $params['where']['product_is_promotion'] = STATUS_ACTIVE;
        // Set params
        $params['order'] = 'product_id DESC';


        return $this->find_count_active($params);
    }


    // Get pagination data
    public function get_promotion_pagination_data($limit = '', $offset = '', $param = array() ,$keyword = '', $category_id=0)
    {
        $param['fields'] = "product_id,product_category_id,product_name,product_slug,product_price,product_overview,
        product_image,,product_image_thumb,product_image_path,product_createdon,category_name";
        $prefix = $this->db->dbprefix;

        // LEFT JOIN
        $param['joins'][] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'right'
        );
        // For search
        if(!empty($_GET['search'])  && $_GET['search'] != ''){
            $param['where_like'][] = array(
                'column'=>'product_name',
                'value'=>$keyword,
                'type'=>'both',
            );
        }
        // For search
        if(!empty($category_id>0)){
            $param['where']['category_id'] = $category_id;
        }
        $param['where']['product_is_promotion'] = STATUS_ACTIVE;
        $param['order'] = 'product_id DESC';
        $param['limit'] = $limit;
        $param['offset'] = $offset;

        // debug($param,1);

        // Query data
        $data = $this->find_all_active($param);
        // debug($data,1);

        return $data;
    }

    public function get_total_count_season($params = array() , $keyword='', $category_id=0)
    {

        // debug($keyword,1);

        // For search
        /*if(!empty($keyword)){
            $params['where_like'][] = array(
                'column'=>'product_name',
                'value'=>$keyword,
                'type'=>'both',
            );
        }*/
        // For search
        /*if(!empty($category_id>0)){
            $params['where']['category_id'] = $category_id;
        }

        // For Category
        if(!empty($_GET['product_category_id'])  && $_GET['product_category_id'] != ''){
            $params['where']['product_category_id'] = $_GET['product_category_id'];
        }
        // For Brand
        if(!empty($_GET['product_brand_id'])  && $_GET['product_brand_id'] != ''){
            $params['where']['product_brand_id'] = $_GET['product_brand_id'];
        }
        // For Style
        if(!empty($_GET['product_style_id'])  && $_GET['product_style_id'] != ''){
            $params['where']['product_style_id'] = $_GET['product_style_id'];
        }*/

        /*$params['joins'][] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'right'
        );*/

        // By type
        if(!empty($_GET['type'])  && $_GET['type'] == '1'){
            $params['where']['product_is_summer'] = STATUS_ACTIVE;
        }
        elseif(!empty($_GET['type'])  && $_GET['type'] == '2'){
            $params['where']['product_is_winter'] = STATUS_ACTIVE;
        }

        //$params['where']['product_is_merchandise'] = STATUS_ACTIVE;
        // Set params
        // SORT
        if(!empty($_GET['sort'])  && $_GET['sort'] != ''){
            $params['order'] = 'product_name ' . $_GET['sort'];
        }
        else{
            $params['order'] = 'product_id DESC';
        }


        return $this->find_count_active($params);
    }

    // Get pagination data
    public function get_pagination_data_season($limit = '', $offset = '', $param = array() ,$keyword = '', $category_id=0)
    {
        $param['fields'] = "product_id,product_category_id,product_name,product_slug,product_price,product_overview,
        product_image,,product_image_thumb,product_image_path,product_createdon,product_price";
        $prefix = $this->db->dbprefix;

        // LEFT JOIN
        /*$param['joins'][] = array(
            'table' => 'category',
            'joint' => 'category.category_id = product.product_category_id',
            'type' => 'right'
        );*/
        // For search
        /*if(!empty($_GET['search'])  && $_GET['search'] != ''){
            $param['where_like'][] = array(
                'column'=>'product_name',
                'value'=>$keyword,
                'type'=>'both',
            );
        }
        // For search
        if(!empty($category_id>0)){
            $param['where']['category_id'] = $category_id;
        }

        // For Category
        if(!empty($_GET['product_category_id'])  && $_GET['product_category_id'] != ''){
            $param['where']['product_category_id'] = $_GET['product_category_id'];
        }
        // For Brand
        if(!empty($_GET['product_brand_id'])  && $_GET['product_brand_id'] != ''){
            $param['where']['product_brand_id'] = $_GET['product_brand_id'];
        }
        // For Style
        if(!empty($_GET['product_style_id'])  && $_GET['product_style_id'] != ''){
            $param['where']['product_style_id'] = $_GET['product_style_id'];
        }


        $param['where']['product_is_merchandise'] = STATUS_ACTIVE;*/

        // By type
        if(!empty($_GET['type'])  && $_GET['type'] == '1'){
            $param['where']['product_is_summer'] = STATUS_ACTIVE;
        }
        elseif(!empty($_GET['type'])  && $_GET['type'] == '2'){
            $param['where']['product_is_winter'] = STATUS_ACTIVE;
        }
        // SORT
        if(!empty($_GET['sort'])  && $_GET['sort'] != ''){
            $param['order'] = 'product_name ' . $_GET['sort'];
        }
        else{
            $param['order'] = 'product_id DESC';
        }
        $param['limit'] = $limit;
        $param['offset'] = $offset;

        // debug($param,1);

        // Query data
        $data = $this->find_all_active($param);
        // debug($data,1);

        return $data;
    }

    public function get_product_by_id($id = 0 , $params = array())
    {
        // Return product by ID
        $id = intval($id);
        if(!$id)
            return false;

        $params['joins'][] = array( 
                                    "table"=>"product_image" ,
                                    "joint"=>"product_id = pi_product_id AND pi_is_featured = 1" , 
                                    "type"=>"left" ,
                                );
        $params['where']['product_id'] = $id;
        return $this->find_one($params);

    }

    public function get_product_by_cat_id($id = 0 , $params = array())
    {

        /*$params['joins'][] = array(
                                    "table"=>"product_image" ,
                                    "joint"=>"product_id = pi_product_id AND pi_is_featured = 1" ,
                                    "type"=>"left" ,
                                );*/
        $params['joins'][] = array(
            "table"=>"category" ,
            "joint"=>"category.category_id = product.product_category_id AND category_status = 1" ,
            "type"=>"left" ,
        );
        $params['fields'] = "product_id,product_category_id,product_name,product_slug,product_price,product_detail,product_image,
        product_image_thumb,product_image_path,product_status,category_name";
        $params['where']['product_category_id'] = $id;
        return $this->find_all_active($params);

    }

    // Check slug exists or not
    public function find_by_slug($slug)
    {
        $prefix = $this->db->dbprefix;

        // Set params

        /*$param['fields'] = "product_id,product_name,product_slug,product_description,product_image,product_image_thumb,product_image_path,product_createdon,

        (SELECT COUNT(comment_post_id) FROM ".$prefix."comment WHERE comment_post_id = product_id and comment_status=1) AS total_comments,product_category_name";*/

        /*$param['fields'] = "product_id,product_name,product_slug,product_description,product_image,product_image_thumb,product_image_path,product_createdon,

        (SELECT COUNT(comment_post_id) FROM ".$prefix."comment WHERE comment_post_id = product_id and comment_status=1) AS total_comments";*/



        // LEFT JOIN

        /*$param['joins'][] = array(

            "table"=>"product_category" ,

            "joint"=>"product_category.product_category_id = product.product_category_id and product_category.product_category_status =1",

            "type"=>"left"

        );*/



        $param['where']['product_slug'] = $slug;

        // Query

        $result = $this->find_one_active($param);



        // Return result;

        return $result;

    }

    public function get_fields( $specific_field = "" )
    {
        // Use when add new image
        $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';

        $fields = array(

        
                'product_id' => array(
                    'table'   => $this->_table,
                    'name'   => 'product_id',
                    'label'   => 'ID',
                    'type'   => 'hidden',
                    'type_dt'   => 'text',
                    'attributes'   => array(),
                    'dt_attributes'   => array("width"=>"5%"),
                    'js_rules'   => '',
                    'rules'   => 'trim'
                ),
                
                'product_name' => array(
                    'table'   => $this->_table,
                    'name'   => 'product_name',
                    'label'   => 'Title',
                    'type'   => 'text',
                    'attributes'   => array("additional"=>'slugify="#'.$this->_table.'-'.$this->_field_prefix.'slug"'),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim|htmlentities'
                ),
            
                'product_slug'  => array(
                    'table'   => $this->_table,
                    'name'   => 'product_slug',
                    'label'   => 'Slug',
                    'type'   => 'readonly',
                    'attributes'   => array(),
                    'js_rules'   => array("is_slug" => array() ),
                    'rules'   => 'required|htmlentities|strtolower|is_unique['.$this->_table.'.'.$this->_field_prefix.'slug]|callback_is_slug'
                ),           


                 'product_price' => array(
                    'table'   => $this->_table,
                    'name'   => 'product_price',
                    'label'   => 'Price',
                    'type'   => 'text',
                    'attributes'   => array(),
                    'list_data'   => array(),
                    'js_rules'   => 'required',
                    'rules'   => 'trim|required|htmlentities|regex_match[/^[\0-9\.]+$/]'
                ), 

                'product_url' => array(
                    'table'   => $this->_table,
                    'name'   => 'product_url',
                    'label'   => 'URL',
                    'type'   => 'text',
                    'attributes'   => array(),
                    'list_data'   => array(),
                    'js_rules'   => 'required',
                    'rules'   => 'trim|required|htmlentities'
                ),

                // 'product_stock_qty' => array(
                //     'table'   => $this->_table,
                //     'name'   => 'product_stock_qty',
                //     'label'   => 'Stock Quantity',
                //     'type'   => 'text',
                //     'attributes'   => array(),
                //     'list_data'   => array(),
                //     'js_rules'   => 'required',
                //     'rules'   => 'trim|required|htmlentities|regex_match[/^[\0-9\.]+$/]'
                // ),
           
                'product_rating' => array(
                        'table'   => $this->_table,
                        'name'   => 'product_rating',
                        'label'   => 'Rating',
                        'type'   => 'text',
                        'attributes'   => array(),
                        'list_data'   => array(),
                        'js_rules'   => '',
                        'rules'   => 'trim|htmlentities|regex_match[/^[\0-5\.]+$/]'
                    ),
                
                'product_overview' => array(
                    'table'   => $this->_table,
                    'name'   => 'product_overview',
                    'label'   => 'Short Description',
                    'type'   => 'editor',
                    'attributes'   => array(),
                    'js_rules'   => '',
                    'rules'   => ''
                ),

                'product_detail' => array(
                    'table'   => $this->_table,
                    'name'   => 'product_detail',
                    'label'   => 'Long Description',
                    'type'   => 'editor',
                    'attributes'   => array(),
                    'js_rules'   => '',
                    'rules'   => ''
                ),            
                
                
                'product_in_stock' => array(
                    'table'   => $this->_table,
                    'name'   => 'product_in_stock',
                    'label'   => 'In Stock?',
                    'type'   => 'switch',
                    'type_dt'   => 'dropdown',
                    'type_filter_dt' => 'dropdown',
                    'list_data_key' => "product_in_stock" ,
                    'list_data' => array(
                        0 => "<span class='label label-danger'>Out of Stock</span>" ,
                        1 =>  "<span class='label label-primary'>In Stock</span>"
                    ) ,
                    'default'   => '1',
                    'attributes'   => array(),
                    'dt_attributes'   => array("width"=>"7%"),
                    'rules'   => 'trim'
                ),                
                
            
            'product_status' => array(
                    'table'   => $this->_table,
                    'name'   => 'product_status',
                    'label'   => 'Status?',
                    'type'   => 'switch',
                    'type_dt'   => 'dropdown',
                    'type_filter_dt' => 'dropdown',
                    'list_data_key' => "product_status" ,
                    'list_data' => array(
                        0 => "<span class='label label-danger'>Inactive</span>" ,
                        1 =>  "<span class='label label-primary'>Active</span>"
                    ) ,
                    'default'   => '1',
                    'attributes'   => array(),
                    'dt_attributes'   => array("width"=>"7%"),
                    'rules'   => 'trim'
                ),

                'product_image' => array(
                    'table'   => $this->_table,
                    'name'   => 'product_image',
                    'label'   => 'Image',
                    'name_path'   => 'product_image_path',
                    'upload_config' => 'site_upload_product',
                    'type' => 'fileupload',
                    'thumb'   => array(array('name'=>'product_image_thumb','max_width'=>230, 'max_height'=>245),),
                    'attributes'   => array(
                        'allow_ext'=>'png|jpeg|jpg',
                        'Image Size'=>'800 x 600'
                    ),
                    'type_dt' => 'image',
                    'randomize' => true,
                    'preview' => 'true',
                    'dt_attributes' => array("width" => "10%"),
                    'rules' => 'trim|htmlentities',
                    // 'js_rules'   => $is_required_image,
                    'js_rules'   => '',
                ),            

            );
        
        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;
    }

}
?>