<?
class Model_other_service extends MY_Model
{
    /**
     * Service MODEL
     *
     * @package     Service Model
     * @author      
     * @version     1.0
     * @since       2017
     */

    protected $_table = 'other_service';
    protected $_field_prefix = 'other_service_';
    protected $_pk = 'other_service_id';
    protected $_status_field = 'other_service_status';
    public $relations = array();
    public $pagination_params = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        //$this->pagination_params['fields'] = "service_id,service_title,CONCAT(service_image_path,service_image) AS service_image,service_status";
        $this->pagination_params['fields'] = "other_service_id,other_service_status";

        parent::__construct();

    }

    // Get all active services





    /*
    * table             Table Name
    * Name              FIeld Name
    * label             Field Label / Textual Representation in form and DT headings
    * type              Field type : hidden, text, textarea, editor, etc etc. 
    *                                 Implementation in form_generator.php
    * type_dt           Type used by prepare_datatables method in controller to prepare DT value
    *                                 If left blank, prepare_datatable Will opt to use 'type'
    * type_filter_dt    Used by DT FILTER PREPRATION IN datatables.php
    * attributes        HTML Field Attributes
    * js_rules          Rules to be aplied in JS (form validation)
    * rules             Server side Validation. Supports CI Native rules

    * list_data         For dropdown etc, data in key-value pair that will populate dropdown 
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    * list_data_key     For dropdown etc, if you want to define list_data in CONTROLLER (public _list_data[$key]) list_data_key is the $key which identifies it
    *                   -----Incase list_data_key is not defined, it will look for field_name as a $key
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    */


    public function get_fields($specific_field = "")
    {

        $is_required_image = (($this->uri->segment(4) != null) && intval($this->uri->segment(4))) ? '' : 'required';

        $fields = array(
            'other_service_id' => array(
                'table' => $this->_table,
                'name' => 'other_service_id',
                'label' => 'ID',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => ''
            ),


            'other_service_name' => array(
                'table' => $this->_table,
                'name' => 'other_service_name',
                'label' => 'Title',
                'type' => 'text',
                 'attributes'   =>  array(),
                'js_rules' => '',
                'rules' => ''
            ),

         

            'service_status' => array(
                'table' => $this->_table,
                'name' => 'service_status',
                'label' => 'Status',
                'type' => 'switch',
                'type_dt' => 'dropdown',
                'type_filter_dt' => 'dropdown',
                'list_data_key' => "service_status",
                'list_data' => array(
                    0 => "<span class='label label-danger'>Inactive</span>",
                    1 => "<span class='label label-primary'>Active</span>"
                ),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;
    }

}
?>