<?
class Model_inquiry extends MY_Model {

	protected $_table    = 'inquiry';
    protected $_field_prefix    = 'inquiry_';
    protected $_pk    = 'inquiry_id';
    protected $_status_field    = 'inquiry_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page    = 20;

    function __construct()
    {  

        $this->pagination_params['fields'] = "inquiry_id,inquiry_email,inquiry_status";
		
      
        parent::__construct();
    }
    public function get_fields( )
    {
        return array(

            'inquiry_id'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_id',
                'label'   => 'ID',
                'primary'   => 'primary',
                'type'   => 'hidden',
                'attributes'   => array(),
                'js_rules'   => '',
                'rules'   => 'trim'
            ),

            'inquiry_firstname'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_firstname',
                'label'   => 'First Name',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => 'required',
                'rules'   => 'required|strtolower|trim|htmlentities'
            ),

            'inquiry_lastname'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_lastname',
                'label'   => 'Last Name',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => 'required',
                'rules'   => 'required|strtolower|trim|htmlentities'
            ),

            'inquiry_email'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_email',
                'label'   => 'Email',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => 'required',
                'rules'   => 'required|valid_email|strtolower|trim|htmlentities|is_unique['.$this->_table.'.'.$this->_field_prefix.'email]'
            ),

            'inquiry_occupation'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_occupation',
                'label'   => 'Occupation',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => 'required',
                'rules'   => 'required|strtolower|trim|htmlentities'
            ),

            'inquiry_website'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_website',
                'label'   => 'Website',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => 'required',
                'rules'   => 'required|strtolower|trim|htmlentities'
            ),

            'inquiry_country'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_country',
                'label'   => 'Country',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => 'required',
                'rules'   => 'required|strtolower|trim|htmlentities'
            ),

            'inquiry_ministry'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_ministry',
                'label'   => 'Ministry Name',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => 'required',
                'rules'   => 'required|strtolower|trim|htmlentities'
            ),

            'inquiry_ministry_role'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_ministry_role',
                'label'   => 'Ministry Role',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => 'required',
                'rules'   => 'required|strtolower|trim|htmlentities'
            ),

            'inquiry_about'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_about',
                'label'   => 'How did you learn about us?',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => 'required',
                'rules'   => 'required|strtolower|trim|htmlentities'
            ),

            'inquiry_comments'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_comments',
                'label'   => 'Message',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => 'required',
                'rules'   => 'required|strtolower|trim|htmlentities|'
            ),
            

            'inquiry_status'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_status',
                'label'   => 'Status',
                'type'   => 'switch',
                'type_dt'   => 'dropdown',
                'type_filter_dt' => 'dropdown',
                // 'list_data_key' => "inquiry_status" ,
                 'list_data' => array(
                     0 => "<span class='label label-danger'>Read</span>" ,
                     1 =>  "<span class='label label-primary'>Unread</span>"
                 ) ,
                'default'   => '1',
                'attributes'   => array(),
                'rules'   => 'trim'
            ),
       
			'inquiry_createdon'  => array(
                'table'   => $this->_table,
                'name'   => 'inquiry_createdon',
                'label'   => 'Createdon',
                'type'   => 'label',
                'attributes'   => array(),
                'rules'   => 'trim'
            ),


        );

    //     if($specific_field)

    //     return $fields[ $specific_field ];

    // else

    //     return $fields;


    }
}
?>