<?
class Model_find extends MY_Model {
  
    /**
     * find MODEL
     *
     * @package     find Model
     * 
     * @version     1.0
     * @since       2017 / Amazingly corrupt models Corporation Inc.
     */

    protected $_table    = 'find';
    protected $_field_prefix    = 'find_';
    protected $_pk    = 'find_id';
    protected $_status_field    = 'find_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "
        find_id,
        find_email,
        find_status";
        parent::__construct();
    }

    // Get unread inquiries
    public function get_unread_find()
    {
        // Set params
        $params['where_string'] = " find_status!=0";
        $result = $this->find_count($params);
        return $result;
    }

    public function get_records()
    {
        $params['fields'] = "MONTH(find_createdon) as month , COUNT(find_createdon) as count";
        $params['where_string'] = "find_createdon >= NOW() - INTERVAL 1 YEAR AND YEAR(find_createdon) = YEAR(CURRENT_DATE())";
        $params['group'] = "MONTH(find_createdon)";

        $result = $this->find_all($params);
        return $result;
    }

    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields( $specific_field = "" )
    {

        $fields = array(
        
              'find_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'find_id',
                     'label'   => 'id #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),
              'find_iam' => array(
                 'table'   => $this->_table,
                 'name'   => 'find_iam',
                 'label'   => 'I Am',
                 'type'   => 'text',
                 'attributes'   => array(),
                 'js_rules'   => '',
                 'rules'   => 'strtolower|trim|htmlentities|min_length[2]|max_length[10]'
              ),
              'find_lookingfor' => array(
                 'table'   => $this->_table,
                 'name'   => 'find_lookingfor',
                 'label'   => 'Looking For',
                 'type'   => 'text',
                 'attributes'   => array(),
                 'js_rules'   => '',
                 'rules'   => 'strtolower|trim|htmlentities|min_length[2]|max_length[10]'
              ),
            // 'find_fullname' => array(
            //     'table'   => $this->_table,
            //     'name'   => 'find_fullname',
            //     'label'   => 'Name',
            //     'type'   => 'text',
            //     'attributes'   => array(),
            //     'js_rules'   => '',
            //     'rules'   => 'required|strtolower|trim|htmlentities|min_length[2]|max_length[25]'
            // ),

            'find_email' => array(
                'table'   => $this->_table,
                'name'   => 'find_email',
                'label'   => 'Email',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => '',
                'rules'   => 'required|valid_email|strtolower|trim|htmlentities'
            ),
            // 'find_company' => array(
            //     'table'   => $this->_table,
            //     'name'   => 'find_company',
            //     'label'   => 'Company',
            //     'type'   => 'text',
            //     'attributes'   => array(),
            //     'js_rules'   => '',
            //     'rules'   => 'strtolower|trim|htmlentities'
            // ),
            // 'find_website' => array(
            //     'table'   => $this->_table,
            //     'name'   => 'find_website',
            //     'label'   => 'Website',
            //     'type'   => 'text',
            //     'attributes'   => array(),
            //     'js_rules'   => '',
            //     'rules'   => 'required|strtolower|trim|htmlentities'
            // ),
            // 'find_phone' => array(
            //          'table'   => $this->_table,
            //          'name'   => 'find_phone',
            //          'label'   => 'Phone',
            //          'type'   => 'text',
            //          'attributes'   => array(),
            //          'js_rules'   => '',
            //          'rules'   => 'trim|htmlentities|regex_match[/^[\d\(\)\-+ ]+$/]'
            //       ),

            //   'find_comments' => array(
            //          'table'   => $this->_table,
            //          'name'   => 'find_comments',
            //          'label'   => 'Message',
            //          'type'   => 'text',
            //          'attributes'   => array(),
            //          'js_rules'   => '',
            //          'rules'   => 'required|trim'
            //       ),

              // 'find_inche' => array(
              //        'table'   => $this->_table,
              //        'name'   => 'find_inche',
              //        'label'   => 'Inches',
              //        'type'   => 'text',
              //        'attributes'   => array(),
              //        'js_rules'   => '',
              //        'rules'   => 'required'
              //     ),
              
              // 'find_address' => array(
              //        'table'   => $this->_table,
              //        'name'   => 'find_address',
              //        'label'   => 'Address',
              //        'type'   => 'text',
              //        'attributes'   => array(),
              //        'js_rules'   => '',
              //        'rules'   => 'required|trim'
              //     ),
              /*
              'find_city' => array(
                     'table'   => $this->_table,
                     'name'   => 'find_city',
                     'label'   => 'City',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'required|trim'
                  ),
              'find_state' => array(
                     'table'   => $this->_table,
                     'name'   => 'find_state',
                     'label'   => 'State',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'required|trim'
                  ),
              'find_zip' => array(
                     'table'   => $this->_table,
                     'name'   => 'find_zip',
                     'label'   => 'Zip',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'required|trim'
                  ),*/
             /* 'find_subject' => array(
                'table'   => $this->_table,
                'name'   => 'find_subject',
                'label'   => 'Subject',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => '',
                'rules'   => 'required|trim'
            ),*/
              /*'find_about' => array(
                     'table'   => $this->_table,
                     'name'   => 'find_about',
                     'label'   => 'About Us',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                  ),*/



              /*'find_community' => array(
                     'table'   => $this->_table,
                     'name'   => 'find_community',
                     'label'   => 'Community',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => '|trim'
                  ),*/

              'find_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'find_status',
                     'label'   => 'Status',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt'   => 'dropdown',
                     'list_data' => array( 
                                        0 => "<span class=\"label label-danger\">Read</span>" ,
                                        1 =>  "<span class=\"label label-primary\">Unread</span>"  
                                    ) ,
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),


            'find_createdon' => array(
                'table'   => $this->_table,
                'name'   => 'find_createdon',
                'label'   => 'Created',
                'type'   => 'none',
                'type_dt'   => 'text',
                'attributes'   => array(),
                'dt_attributes'   => array("width"=>"10%"),
                'js_rules'   => '',
                'rules'   => 'trim'
            ),
              
            );

        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;

    }

}
?>