<?
class Model_course extends MY_Model
{
    /**
     * TKD course MODEL
     *
     * @package     course Model
     * @version     1.0
     * @since       2017
     */

    protected $_table = 'course';
    protected $_field_prefix = 'course_';
    protected $_pk = 'course_id';
    protected $_status_field = 'course_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "course_id,course_name,course_status";

        parent::__construct();
    }
    public function get_total_count($params = array(), $keyword = '')
    {

        // debug($keyword,1);

        // For search
        if (!empty($keyword)) {
            $params['where_like'][] = array(
                'column' => 'course_title',
                'value' => $keyword,
                'type' => 'both',
            );
        }

        $params['joins'][] = array(
            'table' => 'course_category',
            'joint' => 'course_category.course_category_id = course.course_category',
            'type' => 'right'
        );


        // $params['where']['course_id'] = $id;
        // Set params
        $params['order'] = 'course_id DESC';


        return $this->find_count_active($params);
    }

    // Get pagination data
    public function get_pagination_data($limit = '', $offset = '', $param = array(), $keyword = '')
    {
        $prefix = $this->db->dbprefix;

        $param['fields'] = "*,(select count(*) from yt_comment where comment_post_id=course_id and comment_status=1) as comments_count";

        // LEFT JOIN
        $param['joins'][] = array(
            'table' => 'course_category',
            'joint' => 'course_category.course_category_id = course.course_category',
            'type' => 'right'
        );
        // For search
        if (!empty($_GET['search']) && $_GET['search'] != '') {
            $param['where_like'][] = array(
                'column' => 'course_title',
                'value' => $keyword,
                'type' => 'both',
            );
        }
        $param['order'] = 'course_id DESC';
        $param['limit'] = $limit;
        $param['offset'] = $offset;

        // debug($param,1);

        // Query data
        $data = $this->find_all_active($param);
        // debug($data,1);

        return $data;
    }

    public function get_page_course($page = '')
    {
        // Set params
        $params['fields'] = 'course_page,course_title,course_category,course_image_path,course_image,course_status';
        $params['where']['course_page'] = $page;
        return $this->model_course->find_one_active($params);

    }

    // Check slug exists or not
    public function find_by_slug($slug)
    {
        $prefix = $this->db->dbprefix;

        // Set params

        /*$param['fields'] = "course_id,course_name,course_slug,course_detail,course_image,course_image_thumb,course_image_path,course_createdon,

        (SELECT COUNT(comment_post_id) FROM ".$prefix."comment WHERE comment_post_id = course_id and comment_status=1) AS total_comments,course_category_name";*/

        // $param['fields'] = "course_id,course_name,course_slug,course_detail,course_image,course_image_detail1,course_date,course_image_thumb,course_image_path,course_createdon,

        // (SELECT COUNT(comment_post_id) FROM ".$prefix."comment WHERE comment_post_id = course_id and comment_status=1) AS total_comments";



        // LEFT JOIN

        /*$param['joins'][] = array(

            "table"=>"course_category" ,

            "joint"=>"course_category.course_category_id = course.course_category_id and course_category.course_category_status =1",

            "type"=>"left"

        );*/



        $param['where']['course_slug'] = $slug;

        // Query

        $result = $this->find_one_active($param);



        // Return result;

        return $result;

    }

    // Get news comments
    public function get_comments($slug)
    {
        // Set params
        $params['fields'] = "course_id,course_title,comment_post_id,comment_name,comment_description,comment_created_on";
        $params['where']['course_slug'] = $slug;
        // Join
        $params['joins'][] = array(
            "table" => "comment",
            "joint" => "course.course_id = comment_post_id and comment_status=1",
        );
        $params['order'] = 'comment_id DESC';

        return $this->model_course->find_all_active($params);
    }

    /*
     * table       Table Name
     * Name        FIeld Name
     * label       Field Label / Textual Representation in form and DT headings
     * type        Field type : hidden, text, textarea, editor, etc etc. 
     *                           Implementation in form_generator.php
     * type_dt     Type used by prepare_datatables method in controller to prepare DT value
     *                           If left blank, prepare_datatable Will opt to use 'type'
     * attributes  HTML Field Attributes
     * js_rules    Rules to be aplied in JS (form validation)
     * rules       Server side Validation. Supports CI Native rules
     */
    public function get_fields($specific_field = "")
    {
        // Use when add new image
        $is_required_image = (($this->uri->segment(4) != null) && intval($this->uri->segment(4))) ? '' : 'required';

        $fields = array(

            'course_id' => array(
                'table' => $this->_table,
                'name' => 'course_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),

            //    'course_category_id' => array(
            //          'table'   => $this->_table,
            //          'name'   => 'course_category_id',
            //          'label'   => 'Category',
            //          'type'   => 'dropdown',
            //          'list_data' => array(),
            //          'attributes'   => array(),
            //          'js_rules'   => 'required',
            //          'rules'   => 'required|trim'
            //      ),

            // 'course_heading' => array(
//                      'table'   => $this->_table,
//                      'name'   => 'course_heading',
//                      'label'   => 'heading',
//                      'type'   => 'text',
//                      'attributes'   => array(),
//                      'js_rules'   => 'required',
//                      'rules'   => 'required|trim|htmlentities'
//             ),
                'course_slots' => array(
                    'table' => $this->_table,
                    'name' => 'course_slots',
                    'label' => 'Selected Slots',
                    'type' => 'multiselect_custom',
                    'attributes' => array(),
                    'list_data' => array(
                            '1' => 'Morning/Evening',
                            '2' => 'Weekend',
                            '3' => 'Morning',
                            '4'=> 'Evening',
                            '5' => 'Morning/Afternoon',
                            '6' => 'Afternoon',
                            '7' => 'Weekend (EKG)',
                            '8' => 'Weekend (Phlebotomy)'
                        ),
                    'js_rules' => '',
                    'rules' => 'strtolower|trim|htmlentities',
                ),
            'course_name' => array(
                'table' => $this->_table,
                'name' => 'course_name',
                'label' => 'Title',
                'type' => 'text',
                'attributes' => array("additional" => 'slugify="#' . $this->_table . '-' . $this->_field_prefix . 'slug"'),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),
            'course_slug' => array(
                'table' => $this->_table,
                'name' => 'course_slug',
                'label' => 'Slug',
                'type' => 'readonly',
                'attributes' => array(),
                'js_rules' => array("is_slug" => array()),
                'rules' => 'required|htmlentities|strtolower|is_unique[' . $this->_table . '.' . $this->_field_prefix . 'slug]|callback_is_slug'
            ),
            'course_price' => array(
                'table' => $this->_table,
                'name' => 'course_price',
                'label' => 'Full Price',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => 'required',
                'trim|required|htmlentities|regex_match[/^[\0-9\.]+$/]',
            ),
            'course_partial_price' => array(
                'table' => $this->_table,
                'name' => 'course_partial_price',
                'label' => 'Partial Price',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => 'required',
                'trim|required|htmlentities|regex_match[/^[\0-9\.]+$/]',
            ),
            'course_location' => array(
                'table' => $this->_table,
                'name' => 'course_location',
                'label' => 'Location',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
            ),
            // 'course_video_qty' => array(
            //     'table' => $this->_table,
            //     'name' => 'course_video_qty',
            //     'label' => 'Allow Video Qty',
            //     'type' => 'text',
            //     'attributes' => array(),
            //     'js_rules' => 'required',
            //     'rules' => 'required|trim|htmlentities'
            // ),
            // 'course_date' => array(
            //     'table' => $this->_table,
            //     'name' => 'course_date',
            //     'label' => 'Date',
            //     'type' => 'custom_date',
            //     'attributes' => array(),
            //     'js_rules' => 'required',
            //     'rules' => 'required|trim|htmlentities'
            // ),

            'course_detail' => array(
                'table' => $this->_table,
                'name' => 'course_detail',
                'label' => 'Short Description',
                'type' => 'editor',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),


            'course_detail1' => array(
                'table' => $this->_table,
                'name' => 'course_detail1',
                'label' => 'Long Description',
                'type' => 'editor',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),
            
            'course_payment_schedule' => array(
                'table' => $this->_table,
                'name' => 'course_payment_schedule',
                'label' => 'Payment Schedule',
                'type' => 'editor',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            // 'course_requirements' => array(
            //     'table' => $this->_table,
            //     'name' => 'course_requirements',
            //     'label' => 'Requirements',
            //     'type' => 'editor',
            //     'attributes' => array(),
            //     'js_rules' => 'required',
            //     'rules' => 'required|trim|htmlentities'
            // ),

            // 'course_learning' => array(
            //     'table' => $this->_table,
            //     'name' => 'course_learning',
            //     'label' => "What You ll Learn",
            //     'type' => 'editor',
            //     'attributes' => array(),
            //     'js_rules' => 'required',
            //     'rules' => 'required|trim|htmlentities'
            // ),

            'course_image' => array(
                'table' => $this->_table,
                'name' => 'course_image',
                'label' => 'Image',
                'name_path' => 'course_image_path',
                'upload_config' => 'site_upload_course',
                'type' => 'fileupload',
                'type_dt' => 'image',
                'randomize' => true,
                'preview' => 'true',
                'thumb' => array(array('name' => 'course_image_thumb', 'max_width' => 470, 'max_height' => 316), ),
                'attributes' => array(
                    'image_size_recommended' => '370px × 225px',
                    'allow_ext' => 'png|jpeg|jpg|webp',
                ),
                'dt_attributes' => array("width" => "10%"),
                'rules' => 'trim|htmlentities',
                'js_rules' => '',
            ),


            'course_logo' => array(
                'table' => $this->_table,
                'name' => 'course_logo',
                'label' => 'Logo Image',
                'name_path' => 'course_image_path',
                'upload_config' => 'site_upload_course',
                'type' => 'fileupload',
                'type_dt' => 'image',
                'randomize' => true,
                'preview' => 'true',
                'thumb' => array(array('name' => 'course_image_thumb', 'max_width' => 470, 'max_height' => 316), ),
                'attributes' => array(
                    'image_size_recommended' => '370px × 225px',
                    'allow_ext' => 'png|jpeg|jpg|webp',
                ),
                'dt_attributes' => array("width" => "10%"),
                'rules' => 'trim|htmlentities',
                'js_rules' => '',
            ),



            // 'course_image_detail1' => array(
            //     'table' => $this->_table,
            //     'name' => 'course_image_detail1',
            //     'label' => 'course Banner Image',
            //     'name_path' => 'course_image_path',
            //     'upload_config' => 'site_upload_course',
            //     'type' => 'fileupload',
            //     'type_dt' => 'image',
            //     'randomize' => true,
            //     'preview' => 'true',

            //     'attributes'   => array(
            //         'image_size_recommended'=>'540px × 370px',
            //         'allow_ext'=>'png|jpeg|jpg',
            //     ),
            //     'dt_attributes' => array("width" => "10%"),
            //     'rules' => 'trim|htmlentities',
            //    'js_rules'=>$is_required_image
            // ),

            // 'course_image_detail2' => array(
            //     'table' => $this->_table,
            //     'name' => 'course_image_detail2',
            //     'label' => 'Image 2 Detail Page',
            //     'name_path' => 'course_image_path',
            //     'upload_config' => 'site_upload_course',
            //     'type' => 'fileupload',
            //     'type_dt' => 'image',
            //     'randomize' => true,
            //     'preview' => 'true',

            //     'attributes'   => array(
            //         'image_size_recommended'=>'540px × 370px',
            //         'allow_ext'=>'png|jpeg|jpg',
            //     ),
            //     'dt_attributes' => array("width" => "10%"),
            //     'rules' => 'trim|htmlentities',
            //    // 'js_rules'=>$is_required_image
            // ),
            // 'course_image_detail12' => array(
            //     'table' => $this->_table,
            //     'name' => 'course_image_detail12',
            //     'label' => 'Image 3 Detail Page',
            //     'name_path' => 'course_image_path',
            //     'upload_config' => 'site_upload_course',
            //     'type' => 'fileupload',
            //     'type_dt' => 'image',
            //     'randomize' => true,
            //     'preview' => 'true',

            //     'attributes'   => array(
            //         'image_size_recommended'=>'540px × 370px',
            //         'allow_ext'=>'png|jpeg|jpg',
            //     ),
            //     'dt_attributes' => array("width" => "10%"),
            //     'rules' => 'trim|htmlentities',
            //    // 'js_rules'=>$is_required_image
            // ),

            /*'course_by' => array(
                   'table' => $this->_table,
                   'name' => 'course_by',
                   'label' => 'By',
                   'type' => 'text',
                   'attributes' => array(),
                   'js_rules' => 'required',
                   'rules' => 'required|trim|htmlentities'
               ),*/

            // 'course_latest_featured' => array(
            //            'table' => $this->_table,
            //            'name' => 'course_latest_featured',
            //            'label' => 'Is Featured?',
            //            'type' => 'switch',
            //            'type_dt' => 'dropdown',
            //            'type_filter_dt' => 'dropdown',
            //            'list_data_key' => "course_latest_featured" ,
            //            'list_data' => array(),
            //            'default' => '0',
            //            'attributes' => array(),
            //            'dt_attributes' => array("width" => "7%"),
            //            'rules' => 'trim'
            //        ),
            'course_status' => array(
                'table' => $this->_table,
                'name' => 'course_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>