<?
class Model_booking extends MY_Model
{
    /**
     * TKD booking MODEL
     *
     * @package     booking Model
     * @version     1.0
     * @since       2017
     */

    protected $_table = 'booking';
    protected $_field_prefix = 'booking_';
    protected $_pk = 'booking_id';
    protected $_status_field = 'booking_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] ="booking_id,booking_course_id,booking_userid,booking_payment_status,booking_amount,booking_status";
       

        parent::__construct();
    }


    /*
     * table       Table Name
     * Name        FIeld Name
     * label       Field Label / Textual Representation in form and DT headings
     * type        Field type : hidden, text, textarea, editor, etc etc. 
     *                           Implementation in form_generator.php
     * type_dt     Type used by prepare_datatables method in controller to prepare DT value
     *                           If left blank, prepare_datatable Will opt to use 'type'
     * attributes  HTML Field Attributes
     * js_rules    Rules to be aplied in JS (form validation)
     * rules       Server side Validation. Supports CI Native rules
     */
    public function get_fields($specific_field = "")
    {
        // Use when add new image
        $is_required_image = (($this->uri->segment(4) != null) && intval($this->uri->segment(4))) ? '' : 'required';

        $fields = array(

            'booking_id' => array(
                'table' => $this->_table,
                'name' => 'booking_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),
            'booking_amount' => array(
                'table' => $this->_table,
                'name' => 'booking_amount',
                'label' => 'Amount',
                'type' => 'readonly',
                'default' => '',
                'attributes' => array(),
                'rules' => 'trim'
            ),
            'booking_amount_type' => array(
                'table' => $this->_table,
                'name' => 'booking_amount_type',
                'label' => 'Payment Type',
                'type' => 'dropdown',
                'list_data'=>array(
                    '1'=>'Full',
                    '2'=>'Partial',
                  
                ),
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|strtolower|trim|htmlentities'
            ),
            'booking_course_id' => array(
                'table' => $this->_table,
                'name' => 'booking_course_id',
                'label' => 'Course',
                'type' => 'dropdown',
                'type_dt' => 'dropdown',
                'type_filter_dt' => 'dropdown',
                'js_rules' => 'required',
                'list_data' => array(),
                'rules' => 'required|trim'
            ),
            'booking_time_slots' => array(
                'table' => $this->_table,
                'name' => 'booking_time_slots',
                'label' => 'Time Slots',
                'type' => 'hidden',
                'type_dt' => 'dropdown',
                'type_filter_dt' => 'dropdown',
                'js_rules' => 'required',
                'list_data' => array(),
                'rules' => 'required|trim'
            ),

            'booking_userid' => array(
                'table' => $this->_table,
                'name' => 'booking_userid',
                'label' => 'User',
                'type' => 'dropdown',
                'type_dt' => 'dropdown',
                'type_filter_dt' => 'dropdown',
                'js_rules' => 'required',
                'list_data' => array(),
                'rules' => 'required|trim'
            ),


            'booking_payment_status' => array(

                'table' => $this->_table,

                'name' => 'booking_payment_status',

                'label' => 'Payment Status',

                'type' => 'dropdown',

                'type_dt' => 'dropdown',

                // 'default' => '2',

                'list_data' => array(

                    // 0 => "<span class=\"label label-order-place\">Order Placed</span>",

                    1 => "<span class=\"label label-order-completed\">Completed</span>",

                    2 => "<span class=\"label label-order-pending\">Pending</span>",

                    3 => "<span class=\"label label-order-processing\">Processing</span>",

                    4 => "<span class=\"label label-order-denied\">Dispatched</span>",

                    5 => "<span class=\"label label-order-failed\">Hold</span>",

                    6 => "<span class=\"label label-order-reversed\">Cancelled</span>",

                    7 => "<span class=\"label label-order-declined\">Card Declined</span>",

                    8 => "<span class=\"label label-order-refunded\">Refunded</span>"

                ),

                'type_filter_dt' => 'dropdown',

                'attributes' => array(),

                'rules' => 'trim|htmlentities'

            ),

            'booking_createdat' => array(
                'table' => $this->_table,
                'name' => 'booking_createdat',
                'label' => 'Booking Date',
                'type' => 'readonly',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => ''
            ),
 

            'booking_status' => array(
                'table' => $this->_table,
                'name' => 'booking_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>