<?
class Model_blog_detial extends MY_Model
{
    /**
     * blog_detial MODEL
     *
     * @package     blog_detial Model
     * @author      
     * @version     1.0
     * @since       2017
     */

    protected $_table = 'blog_detial';
    protected $_field_prefix = 'blog_detial_';
    protected $_pk = 'blog_detial_id';
    protected $_status_field = 'blog_detial_status';
    public $relations = array();
    public $pagination_params = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        //$this->pagination_params['fields'] = "blog_detial_id,blog_detial_title,CONCAT(blog_detial_image_path,blog_detial_image) AS blog_detial_image,blog_detial_status";
        $this->pagination_params['fields'] = "blog_detial_id,blog_detial_title,blog_detial_status";

        parent::__construct();

    }

    // Get all active blog_detials
 





    /*
    * table             Table Name
    * Name              FIeld Name
    * label             Field Label / Textual Representation in form and DT headings
    * type              Field type : hidden, text, textarea, editor, etc etc. 
    *                                 Implementation in form_generator.php
    * type_dt           Type used by prepare_datatables method in controller to prepare DT value
    *                                 If left blank, prepare_datatable Will opt to use 'type'
    * type_filter_dt    Used by DT FILTER PREPRATION IN datatables.php
    * attributes        HTML Field Attributes
    * js_rules          Rules to be aplied in JS (form validation)
    * rules             Server side Validation. Supports CI Native rules

    * list_data         For dropdown etc, data in key-value pair that will populate dropdown 
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    * list_data_key     For dropdown etc, if you want to define list_data in CONTROLLER (public _list_data[$key]) list_data_key is the $key which identifies it
    *                   -----Incase list_data_key is not defined, it will look for field_name as a $key
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    */

    public function get_fields($specific_field = "")
    {

        $is_required_image = (($this->uri->segment(4) != null) && intval($this->uri->segment(4))) ? '' : 'required';

        $fields = array(
            'blog_detial_id' => array(
                'table' => $this->_table,
                'name' => 'blog_detial_id',
                'label' => 'ID',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => ''
            ),


            'blog_detial_blog_id' => array(
                'table' => $this->_table,
                'name' => 'blog_detial_blog_id',
                'label' => 'Blog Id',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'required'
            ),


            'blog_detial_title' => array(
                'table' => $this->_table,
                'name' => 'blog_detial_title',
                'label' => 'Title',
                'type' => 'text',
                 'attributes'   => '',
                'js_rules' => '',
                'rules' => 'required'
            ),

                'blog_detial_detail' => array(
                'table' => $this->_table,
                'name' => 'blog_detial_detail',
                'label' => 'Description',
                'type' => 'editor',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'required'
            ),

        

            
            'blog_detial_image' => array(
                'table' => $this->_table,
                'name' => 'blog_detial_image',
                'label' => 'Image',
                'name_path' => 'blog_detial_image_path',
                'upload_config' => 'site_upload_blog',
                //'type' => $image_status,
                'type' => 'fileupload',
                //'type' => (!empty($is_required_image)?'password':'hidden'),
                'type_dt' => 'image',
                'randomize' => true,
                'preview' => 'true',
                'attributes'   => array(
                    'allow_ext'=>'png|jpeg|jpg',
                    'image_size_recommended'=>'635px × 800px',
                    //'Recommended size' => '490px X 520px'
                ),
                'dt_attributes' => array("width" => "10%"),
                'rules' => 'trim|htmlentities',
            ),
     


            'blog_detial_status' => array(
                'table' => $this->_table,
                'name' => 'blog_detial_status',
                'label' => 'Status',
                'type' => 'switch',
                'type_dt' => 'dropdown',
                'type_filter_dt' => 'dropdown',
                'list_data_key' => "blog_detial_status",
                'list_data' => array(
                    0 => "<span class='label label-danger'>Inactive</span>",
                    1 => "<span class='label label-primary'>Active</span>"
                ),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;
    }

}
?>