<?
class Model_blog_category extends MY_Model {
    /**
     * TKD blog_category MODEL
     *
     * @package     blog_category Model
     * 
     * @version     2.0
     * @since       2015 / Amazingly corrupt models Corporation Inc.
     */

    protected $_table    = 'blog_category';
    protected $_field_prefix    = 'blog_category_';
    protected $_pk    = 'blog_category_id';
    protected $_status_field    = 'blog_category_status';
    public $relations = array();
    public $pagination_params = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor
//        $this->pagination_params['fields'] = "{pre}blog_category.blog_category_id,{pre}blog_category.blog_category_type,{pre}blog_category.blog_category_name,
        $this->pagination_params['fields'] = "blog_category_id,blog_category_name,blog_category_status";
                                                
        /*$this->pagination_params['joins'][] = array(
                                                    "table"=>"blog_category AS parent_cat" , 
                                                    "joint"=>"blog_category.blog_category_parent_id = parent_cat.blog_category_id", 
                                                    "type"=>"left" 
                                                );*/

        
        //$this->pagination_params['where']['blog_category.blog_category_parent_id >'] = 0 ;
        parent::__construct();

    }

    // Get latest categories
    //public function get_recent_categories($limit=5)
    public function get_recent_categories($type)
    {
        switch ($type){
            // Accessories
            case 1:
                $and = " and product_is_accessories=1";
                break;
            case 2:
                $and = " and product_is_merchandise=1";
                break;
            case 3:
                $and = " and product_is_summer=1";
                break;
            case 4:
                $and = " and product_is_winter=1";
                break;
            default:
                $and = "";
        }
        // Set params
        $params['fields'] = "blog_category_id,blog_category_name,blog_category_slug,(select count(*) from sbf_product where product_blog_category_id=blog_category_id and product_status = 1 $and) as cat_count";

        $params['order'] = 'blog_category_name ASC';
        //$params['limit'] = $limit;
        // Query
        $result = $this->find_all_active($params);

        // Return result
        return $result;
    }

    // Check slug exists or not
    public function find_by_slug($slug)
    {
        // Set params   
        $param['where']['blog_category_slug'] = $slug;
        $result = $this->find_one_active($param);
        return $result;
    }
    // Check slug exists or not
    public function find_by_slug_all($slug)
    {
        // Set params
        $param['where']['blog_category_slug'] = $slug;
        // Query
        $result = $this->find_one_active($param);

        // Return result;
        return $result;
    }



    /*
    * table             Table Name
    * Name              FIeld Name
    * label             Field Label / Textual Representation in form and DT headings
    * type              Field type : hidden, text, textarea, editor, etc etc. 
    *                                 Implementation in form_generator.php
    * type_dt           Type used by prepare_datatables method in controller to prepare DT value
    *                                 If left blank, prepare_datatable Will opt to use 'type'
    * type_filter_dt    Used by DT FILTER PREPRATION IN datatables.php
    * attributes        HTML Field Attributes
    * js_rules          Rules to be aplied in JS (form validation)
    * rules             Server side Validation. Supports CI Native rules
    * 
    * list_data         For dropdown etc, data in key-value pair that will populate dropdown 
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    * list_data_key     For dropdown etc, if you want to define list_data in CONTROLLER (public _list_data[$key]) list_data_key is the $key which identifies it
    *                   -----Incase list_data_key is not defined, it will look for field_name as a $key
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    */
    public function get_fields( $specific_field = "" )
    {

        $fields = array(
        
              'blog_category_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'blog_category_id',
                     'label'   => 'id #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),           
         

              'blog_category_name' => array(
                     'table'   => $this->_table,
                     'name'   => 'blog_category_name',
                     'label'   => 'Name',
                     'type'   => 'text',
                     'attributes'   => array("additional"=>'slugify="#'.$this->_table.'-'.$this->_field_prefix.'slug"'),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim|htmlentities'
                  ),             
              
              'blog_category_slug'  => array(
                  'table'   => $this->_table,
                  'name'   => 'blog_category_slug',
                  'label'   => 'Slug',
                  'type'   => 'readonly',
                  'attributes'   => array(),
                  'js_rules'   => array("is_slug" => array() ),
                  'rules'   => 'required|htmlentities|is_unique['.$this->_table.'.'.$this->_field_prefix.'slug]|callback_is_slug|strtolower'
              ),   

            //   'blog_category_short_description' => array(
            //     'table' => $this->_table,
            //     'name' => 'blog_category_short_description',
            //     'label' => 'Short Description',
            //     'type' => 'editor',
            //     'attributes' => array(),
            //     'js_rules' => '',
            //     'rules' => 'trim|htmlentities'
            // ),
              
              'blog_category_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'blog_category_status',
                     'label'   => 'Status?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "blog_category_status" ,
                      'list_data' => array(
                          0 => "<span class='label label-danger'>Inactive</span>" ,
                          1 =>  "<span class='label label-primary'>Active</span>"
                      ) ,
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),
              
            );
        
        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;
    }

}
?>