<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Rfq extends MY_Controller {

	/**
	 * CSL Achievements page
	 *
	 * @package		Rfq
	 *
     * @version		1.0 --
     * @since		Version 1.0 2017
	 */

    public $_list_data = array();

	public function __construct() {

		global $config;
		
		parent::__construct();
        $this->dt_params['dt_headings'] = "
        rfq_id,
        rfq_email,
        rfq_createdon,
        rfq_quotation_status,
        rfq_status";
        $this->dt_params['searchable'] = array("rfq_id","rfq_fullname","rfq_email","rfq_status");
        $this->dt_params['action'] = array(
                                        "hide_upload_button" => true,
										"hide_add_button" => true ,
                                        "show_delete" => false ,
                                        "hide" => false ,
                                        "order_field" => false ,
                                        "show_view" => true ,
                                        "extra" => array(
                                            // '<button title="Reply / Send Quote" data-href="'.$config['admin_base_url'].$class.'/ajax_view/'.$itemId.'/" class="btn-xs btn btn_view_product btn-primary" data-pk="'.$itemId.'"><i class="fa fa-reply" aria-hidden="true"></i></button>'
                                            ) ,
                                      );
        // Following are common so, defined in MY_Controller_Admin
		// $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
		// $this->dt_params['paginate']['uri'] = "paginate";
		// $this->dt_params['paginate']['update_status_uri'] = "update_status";

		// For use IN JS Files

		$config['js_config']['paginate'] = $this->dt_params['paginate'];

		$_POST = $this->input->post(NULL, false);
	}

	public function add($id='', $data=array())
	{
        redirect(g('admin_base_url') . "rfq");
		//parent::add($id, $data=array());
	}
	
	public function reply(){
	   global $config;
		
		$class_name = $this->router->class;
		$model_name = "model_".$class_name;

		$model_obj = $this->$model_name ;
		//$pg_config['order_field'] = $model_obj->get_order_field_name();

		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													$class_name => humanize($class_name),
												)
											);

		$this->register_plugins( array(						
										"jquery-ui",
										"bootstrap",
										"bootstrap-hover-dropdown",
										"jquery-slimscroll",
										"uniform",
										"bootstrap-switch",
										"bootstrap-datepicker",
										"boots",
										"font-awesome",
										"simple-line-icons" ,
										"select2",
										"datatables",
										"bootbox",
										"bootstrap-toastr",
										"ckeditor",

								));

		$this->add_script("pages/tasks.css");
		$this->add_script(array("table-ajax.js" , "datatable.js") , "js");
		
	    $data['rfq'] = $this->model_rfq->find_by_pk($_GET['id']);
	    $whereParam['where']['quotations_rfq_id'] = $_GET['id'];
	    $data['quotation'] = $this->model_quotations->find_one($whereParam); 
	    $param01['where']['product_sku'] = $data['rfq']['rfq_product_sku'];
	    $param01['fields'] = 'product_partno,product_detail,product_sku,product_sale_price,product_id,product_condition';
	    $data['product_detail'] = $this->model_product->find_one($param01);
	   // debug($this->layout_data,1);
	   //debug($this->register_plugins(),1);
	    $this->load_view('reply_rfq',$data);
	   // debug($data,1);
	}
	
	public function quote_gen(){
	    
	   // debug($_POST,1);
	    $rfqId = $this->input->post('rfq_id');
	   // debug($rfqId,1);
	   // $rfqData = $this->model_rfq->find_by_pk($rfqId);
	    $whereParam['where']['quotations_rfq_id'] = $rfqId;
	    $quotationData = $this->model_quotations->find_one($whereParam);
	   // debug($quotationData,1);
	   //debug($insertParam,1);
	    $insertParam['quotations_rfq_id'] = $rfqId;
        $insertParam['quotations_billto'] = $this->input->post('bill_to');
        $insertParam['quotations_shipto'] = $this->input->post('ship_to');
        $insertParam['quotations_email'] = $this->input->post('email');
        $insertParam['quotations_product_partno'] = $this->input->post('part_no');
        $insertParam['quotations_product_sku'] = $this->input->post('sku');
        $insertParam['quotations_delivery'] = $this->input->post('delivery_type');
        $insertParam['quotations_sales_rep'] = $this->input->post('sales_rep');
        $insertParam['quotations_note'] = $this->input->post('note');
        $insertParam['quotations_terms'] = $this->input->post('terms');
        $insertParam['quotations_description'] = $this->input->post('description');
        $insertParam['quotations_product_unit_price'] = $this->input->post('unit_price');
        $insertParam['quotations_qty'] = $this->input->post('quantity');
        $insertParam['quotations_condition'] = $this->input->post('condition');   
        $insertParam['quotations_subtotal'] = $insertParam['quotations_product_unit_price'] * $insertParam['quotations_qty'];
        $insertParam['quotations_total'] = $insertParam['quotations_product_unit_price'] * $insertParam['quotations_qty'];
        $rfqUpdateParam['rfq_quotation_status'] = 1;
	   if($quotationData){
            $this->model_quotations->update_by_pk($quotationData['quotations_id'], $insertParam);
	   }
        else
        {
            $insertedId = $this->model_quotations->insert_record($insertParam);
	        $updateParam['quotations_number'] = "CT-QT-".$insertedId;
            $this->model_quotations->update_by_pk($insertedId, $updateParam);
        }
        
        $quotationData = $this->model_quotations->find_one($whereParam);
        parent::create_quote_pdf($quotationData);
        // debug($quotationData,1);
	    $template = $this->load->view("_layout/email_template/quote_layout", $quotationData, true);
	    $title = "CrispTechllc - Quotation";
	   // $response = $this->model_email->quote_email_temp('rydaholic@gmail.com',$template,$title);
	    $response = $this->model_email->quote_email_temp($quotationData['quotations_email'],$template,$title);
	    if($response == true)
	    {
	        $rfqUpdateParam['rfq_quotation_status'] = 1;
            $this->model_rfq->update_by_pk($rfqId,$rfqUpdateParam);
	        $param['txt'] = "Quote sent successfully..";
	        $param['status'] = 1;
	    }
	    else{
	        $param['txt'] = "Quote generation failed. Please contact support..";
	        $param['status'] = 0;
	    }
	    echo json_encode($param);
	}
	
	

	public function ajax_view($id='')
	{
		if($id)
		{
			$this->model_rfq->update_by_pk($id, array("rfq_status" => 0));
		}
		parent::ajax_view($id);
	}

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
