<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Quotations extends MY_Controller {

    /**
     * CSL Achievements page
     *
     * @package     quotations
     *
     * @version     1.0 --
     * @since       Version 1.0 2017
     */

    public $_list_data = array();

    public function __construct() {

        global $config;
        
        parent::__construct();
        $this->dt_params['dt_headings'] = "quotations_id, quotations_number, quotations_email, quotations_product_sku";
       
        $this->dt_params['searchable'] = array("quotations_id","quotations_status");
        // $this->dt_params['action'] = array(
        //                                 "hide_add_button" => true ,
        //                                 "show_delete" => true ,
        //                                 "hide" => false ,
        //                                 "order_field" => false ,
        //                                 "show_view" => true ,
        //                                 "extra" => array() ,
        //                               );


        $this->dt_params['action'] = array(

                                        "hide_add_button" => false ,

                                        "hide" => false ,

                                        "show_delete" => false ,
                                        
                                        "hide_upload_button" => true,

                                        "show_edit" => true ,

                                        "order_field" => false ,

                                        "show_view" => false ,

                                        "extra" => array(
                                        	'<a title="View" target="_blank" href="'.$config['admin_base_url'].'quotations/detail/%d/" class="btn-icon-only btn btn-primary order_details_btn"><i class="btn-icon-only icon-picture"></i></a>',
                                        	
                                		) ,
                                      );
        // Following are common so, defined in MY_Controller_Admin
        // $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
        // $this->dt_params['paginate']['uri'] = "paginate";
        // $this->dt_params['paginate']['update_status_uri'] = "update_status";

        // For use IN JS Files

        $config['js_config']['paginate'] = $this->dt_params['paginate'];

        $_POST = $this->input->post(NULL, false);
        
        $a = $this->model_technicians->find_all_active();
        foreach ($a as $key => $value) {
            $as[$value['technicians_id']] = 'NA-'.$value['technicians_id'].'-'.$value['technicians_fullname'];
        }

        $this->_list_data['quotations_feid'] = $as;
   
    }

    public function add($id='', $data=array())
    {
        // debug($id,1 );
        // redirect(g('admin_base_url') . "quotations");
        // parent::add($id, $data=array());
        
        global $config;
		$id = intval($id);
		$this->configure_add_page();
		$class_name = $this->router->class;
		$model_name = 'model_'.$class_name ;
		$model_obj = $this->$model_name ;
		$form_fields = $model_obj->get_fields();
		
		// Prepare models used in this action
		$model_array = array();
		//$model_array = $this->_extra_models_add;
		$model_array[] = $model_name;
		
		$this->_validation_models_add[] = $model_name;
		

		$pk = $model_obj->get_pk() ;

		if($id)
		{

			$params['where'][$pk] = $id;
			$this->form_data[$class_name] = $this->$model_name->find_one($params);
			
			// Load relation fields data
			$this->form_data['relation_data'] = $this->$model_name->get_relation_data($id);

			if(count($this->form_data[$class_name])==0)
			{
				redirect($this->admin_path."?msgtype=error&msg=404+-+Record+not+found.", 'refresh');
				exit();
			}
		}
	
		//$pg_config['order_field'] = $model_obj->get_order_field_name();


		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													$class_name => humanize($class_name),
													$class_name."/add/" => "Add ".humanize($class_name),
												)
											);

		$user_data = $this->input->post(NULL, true);

		$data['form_data'] = (isset($this->form_data))?$this->form_data:array();

		$data['user_input'] = (isset($user_data['login']))?$user_data['login']:array();

		if($_POST)
		{
			//debug($id);exit;
			//debug($_POST,1);
			if($this->bulk_validate($this->_validation_models_add) )
			{

				// Validation Successful
				
				$user_data = $_POST[$class_name]  ;
			
				// Merge FILES field with POST DATA
				if( (isset($user_data)) && (is_array($user_data)) && (isset($_FILES[$class_name]['name'])))
					$user_data = $user_data + $_FILES[$class_name]['name'] ;
				

				$this->$model_name->set_attributes($user_data);
				// debug($user_data,1);

				$insertId = $this->$model_name->save();

				if($insertId)
				{
				    $sendEmail = false;
					$this->$model_name->update_relations($insertId);
					$this->afterSave($insertId , $this->$model_name);
					
					$product_skus = explode(',', $user_data['quotations_product_sku']);
					$product_quantities = explode(',', $user_data['quotations_qty']);
					$product_prices = explode(',', $user_data['quotations_price']);
					
					foreach($product_skus as $key=>$sku):
					    $findParam['where']['product_sku'] = trim($sku);
					    $product = $this->model_product->find_one($findParam);
					    if($product):
    					    $updateParam['quotations_product_partno'] .= $product['product_partno'];
    					    $updateParam['quotations_description'] .= str_replace('|',' ',$product['product_detail']);
    					    $updateParam['quotations_condition'] .= $product['product_condition'];
    					    
    					    if($product_prices[0] != ''):
    					        $updateParam['quotations_product_unit_price'] .= $product_prices[$key];
    					        $updateParam['quotations_subtotal'] .= $product_prices[$key] * $product_quantities[$key];
    					        $updateParam['quotations_total'] += $product_prices[$key] * $product_quantities[$key];
    					    else:

    					        $updateParam['quotations_product_unit_price'] .= $product['product_sale_price'];
        					    $updateParam['quotations_subtotal'] .= $product['product_sale_price'] * $product_quantities[$key];
        					    $updateParam['quotations_total'] += $product['product_sale_price'] * $product_quantities[$key];
        					endif;
    					   // debug($updateParam['quotations_total']);
    					    
    					    if(count($product_skus)-1 > $key):
    					        $updateParam['quotations_description'] .= '||';
    					        $updateParam['quotations_condition'] .= ',';
    					        $updateParam['quotations_product_partno'] .= ',';
    					        $updateParam['quotations_product_unit_price'] .= ',';
    					        $updateParam['quotations_subtotal'] .= ',';
    					    endif;
    				    endif;
					endforeach;
				// 	debug($updateParam);
				// 	debug($product_skus);
				// 	debug($product_quantities,1);
					
				// 	$quotation = $this->model_quotations->find_by_pk($insertId);
					
                    $updateParam['quotations_number'] = "CT-QT-".$insertId;
                    // $updateParam['quotations_status'] = 0;
                    $this->model_quotations->update_by_pk($insertId, $updateParam);
                    
                    $quotationData = $this->model_quotations->find_by_pk($insertId);
                    parent::create_quote_pdf($quotationData);
                //     // debug($quotationData,1);
                    
                //     if($quotationData['quotations_description'] != '' && isset($quotationData['quotations_description'])):
                //         $template = $this->load->view("_layout/email_template/quote_layout", $quotationData, true);
                // 	    $title = "CrispTechllc - Quotation";
                // 	    $response = $this->model_email->quote_email_temp('rydaholic@gmail.com',$template,$title); // For testing
                // 	   // $response = $this->model_email->quote_email_temp($quotationData['quotations_email'],$template,$title); // For live
                // 	else:
                // 	    $response = false;
                //     endif;
                    
            	   
            	   // if($response == true)
            	   // {
            	   //     $param420['txt'] = "Quote sent successfully..";
            	   //     $param420['status'] = 1;
            	   // }
            	   // else{
            	   //     $param420['txt'] = "Quote generation failed. Please contact support..";
            	   //     $param420['status'] = 0;
            	   // }
            	   
            	   // echo json_encode($param);
                    
					// Prevent Return From Parent Add Method(current), 
					// since we need to perform operations in Child Class's Method
					if($this->prevent_return_on_success)
						return $insertId;

					$this->add_redirect_success($insertId);
				}
				else
				{
					redirect($this->admin_path."?msgtype=error&msg=Couldnt Save Data.", 'refresh');
			 		exit();
				}
			}
			else
			{
				$data['error'] = validation_errors();
			}
			
		}
		
		$data['page_title_min'] = "Management";
		$data['page_title'] = $class_name;
		$data['class_name'] = $class_name;
		$data['model_name'] = $model_name;
		$data['model_obj'] = $model_obj;
		$data['form_fields'][$class_name] = $form_fields;
		$data['dt_params'] = $this->dt_params ;
		$data['id'] = $id; 

		$this->before_add_render($data);
		$this->load_view("_form", $data);
    }
    
    public function detail($id='')
    {
        if($id):
            $quotationData = $this->model_quotations->find_by_pk($id);
            $this->load->view("admin/quotation/quotation_layout", $quotationData);
        endif;
    }
    
    public function email_quote()
    {
        $id = $this->input->post('id');
        if($id)
        {
            $quotationData = $this->model_quotations->find_by_pk($id);
            if($quotationData['quotations_description'] != '' && isset($quotationData['quotations_description'])):
                $template = $this->load->view("_layout/email_template/quote_layout", $quotationData, true);
        	    $title = "CrispTechllc - Quotation";
        	   // $response = $this->model_email->quote_email_temp('rydaholic@gmail.com',$template,$title); // For testing
        	    $response = $this->model_email->quote_email_temp($quotationData['quotations_email'],$template,$title); // For live
        	    $rfqUpdateParam['rfq_quotation_status'] = 1;
                $this->model_rfq->update_by_pk($quotationData['quotations_rfq_id'],$rfqUpdateParam);
        	else:
        	    $response = false;
            endif;
            
    	   
    	    if($response == true)
    	    {
    	        $param420['txt'] = "Quotation sent successfully..";
    	        $param420['status'] = 1;
    	    }
    	    else{
    	        $param420['txt'] = "Something went wrong!";
    	        $param420['status'] = 0;
    	    }
            echo json_encode($param420);
        }
        
    }

    public function download_quote()
    {
        $id = $this->input->post('id');
        if($id)
        {
            $quotationData = $this->model_quotations->find_by_pk($id);
            
            if(parent::create_quote_pdf($quotationData))
    	    {
    	        $param420['status'] = 1;
    	    }
    	    else{
    	        $param420['txt'] = "Something went wrong!";
    	        $param420['status'] = 0;
    	    }
            echo json_encode($param420);
        }
    }
    

    public function test_quote_pdf()
    {
        $quotationData = $this->model_quotations->find_by_pk(2);
        require_once(APPPATH."libraries/tcpdf/tcpdf.php");
    	$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    	$pdf->SetCreator(PDF_CREATOR);
    	$pdf->SetAuthor('CrisptechLLC');
    	$pdf->SetTitle('Quotation | '.$quotationData['quotations_number']);
    	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->setPrintHeader(false);
    // 	$pdf->AddPage();
        $pdf->AddPage('L', 'A4');
    	$pdf_template = $this->load->view("_layout/quotation_pdf_template", $quotationData, true);
    	$pdf->writeHTML($pdf_template, true, false, true, false, '');
    	$pdf->Output(FCPATH . 'quotations/'.md5('Quotation-'.$quotationData['quotations_id']).'.pdf', 'I'); //Opens PDF in browser
    // 	$pdf->Output(FCPATH . 'quotations/'.md5('Quotation-'.$quotationData['quotations_id']).'.pdf', 'F'); //Creates PDF
    	return true;
    }
    
    public function ajax_view($id='')
    {
        if($id)
        {
            $this->model_quotations->update_by_pk($id, array("quotations_status" => 0));
        }
        parent::ajax_view($id);
    }
    
    // public function get_product_data($product_sku, )

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
