<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Purchase_order extends MY_Controller {

    /**
     * CSL Achievements page
     *
     * @package     purchase_order
     *
     * @version     1.0 --
     * @since       Version 1.0 2017
     */

    public $_list_data = array();

    public function __construct() {

        global $config;
        
        parent::__construct();
        $this->dt_params['dt_headings'] = "purchase_order_id, purchase_order_number, purchase_order_email,purchase_order_final_total";
       
        $this->dt_params['searchable'] = array("purchase_order_number","purchase_order_status");
        // $this->dt_params['action'] = array(
        //                                 "hide_add_button" => true ,
        //                                 "show_delete" => true ,
        //                                 "hide" => false ,
        //                                 "order_field" => false ,
        //                                 "show_view" => true ,
        //                                 "extra" => array() ,
        //                               );


        $this->dt_params['action'] = array(

                                        "hide_add_button" => false ,

                                        "hide" => false ,
                                        
                                        "hide_upload_button" => true,

                                        "show_delete" => false ,

                                        "show_edit" => true ,

                                        "order_field" => false ,

                                        "show_view" => false ,

                                        "extra" => array(
                                        	'<a title="View" target="_blank" href="'.$config['admin_base_url'].'purchase_order/detail/%d/" class="btn-icon-only btn btn-primary order_details_btn"><i class="btn-icon-only icon-picture"></i></a>',
                                        	
                                		) ,
                                      );
        // Following are common so, defined in MY_Controller_Admin
        // $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
        // $this->dt_params['paginate']['uri'] = "paginate";
        // $this->dt_params['paginate']['update_status_uri'] = "update_status";

        // For use IN JS Files

        $config['js_config']['paginate'] = $this->dt_params['paginate'];

        $_POST = $this->input->post(NULL, false);
        
        $a = $this->model_technicians->find_all_active();
        foreach ($a as $key => $value) {
            $as[$value['technicians_id']] = 'NA-'.$value['technicians_id'].'-'.$value['technicians_fullname'];
        }

        $this->_list_data['purchase_order_feid'] = $as;
   
    }

    public function add($id='', $data=array())
    {
        // debug($id,1 );
        // redirect(g('admin_base_url') . "purchase_order");
        // parent::add($id, $data=array());
        
        global $config;
		$id = intval($id);
		$this->configure_add_page();
		$class_name = $this->router->class;
		$model_name = 'model_'.$class_name ;
		$model_obj = $this->$model_name ;
		$form_fields = $model_obj->get_fields();
		
		// Prepare models used in this action
		$model_array = array();
		//$model_array = $this->_extra_models_add;
		$model_array[] = $model_name;
		
		$this->_validation_models_add[] = $model_name;
		

		$pk = $model_obj->get_pk() ;

		if($id)
		{

			$params['where'][$pk] = $id;
			$this->form_data[$class_name] = $this->$model_name->find_one($params);
			
			// Load relation fields data
			$this->form_data['relation_data'] = $this->$model_name->get_relation_data($id);

			if(count($this->form_data[$class_name])==0)
			{
				redirect($this->admin_path."?msgtype=error&msg=404+-+Record+not+found.", 'refresh');
				exit();
			}
		}
	
		//$pg_config['order_field'] = $model_obj->get_order_field_name();


		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													$class_name => humanize($class_name),
													$class_name."/add/" => "Add ".humanize($class_name),
												)
											);

		$user_data = $this->input->post(NULL, true);

		$data['form_data'] = (isset($this->form_data))?$this->form_data:array();

		$data['user_input'] = (isset($user_data['login']))?$user_data['login']:array();

		if($_POST)
		{
			//debug($id);exit;
			//debug($_POST,1);
			if($this->bulk_validate($this->_validation_models_add) )
			{

				// Validation Successful
				
				$user_data = $_POST[$class_name]  ;
			
				// Merge FILES field with POST DATA
				if( (isset($user_data)) && (is_array($user_data)) && (isset($_FILES[$class_name]['name'])))
					$user_data = $user_data + $_FILES[$class_name]['name'] ;
				

				$this->$model_name->set_attributes($user_data);
				// debug($user_data,1);

				$insertId = $this->$model_name->save();

				if($insertId)
				{
				    $sendEmail = false;
					$this->$model_name->update_relations($insertId);
					$this->afterSave($insertId , $this->$model_name);
					
					$product_skus = explode(',', $user_data['purchase_order_product_sku']);
					$product_quantities = explode(',', $user_data['purchase_order_qty']);
					$product_prices = explode(',', $user_data['purchase_order_price']);
					
					foreach($product_skus as $key=>$sku):
					    $findParam['where']['product_sku'] = trim($sku);
					    $product = $this->model_product->find_one($findParam);
					    if($product):
    					    $updateParam['purchase_order_product_partno'] .= $product['product_partno'];
    					    $updateParam['purchase_order_description'] .= str_replace('|',' ',$product['product_detail']);
    					    $updateParam['purchase_order_condition'] .= $product['product_condition'];
    					    
    					    if($product_prices[0] != ''):
    					        $updateParam['purchase_order_product_unit_price'] .= $product_prices[$key];
    					        $updateParam['purchase_order_subtotal'] .= $product_prices[$key] * $product_quantities[$key];
    					        $updateParam['purchase_order_total'] += $product_prices[$key] * $product_quantities[$key];
    					    else:

    					        $updateParam['purchase_order_product_unit_price'] .= $product['product_sale_price'];
        					    $updateParam['purchase_order_subtotal'] .= $product['product_sale_price'] * $product_quantities[$key];
        					    $updateParam['purchase_order_total'] += $product['product_sale_price'] * $product_quantities[$key];
        					endif;
    					   // debug($updateParam['purchase_order_total']);
    					    
    					    if(count($product_skus)-1 > $key):
    					        $updateParam['purchase_order_description'] .= '||';
    					        $updateParam['purchase_order_condition'] .= ',';
    					        $updateParam['purchase_order_product_partno'] .= ',';
    					        $updateParam['purchase_order_product_unit_price'] .= ',';
    					        $updateParam['purchase_order_subtotal'] .= ',';
    					    endif;
    				    endif;
					endforeach;
				// 	debug($updateParam);
				// 	debug($product_skus);
				// 	debug($product_quantities,1);
					
				// 	$quotation = $this->model_purchase_order->find_by_pk($insertId);
				    $updateParam['purchase_order_tax'] = $user_data['purchase_order_tax'];
				    $updateParam['purchase_order_shipping'] = $user_data['purchase_order_shipping'];
					$updateParam['purchase_order_final_total'] = $updateParam['purchase_order_total'] + $user_data['purchase_order_tax'] + $user_data['purchase_order_shipping'];
                    $updateParam['purchase_order_number'] = "CT-PO-".$insertId;
                    // $updateParam['purchase_order_status'] = 0;
                    $this->model_purchase_order->update_by_pk($insertId, $updateParam);
                    
                    $purchaseOrder = $this->model_purchase_order->find_by_pk($insertId);
                    $this->create_purchase_order_pdf($purchaseOrder);
                //     // debug($quotationData,1);
                    
                //     if($quotationData['purchase_order_description'] != '' && isset($quotationData['purchase_order_description'])):
                //         $template = $this->load->view("_layout/email_template/quote_layout", $quotationData, true);
                // 	    $title = "CrispTechllc - Quotation";
                // 	    $response = $this->model_email->quote_email_temp('rydaholic@gmail.com',$template,$title); // For testing
                // 	   // $response = $this->model_email->quote_email_temp($quotationData['purchase_order_email'],$template,$title); // For live
                // 	else:
                // 	    $response = false;
                //     endif;
                    
            	   
            	   // if($response == true)
            	   // {
            	   //     $param420['txt'] = "Quote sent successfully..";
            	   //     $param420['status'] = 1;
            	   // }
            	   // else{
            	   //     $param420['txt'] = "Quote generation failed. Please contact support..";
            	   //     $param420['status'] = 0;
            	   // }
            	   
            	   // echo json_encode($param);
                    
					// Prevent Return From Parent Add Method(current), 
					// since we need to perform operations in Child Class's Method
					if($this->prevent_return_on_success)
					    return $insertId;


					$this->add_redirect_success($insertId);
				}
				else
				{
					redirect($this->admin_path."?msgtype=error&msg=Couldnt Save Data.", 'refresh');
			 		exit();
				}
			}
			else
			{
				$data['error'] = validation_errors();
			}
			
		}
		
		$data['page_title_min'] = "Management";
		$data['page_title'] = $class_name;
		$data['class_name'] = $class_name;
		$data['model_name'] = $model_name;
		$data['model_obj'] = $model_obj;
		$data['form_fields'][$class_name] = $form_fields;
		$data['dt_params'] = $this->dt_params ;
		$data['id'] = $id; 

		$this->before_add_render($data);
		$this->load_view("_form", $data);
    }
    
    public function detail($id='')
    {
        if($id):
            $purchaseOrder = $this->model_purchase_order->find_by_pk($id);
            $this->load->view("admin/purchase_order/detail", $purchaseOrder);
        endif;
    }
    
    public function email_purchase_order()
    {
        $id = $this->input->post('id');
        if($id)
        {
            $purchaseOrder = $this->model_purchase_order->find_by_pk($id);
            if($purchaseOrder['purchase_order_description'] != '' && isset($purchaseOrder['purchase_order_description'])):
                $template = $this->load->view("_layout/email_template/purchase_order_layout", $purchaseOrder, true);
        	    $title = "CrispTechllc - Purchase Order";
        	   // $response = $this->model_email->quote_email_temp('rydaholic@gmail.com',$template,$title); // For testing
        	    $response = $this->model_email->quote_email_temp($purchaseOrder['purchase_order_email'],$template,$title); // For live
        	else:
        	    $response = false;
            endif;
            
    	   
    	    if($response == true)
    	    {
    	        $param420['txt'] = "Purchase Order sent successfully..";
    	        $param420['status'] = 1;
    	        $updateParam['purchase_order_status'] = 0;
    	        $this->model_purchase_order->update_by_pk($id, $updateParam);
    	    }
    	    else{
    	        $param420['txt'] = "Something went wrong!";
    	        $param420['status'] = 0;
    	    }
            echo json_encode($param420);
        }
        
    }

    public function download_purchase_order()
    {
        $id = $this->input->post('id');
        if($id)
        {
            $purchaseOrder = $this->model_purchase_order->find_by_pk($id);
            
            if($this->create_purchase_order_pdf($purchaseOrder))
    	    {
    	        $param420['status'] = 1;
    	    }
    	    else{
    	        $param420['txt'] = "Something went wrong!";
    	        $param420['status'] = 0;
    	    }
            echo json_encode($param420);
        }
    }
    
        public function create_purchase_order_pdf($purchaseOrder)
    {
        require_once(APPPATH."libraries/tcpdf/tcpdf.php");
    	$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    	$pdf->SetCreator(PDF_CREATOR);
    	$pdf->SetAuthor('CrisptechLLC');
    	$pdf->SetTitle('Purchase Order | '.$purchaseOrder['purchase_order_number']);
    	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->setPrintHeader(false);
    // 	$pdf->AddPage();
        $pdf->AddPage('L', 'A4');
    	$pdf_template = $this->load->view("_layout/purchase_order_pdf_template", $purchaseOrder, true);
    	$pdf->writeHTML($pdf_template, true, false, true, false, '');
    // 	$pdf->Output(FCPATH . 'purchase_orders/'.md5('Quotation-'.$quotationData['purchase_order_id']).'.pdf', 'I'); //Opens PDF in browser
    	$pdf->Output(FCPATH . 'purchase_orders/'.md5('Purchase Order-'.$purchaseOrder['purchase_order_id']).'.pdf', 'F'); //Creates PDF
    	return true;
    }
    

        public function test_purchase_order_pdf()
    {
        $purchaseOrder = $this->model_purchase_order->find_by_pk(100300030);
        require_once(APPPATH."libraries/tcpdf/tcpdf.php");
    	$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    	$pdf->SetCreator(PDF_CREATOR);
    	$pdf->SetAuthor('CrisptechLLC');
    	$pdf->SetTitle('Purchase Order | '.$purchaseOrder['purchase_order_number']);
    	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->setPrintHeader(false);
    // 	$pdf->AddPage();
        $pdf->AddPage('L', 'A4');
    	$pdf_template = $this->load->view("_layout/purchase_order_pdf_template", $purchaseOrder, true);
    	$pdf->writeHTML($pdf_template, true, false, true, false, '');
    	$pdf->Output(FCPATH . 'purchase_order/'.md5('Quotation-'.$quotationData['purchase_order_id']).'.pdf', 'I'); //Opens PDF in browser
    // 	$pdf->Output(FCPATH . 'purchase_order/'.md5('Quotation-'.$quotationData['purchase_order_id']).'.pdf', 'F'); //Creates PDF
    	return true;
    }
    
    public function ajax_view($id='')
    {
        if($id)
        {
            $this->model_purchase_order->update_by_pk($id, array("purchase_order_status" => 0));
        }
        parent::ajax_view($id);
    }
    
    // public function get_product_data($product_sku, )

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
