<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

// require APPPATH.'libraries/firebase/vendor/autoload.php';
// use Kreait\Firebase\Factory;
// use Kreait\Firebase\ServiceAccount;


class Csv extends MY_Controller {

    /**
     * product page
     *
     *
     * @version     1.0
     * @since       2017
     */

    public $_list_data = array();

    public function __construct() {

        global $config;

        parent::__construct();
        //$this->dt_params['dt_headings'] = "product_id,product_category_id,product_name,product_price,product_is_promotion,product_status";
        $this->dt_params['dt_headings'] = "product_id,product_name,product_barcode,product_status";
        $this->dt_params['searchable'] = array("product_id","product_category_id","product_name","product_status");
        $this->dt_params['action'] = array(
            "hide_add_button" => false ,
            "hide" => false ,
            "show_delete" => true ,
            "show_edit" => true ,
            "order_field" => false ,
            "show_view" => false ,
            "extra" => array() ,
        );

        /*$this->_list_data['product_status'] = array(
            STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
            STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
        );*/

        // For use IN JS Files
        $config['js_config']['paginate'] = $this->dt_params['paginate'];

        //$para['where']['category_id > '] = 2;
        $this->_list_data['product_category_id'] = $this->model_category->find_all_list_active(array(),"category_name");
        $_POST = $this->input->post(NULL, false);
    }

    public function index()
    {
        global $config;
		
		$class_name = $this->router->class;
		$model_name = "model_".$class_name;

		$model_obj = $this->$model_name ;
		//$pg_config['order_field'] = $model_obj->get_order_field_name();

		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													$class_name => humanize($class_name)
												)
											);

		$this->register_plugins( array(						
										"jquery-ui",
										"bootstrap",
										"bootstrap-hover-dropdown",
										"jquery-slimscroll",
										"uniform",
										"bootstrap-switch",
										"bootstrap-datepicker",
										"boots",
										"font-awesome",
										"simple-line-icons" ,
										"select2",
										"datatables",
										"bootbox",
										"bootstrap-toastr",

								));

		$this->add_script("pages/tasks.css");
		$this->add_script(array("table-ajax.js" , "datatable.js") , "js");

		$data['page_title_min'] = "Management";
		$data['page_title'] = $class_name;
		$data['class_name'] = $class_name;
		$data['model_name'] = $model_name;
		$data['model_obj'] = $model_obj;
		$data['model_fields'] = $model_obj->get_fields();
		$data['dt_params'] = $this->dt_params ;

		$data['model'] = "$model_name";
		$this->before_index_render($data);
// 		$this->load_view("datatable" , $data );
        $this->load_view('upload_excel');
        // parent::index();
    }

    public function add($id='' , $data = array()) {
        // debug($id,1);
      	global $config;
		$id = intval($id);
		$this->configure_add_page();
		$class_name = $this->router->class;
		$model_name = 'model_'.$class_name ;
		$model_obj = $this->$model_name ;
		$form_fields = $model_obj->get_fields();
		
		// Prepare models used in this action
		$model_array = array();
		//$model_array = $this->_extra_models_add;
		$model_array[] = $model_name;
		
		$this->_validation_models_add[] = $model_name;
		

		$pk = $model_obj->get_pk() ;

		if($id)
		{

			$params['where'][$pk] = $id;
			$this->form_data[$class_name] = $this->$model_name->find_one($params);
			
			// Load relation fields data
			$this->form_data['relation_data'] = $this->$model_name->get_relation_data($id);

			if(count($this->form_data[$class_name])==0)
			{
				redirect($this->admin_path."?msgtype=error&msg=404+-+Record+not+found.", 'refresh');
				exit();
			}
		}
	
		//$pg_config['order_field'] = $model_obj->get_order_field_name();


		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													$class_name => humanize($class_name),
													$class_name."/add/" => "Add ".humanize($class_name),
												)
											);

		$user_data = $this->input->post(NULL, true);

		$data['form_data'] = (isset($this->form_data))?$this->form_data:array();

		$data['user_input'] = (isset($user_data['login']))?$user_data['login']:array();

		if($_POST)
		{
			//debug($id);exit;
			//debug($_POST,1);
			if($this->bulk_validate($this->_validation_models_add) )
			{

				// Validation Successful
				
				$user_data = $_POST[$class_name]  ;
			
				// Merge FILES field with POST DATA
				if( (isset($user_data)) && (is_array($user_data)) && (isset($_FILES[$class_name]['name'])))
					$user_data = $user_data + $_FILES[$class_name]['name'] ;
				

				$this->$model_name->set_attributes($user_data);

				$insertId = $this->$model_name->save();

				if($insertId)
				{
					$this->$model_name->update_relations($insertId);
					$this->afterSave($insertId , $this->$model_name);

					// Prevent Return From Parent Add Method(current), 
					// since we need to perform operations in Child Class's Method
					if($this->prevent_return_on_success)
						return $insertId;

					$this->add_redirect_success($insertId);
				}
				else
				{
					redirect($this->admin_path."?msgtype=error&msg=Couldnt Save Data.", 'refresh');
			 		exit();
				}
			}
			else
			{
				$data['error'] = validation_errors();
			}
			
		}
		
		$data['page_title_min'] = "Management";
		$data['page_title'] = $class_name;
		$data['class_name'] = $class_name;
		$data['model_name'] = $model_name;
		$data['model_obj'] = $model_obj;
		$data['form_fields'][$class_name] = $form_fields;
		$data['dt_params'] = $this->dt_params ;
		$data['id'] = $id; 

		$this->before_add_render($data);
		$this->load_view("_form", $data);


    }



    
    
    

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */