<?php
if ( !defined( 'BASEPATH' ) )
exit( 'No direct script access allowed' );

class Course extends MY_Controller {

    /**
    * course page
    *
    * @package
    *
    * @version		1.0 --
    * @since		Version 1.0 2017
    */

    public $_list_data = array();

    public function __construct() {

        global $config;

        parent::__construct();
        $this->dt_params[ 'dt_headings' ] = 'course_id,course_name,course_status';
        $this->dt_params[ 'searchable' ] = array( 'course_id', 'course_name', 'course_status' );
        $this->dt_params[ 'action' ] = array(
            'hide_add_button' => false,
            'hide' => false,
            'show_delete' => true,
            'show_edit' => true,
            'order_field' => false,
            'show_view' => false,
            'extra' => array(),
        );

        // $this->_list_data[ 'course_category_id' ] = $this->model_category->find_all_list_active( array(), 'category_name' );

        $this->_list_data[ 'course_status' ] = array(
            STATUS_INACTIVE => '<span class=\'label label-default\'>Inactive</span>',
            STATUS_ACTIVE =>  '<span class=\'label label-primary\'>Active</span>'
        );
        // Following are common so, defined in MY_Controller_Admin
        // $this->dt_params[ 'paginate' ][ 'class' ] = $config[ 'js_config' ][ 'ci_class' ];
        // $this->dt_params[ 'paginate' ][ 'uri' ] = 'paginate';
        // $this->dt_params[ 'paginate' ][ 'update_status_uri' ] = 'update_status';

        // For use IN JS Files
        $config[ 'js_config' ][ 'paginate' ] = $this->dt_params[ 'paginate' ];

        // Populating LISTDATA

        $_POST = $this->input->post( NULL, false );
    }

    public function add( $id = '', $data = array() )
 {
        // debug( $_FILES, 1 );
        // Popluated LISTDATA in constructor
        $this->add_script( array( 'jquery.validate.js', 'form-validation-script.js' ), 'js' );
        $this->register_plugins( 'jquery-file-upload' );

        $this->register_plugins( array(
            'jquery-ui',
            'bootstrap',
            'bootstrap-hover-dropdown',
            'jquery-slimscroll',
            'uniform',
            'bootstrap-switch',
            'bootstrap-datepicker',
            'boots',
            'font-awesome',
            'simple-line-icons',
            'select2',
            'datatables',
            'bootbox',
            'bootstrap-toastr',
            'ckeditor',

        ) );

        if((isset($_POST)) && (count($_POST)>0))
	    {
            // $this->update_tax_exempted_states($id, $_POST['signup']['signup_tax_states']);
            $_POST['course']['course_slots'] = serialize($_POST['course']['course_slots']);
	    
        }
        /*
        if ( !$id )
 {
            $this->form_params = array(
                'action' => array(
                    'save_edit_attr' => '#tab_1',
                    'hide_save' => false,
                    'hide_save_new' => false,
                    'hide_cancel' => false,
                ),
            );
        }
        */

        parent::add( $id, $data );
    }

    function course_detail_submit() {

        // debug( $_FILES );

        $course = $this->input->post( 'course' );

        // Success
        if ( ( count( $_POST ) > 0 ) && ( array_filled( $course ) ) ) {
            if ( $this->validate( 'model_course' ) )
 {
                $tmp = $_FILES[ 'course' ][ 'tmp_name' ][ 'course_image' ];
                // Generate file name
                $tmp1 = $_FILES[ 'course' ][ 'tmp_name' ][ 'course_logo' ];

                $name = mt_rand() . $_FILES[ 'course' ][ 'name' ][ 'course_image' ];

                $name1 = mt_rand() . $_FILES[ 'course' ][ 'name' ][ 'course_logo' ];
                // Get upload path
                $upload_path = $this->config->item( 'site_upload_course' );
                $targetFile = $upload_path . basename( $name );
                $targetFile1 = $upload_path . basename( $name1 );

                move_uploaded_file( $tmp, $targetFile );
                move_uploaded_file( $tmp1, $targetFile1 );

                // Set data
                $course[ 'course_image' ] = $name;
                $course[ 'course_logo' ] = $name1;

                $course[ 'course_image_path' ] = $upload_path;
                $course[ 'course_status' ] = '1';

                // Upload new file

                $inserted_id = $this->model_course->insert_record( $course );
                //  debug( $inserted_id, 1 );

                if ( $inserted_id > 0 ) {
                    for ( $i = 0; $i < count( $_POST[ 'time_slots_type' ] );
                    $i++ )
                    {
                        $data = array(
                            'time_slots_course_id'=>$inserted_id,
                            'time_slots_type'=>$_POST[ 'time_slots_type' ][ $i ],
                            'time_slots_start_date' => $_POST[ 'time_slots_start_date' ][ $i ],
                            'time_slots_end_date' => $_POST[ 'time_slots_end_date' ][ $i ],
                            'time_slots_start_time' => $_POST[ 'time_slots_start_time' ][ $i ],
                            'time_slots_end_time' => $_POST[ 'time_slots_end_time' ][ $i ],
                            'time_slots_status' =>1,
                        );
                        $this->db->insert( 'fb_time_slots', $data );
                    }
                    $this->json_param[ 'status' ] = true;
                    $this->json_param[ 'txt' ] = 'Record Saved successfully.';
                } else {
                    $this->json_param[ 'status' ] = false;
                    $this->json_param[ 'txt' ] = 'Something went wrong.Please try later.';
                }
            } else {
                $this->json_param[ 'status' ] = false;
                $this->json_param[ 'txt' ] = validation_errors();
            }

        }
        // Error
        else {
            $this->json_param[ 'status' ] = false;
            $this->json_param[ 'txt' ] = lang( 'something_wrong' );
        }

        echo json_encode( $this->json_param );
    }

    function course_time_slots_submit() {
        // debug( $_POST, 1 );

        if ( $_POST[ 'flexRadioDefault' ] == '1' ) {
            $this->form_validation->set_rules( 'time_slots_start_date', 'Start Date', 'required' );
            $this->form_validation->set_rules( 'time_slots_end_date', 'End Date', 'required' );
        }
        if ( $_POST[ 'flexRadioDefault' ] == '2' ) {

            $this->form_validation->set_rules( 'days', 'Day', 'required' );
        }

        if ( $_POST[ 'time_slots_type' ] == '2' ) {
            $this->form_validation->set_rules( 'time_slots_start_time', 'Start Time', 'required' );
            $this->form_validation->set_rules( 'time_slots_end_time', 'End Time', 'required' );
        }
        if ( $_POST[ 'time_slots_type' ] == '1' ) {
            $this->form_validation->set_rules( 'time_slots_start_time', 'Morning/Evening Start Time', 'required' );
            $this->form_validation->set_rules( 'time_slots_end_time', 'Morning/Evening End Time', 'required' );
        }

        if ( $this->form_validation->run() == TRUE )
        {
            if(!empty($_POST['time_slots_seats'])){
                $seats=$_POST['time_slots_seats'];
            }
            else {
                $seats = NULL;
            }
            $data = array(
                'time_slots_course_id'=>$_POST[ 'time_slots_course_id' ],
                'time_slots_type'=>$_POST[ 'time_slots_type' ],
                'time_slots_seats'=>$seats,
                'time_slots_start_date' => $_POST[ 'time_slots_start_date' ],
                'time_slots_end_date' => $_POST[ 'time_slots_end_date' ],
                'time_slots_start_time' => $_POST[ 'time_slots_start_time' ],
                'time_slots_end_time' => $_POST[ 'time_slots_end_time' ],
                'time_slots_status' =>1,
                'time_slots_day'=>$_POST[ 'days' ],
                'time_slots_day_or_date'=>$_POST[ 'flexRadioDefault' ],
            );
            if ( !empty( $_POST[ 'time_slots_evening_start_time' ] ) ) {
                $data[ 'time_slots_evening_start_time' ] = $_POST[ 'time_slots_evening_start_time' ];
            }
            if ( !empty( $_POST[ 'time_slots_evening_end_time' ] ) ) {
                $data[ 'time_slots_evening_end_time' ] = $_POST[ 'time_slots_evening_end_time' ];
            }
            $this->db->insert( 'fb_time_slots', $data );

            $this->json_param[ 'status' ] = true;
            $this->json_param[ 'txt' ] = 'Record Saved successfully.';
        } else {
            $this->json_param[ 'status' ] = false;
            $this->json_param[ 'txt' ] = validation_errors();
        }
        echo json_encode( $this->json_param );

    }

    function get_course()
 {
        $data[ 'course' ] = $this->model_time_slots->find_by_pk( $_POST[ 'id' ] );
        $bs[ 'content' ] = $this->load->view( 'admin/course/edit_course', $data, true );
        echo json_encode( $bs );

    }

    function course_detail_edit( $id ) 
 {
        if ( $_POST )
 {
                $time_slots = $_POST['time_slots'];
                if(!empty($_POST['time_slots']['time_slots_seats'])){
                    $time_slots['time_slots_seats']=$_POST['time_slots']['time_slots_seats'];
                }
                else {
                    $time_slots['time_slots_seats']=NULL;
                }
                if(!empty($_POST['time_slots']['time_slots_start_date'])){
                    $time_slots['time_slots_start_date']=$_POST['time_slots']['time_slots_start_date'];
                }
                else {
                    $time_slots['time_slots_start_date']=NULL;
                }
                
                if(!empty($_POST['time_slots']['time_slots_end_date'])){
                    $time_slots['time_slots_end_date']=$_POST['time_slots']['time_slots_end_date'];
                }
                else {
                    $time_slots['time_slots_end_date']=NULL;
                }
            // debug($time_slots, 1);
                // $this->model_time_slots->update_by_pk( $id, $time_slots );
                // echo $this->db->last_query();
                if ( $this->model_time_slots->update_by_pk($id, $time_slots) ) {
                    $this->json_param[ 'status' ] = true;
                    $this->json_param[ 'txt' ] = 'Record Saved successfully.';
                } else {
                    $this->json_param[ 'status' ] = false;
                    $this->json_param[ 'txt' ] = 'Something went wrong.Please try later.';
                }
        }
        echo json_encode( $this->json_param );

    }

    public function course_detail_delete()
 {
        if ( $_POST ) {
            $id = $this->input->post( 'id' );
            $para[ 'time_slots_status' ] = '2';
            $this->model_time_slots->update_by_pk( $id, $para );
            $response[ 'status' ] = true;
            $response[ 'txt' ] = 'Item deleted successfully';
            echo json_encode( $response );
        } else {

            $response[ 'status' ] = false;
            $response[ 'txt' ] = 'Something went wrong.Please try later.';
            echo json_encode( $response );
        }
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */