<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Blog extends MY_Controller {

	/**
	 * CSL Achievements page
	 *
	 * @package		blog
	 *
     * @version		1.0 --
     * @since		Version 1.0 2017
	 */

    public $_list_data = array();

	public function __construct() {

		global $config;
		
		parent::__construct();
        $this->dt_params['dt_headings'] = "blog_id,blog_title,blog_category,blog_status";
        $this->dt_params['searchable'] = array("blog_id","blog_title","blog_category","blog_status");
        
        $this->dt_params['action'] = array(
                                    "hide_add_button" => false ,
                                    "hide" => false ,
                                    "show_delete" => true ,
                                    "show_edit" => true ,
                                    "order_field" => false ,
                                    "show_view" => false ,
                                    "extra" => array() ,
                                    );
        $this->_list_data['blog_status'] = array( 
                                        STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
                                    );
        // $this->_list_data['blog_latest_featured'] = array( 
        //                                 STATUS_INACTIVE => "<span class=\"label label-default\">No</span>" ,  
        //                                 STATUS_ACTIVE =>  "<span class=\"label label-primary\">Yes</span>"  
        //                             );
        // Following are common so, defined in MY_Controller_Admin
		// $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
		// $this->dt_params['paginate']['uri'] = "paginate";
		// $this->dt_params['paginate']['update_status_uri'] = "update_status";

		// For use IN JS Files

		$config['js_config']['paginate'] = $this->dt_params['paginate'];


        /*$this->_list_data['blog_page'] = array(
            'home'=>'Home',
            'wireless'=>'Wireless',
            'accessories'=>'Accessories',
            'about_us'=>'About Us',
            'blog_info'=>'blog & Info',
            'contact_us'=>'Contact Us',
        );*/
        $this->_list_data['blog_category'] = $this->model_blog_category->find_all_list_active(array(),"blog_category_name");


		//$this->_list_data['blog_category_id'] = $this->model_category->find_all_list_active(array(),"category_name");
		//$this->_list_data['blog_product_id'] = $this->model_product->find_all_list_active(array(),"product_name");

		$_POST = $this->input->post(NULL, false);
	}

	public function add($id='', $data=array())
	{
        $this->add_script(array( "jquery.validate.min.js") , "js" );
		$this->register_plugins(array(						
									"jquery-ui",
									"bootstrap",
									"bootstrap-hover-dropdown",
									"jquery-slimscroll",
									"uniform",
									"boots",
									"font-awesome",
									"simple-line-icons" ,
									"select2",
									"bootbox",
									"bootstrap-toastr",									
								));

		parent::add($id, $data);
	}

    function blog_detail_submit(){
       
        $blog_detial=$this->input->post('blog_detial');

         // Success
         if ((count($_POST) > 0) && (array_filled($blog_detial))) {
            if($this->validate("model_blog_detial"))
            {
             $tmp = $_FILES['blog_detial']['tmp_name']['blog_detial_image'];
             // Generate file name
             $name = mt_rand() . $_FILES['blog_detial']['name']['blog_detial_image'];
 
             // Get upload path
             $upload_path = $this->config->item('site_upload_blog');
             $targetFile = $upload_path . basename($name );
             // Set data
             $blog_detial['blog_detial_image']= $name;

             $blog_detial['blog_detial_image_path'] = $upload_path;
            

             // Upload new file
             move_uploaded_file($tmp, $targetFile);
 
             $inserted_id = $this->model_blog_detial->insert_record($blog_detial);
 
             if ($inserted_id > 0) { 
                 $this->json_param['status'] = true;
                 $this->json_param['txt'] = 'Record Saved successfully.';
             } else {
                 $this->json_param['status'] = false;
                 $this->json_param['txt'] = 'Something went wrong.Please try later.';
             }
            }
                else
            {
                $this->json_param['status'] = false;
                $this->json_param['txt'] = validation_errors();
            }
            
         }
         // Error
         else {
             $this->json_param['status'] = false;
             $this->json_param['txt'] = lang('something_wrong');
         }
 
         echo json_encode($this->json_param);
    }


    public function get_blog_detail()
    {

       $data=$this->model_blog_detial->find_by_pk($_POST['id']);
        echo json_encode($data);
    }
    public function blog_detail_edit()
    {
        if($_POST)
        {

           if($this->validate("model_blog_detial"))
            { 
                $blog_detial = $_POST['blog_detial']  ;
            
                // Merge FILES field with POST DATA
                if(!empty($_FILES['blog_detial']['name']['blog_detial_image'])){
                     $tmp = $_FILES['blog_detial']['tmp_name']['blog_detial_image'];                     // Generate file name
                     $name = mt_rand() . $_FILES['blog_detial']['name']['blog_detial_image'];        
                     // Get upload path
                     $upload_path = $this->config->item('site_upload_blog');
                     $targetFile = $upload_path . basename($name );
                     // Set data
                     $blog_detial['blog_detial_image']= $name;

                     $blog_detial['blog_detial_image_path'] = $upload_path;
                      if(move_uploaded_file($tmp, $targetFile)){
                        $filenamess = $upload_path.$_POST['old_image_name'];
                        unlink($filenamess);
                      }                    

                }
                else {
                    $blog_detial['blog_detial_image']=$_POST['old_image_name'];
                }
                if($this->model_blog_detial->update_by_pk($_POST['id'],$blog_detial)){;
                 $this->json_param['status'] = true;
                 $this->json_param['txt'] = 'Record Saved successfully.';
             }
             else {
                $this->json_param['status'] = false;
                 $this->json_param['txt'] = 'Something went wrong.Please try later.';
             }
            
            }
            else {
                 $this->json_param['status'] = false;
                $this->json_param['txt'] = validation_errors();
            }
        }
         echo json_encode($this->json_param);
    }

    public function blog_detail_delete()
    {
        if($_POST){
           $id = $this->input->post('id');
           $para['blog_detial_status']='2';
           $this->model_blog_detial->update_by_pk($id,$para);
        $response['status'] = true;
        $response['txt'] = 'Item deleted successfully';
        echo json_encode($response);
      }
      else {

       $response['status'] = false;
        $response['txt'] = 'Something went wrong.Please try later.';
        echo json_encode($response);
      }
    }

}

/* End of file welcome.php */
/* blog: ./application/controllers/welcome.php */