<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Admin_order extends MY_Controller {

	/**
	 * user admin
	 *
	 * @package		User
	 *
     * @version		1.0 --
     * @since		Version 1.0 2017
	 */
	private $fed_auth;
    public $_list_data = array();

	public function __construct() {

		global $config;
		parent::__construct();
		$this->fed_auth = g('db.admin.fedex_auth_url');
        $this->dt_params['dt_headings'] = "admin_order_id,admin_order_billing_name,admin_order_billing_email,admin_order_amount,admin_order_link,admin_order_status,admin_order_createdon";
        $this->dt_params['searchable'] = array("admin_order_id","admin_order_email","admin_order_payment_status");
        $this->dt_params['action'] = array(
                                    "hide_upload_button" => true,
        								"hide_add_button" => true ,
                                        "hide" => false ,
                                        "show_delete" => false ,
                                        "show_edit" => true ,
                                        "admin_order_field" => false ,
                                        "show_view" => false ,
                                        "extra" => array(
                                        	'<a title="View" href="'.$config['admin_base_url'].'admin_order/detail/%d/" class="btn-xs btn btn-primary admin_order_details_btn"><i class="icon-picture"></i></a>',
                                        	
                                		) ,
                                      );
        
        $this->_list_data['user_status'] = array( 
                                        STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,  
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"  
                                    );
         $this->_list_data['admin_order_dispatch_status'] = array(
            STATUS_INACTIVE => "<span class=\"label label-default\">No</span>" ,
            STATUS_ACTIVE =>  "<span class=\"label label-primary\">Yes</span>"
        );

		// For use IN JS Files
		$config['js_config']['paginate'] = $this->dt_params['paginate'];
		
		$_POST = $this->input->post(NULL, false);
		
	}

	public function add($id='', $data=array())
	{
		$this->layout_data['bread_crumbs'] = array(
			array(
				"home/"=>"Home" , 
				$class_name => 'Edit Order',
				// $class_name => humanize($class_name),
				// $class_name."/add/" => "Add ".humanize($class_name),
			)
		);

		$curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => $this->fed_auth,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id=l728624bdf25334bcfb40207c484e412b3&client_secret=06c02c9a26d1486b9c7a2de9c385cf16',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $data['fedtoken'] = json_decode($response,true)['access_token'];
		$data['states'] = $this->model_state->find_all();

		$params['where']['admin_order_id'] = $id;
		$data['admin_order'] = $this->model_admin_order->find_one($params);

		$params001['where']['admin_order_item_order_id'] = $data['admin_order']['admin_order_id'];
		$admin_order_items = $this->model_admin_order_item->find_all($params001);
		$data['admin_order_items'] = $admin_order_items;

		$data['country'] = $this->model_country->get_country_list();
		// Popluated LISTDATA in constructor
		$this->add_script(array( "jquery.validate.js" , "form-validation-script.js") , "js" );
// 		debug($data['country'] ,1);
		parent::add($id, $data);
// 		redirect(g('admin_base_url') . "order");
	}
	
	public function search(){
	    debug($_POST,1);
	}

	public function add_new()
	{
		$curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => $this->fed_auth,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id=l728624bdf25334bcfb40207c484e412b3&client_secret=06c02c9a26d1486b9c7a2de9c385cf16',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $data['fedtoken'] = json_decode($response,true)['access_token'];
		$data['states'] = $this->model_state->find_all();

		$params['where']['admin_order_id'] = $id;
		$data['admin_order'] = $this->model_admin_order->find_one($params);

		$params001['where']['admin_order_item_order_id'] = $data['admin_order']['admin_order_id'];
		$admin_order_items = $this->model_admin_order_item->find_all($params001);
		$data['admin_order_items'] = $admin_order_items;
		$data['users'] = $this->model_signup->find_all_active();

		global $config;
		$id = intval($id);
		$this->configure_add_page();
		$class_name = $this->router->class;
		$model_name = 'model_'.$class_name ;
		$model_obj = $this->$model_name ;
		$form_fields = $model_obj->get_fields();
		
		// Prepare models used in this action
		$model_array = array();
		//$model_array = $this->_extra_models_add;
		$model_array[] = $model_name;
		
		$this->_validation_models_add[] = $model_name;
		

		$pk = $model_obj->get_pk() ;

		if($id)
		{

			$params['where'][$pk] = $id;
			$this->form_data[$class_name] = $this->$model_name->find_one($params);
			
			// Load relation fields data
			$this->form_data['relation_data'] = $this->$model_name->get_relation_data($id);

			if(count($this->form_data[$class_name])==0)
			{
				redirect($this->admin_path."?msgtype=error&msg=404+-+Record+not+found.", 'refresh');
				exit();
			}
		}
	
		//$pg_config['order_field'] = $model_obj->get_order_field_name();


		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													$class_name => 'Add Order',
													// $class_name => humanize($class_name),
													// $class_name."/add/" => "Add ".humanize($class_name),
												)
											);

		$user_data = $this->input->post(NULL, true);

		$data['form_data'] = (isset($this->form_data))?$this->form_data:array();

		$data['user_input'] = (isset($user_data['login']))?$user_data['login']:array();

		if($_POST)
		{
			//debug($id);exit;
			//debug($_POST,1);
			if($this->bulk_validate($this->_validation_models_add) )
			{

				// Validation Successful
				
				$user_data = $_POST[$class_name]  ;
			
				// Merge FILES field with POST DATA
				if( (isset($user_data)) && (is_array($user_data)) && (isset($_FILES[$class_name]['name'])))
					$user_data = $user_data + $_FILES[$class_name]['name'] ;
				

				$this->$model_name->set_attributes($user_data);

				$insertId = $this->$model_name->save();

				if($insertId)
				{
					$this->$model_name->update_relations($insertId);
					$this->afterSave($insertId , $this->$model_name);

					// Prevent Return From Parent Add Method(current), 
					// since we need to perform operations in Child Class's Method
					if($this->prevent_return_on_success)
						return $insertId;

					$this->add_redirect_success($insertId);
				}
				else
				{
					redirect($this->admin_path."?msgtype=error&msg=Couldnt Save Data.", 'refresh');
			 		exit();
				}
			}
			else
			{
				$data['error'] = validation_errors();
			}
			
		}
		
		$data['page_title_min'] = "Management";
		$data['page_title'] = $class_name;
		$data['class_name'] = $class_name;
		$data['model_name'] = $model_name;
		$data['model_obj'] = $model_obj;
		$data['form_fields'][$class_name] = $form_fields;
		$data['dt_params'] = $this->dt_params ;
		$data['id'] = $id; 
		$data['country'] = $this->model_country->get_country_list();
// 		debug($data,1);
		$this->before_add_render($data);
		
		$this->load_view('add_form',$data);
	}
	
	public function bypass_checkout(){
	   // debug($_POST,1);
	   // die;
	    $oid = $_POST['admin_order']['admin_order_id'];
        $param003['where']['admin_order_id'] = $oid;
        $data = $this->model_admin_order->find_one($param003);
        // debug($data,1);
        unset($data['admin_order_id']);	 
        unset($data['admin_order_token']);	    
        unset($data['admin_order_link']);	    
        
	    foreach($data as $key => $val){
	        $updated_key = str_replace('admin_','',$key);
	        $updated_data[$updated_key] = $val;
	    }
	    $updated_data['order_payment_status'] = 3;
	    $updated_data['order_merchant'] = 'Custom / Wire Transfer';
	    $updated_data['order_payment_comments'] = "Checkout procedure bypassed by admin..";
	   // debug($updated_data,1);
	    $in_id = $this->model_order->insert_record($updated_data);
	    if($in_id > 0){
	        $param002['order_number'] = 'CT-'.$in_id;
	        $this->model_order->update_by_pk($in_id,$param002);
	        $param001['admin_order_status'] = 0;
	        $update_checkout = $this->model_admin_order->update_by_pk($_POST['admin_order']['admin_order_id'],$param001);
	        
	        $param004['where']['admin_order_item_order_id'] = $_POST['admin_order']['admin_order_id'];
            $data004 = $this->model_admin_order_item->find_all($param004);
            foreach($data004 as $key => $val){
                unset($val['admin_order_item_id']);
                foreach($val as $key2 => $val2):
                    $updated_key2 = str_replace('admin_','',$key2);
                    $data005[$key][$updated_key2] = $val2;
                    $data005[$key]['order_item_order_id'] = $in_id;
                endforeach;
            }
            // debug($data005);
            $in_item = $this->model_order_item->insert_batch_record($data005);
            // debug($in_item);
            $order = $this->model_order->find_by_pk($in_id);
// 			$this->invoice_email($order);
	        $json_param['txt'] = 'Order saved successfully. Please check front orders for further procedure..';
	        $json_param['status'] = 1;
	    }
	    else{
	        $json_param['txt'] = 'Failed to save order. Please try again or contact technical support if the problem persists..';
	        $json_param['status'] = 0;
	    }
	    echo json_encode($json_param);
	}

	public function get_customer_detail()
	{
		$id = $this->input->post('customer_id');
		$param['where']['signup_id'] = $id;
		$customer = $this->model_signup->find_one($param);
		$customer['signup_country'] = $this->model_country->find_by_pk($customer['signup_country'])['country'];
		$customer['signup_shipping_country'] = $this->model_country->find_by_pk($customer['signup_shipping_country'])['country'];
		if($customer):
			$json_param['customer'] = $customer;
			$json_param['status'] = 1;
			$json_param['txt'] = 'Customer details loaded!';

		else:
			$json_param['status'] = 0;
			$json_param['txt'] = 'Something went wrong!';
		endif;

		echo json_encode($json_param);
	}
	
	public function update_dispatch($admin_order_id=''){
		$id=$_GET['id'];
		$dispatch_status=$_GET['st_type'];
		//debug($dispatch_status,1);
		if($dispatch_status==0){
		$updateadmin_order['admin_order_dispatch_status']=1;
		}else{
			$updateadmin_order['admin_order_dispatch_status']=0;
		}
		$this->model_admin_order->update_by_pk($id, $updateadmin_order);
		redirect(g('admin_base_url') . "admin_order");
	}
	public function detail($admin_order_id='')
	{   
		/** check rights before deletion **/
		$class_name = $this->router->class;
		$page_name = $class_name."_edit";
		//$this->admin_rights->check_admin_rights($page_name);
		
		//$this->add_script(array( "jquery.validate.js" , "form-validation-script.js") , "js" );

		$this->layout_data['template_config']['show_toolbar'] = false ;
		$this->register_plugins(array(						
									"jquery-ui",
									"bootstrap",
									"bootstrap-hover-dropdown",
									"jquery-slimscroll",
									"uniform",
									"boots",
									"font-awesome",
									"simple-line-icons" ,
									"select2",
									"bootbox",
									"bootstrap-toastr",
									"bootstrap-datetimepicker"
								));


		
		$data['admin_order_detail'] = $this->model_admin_order->get_admin_order_detail($admin_order_id);
		$recipt = $data['admin_order_detail']['admin_order_response'];
        $recipt = unserialize($recipt);
        $data['receipt_url'] = $recipt['receipt_url'];
		//$data['ashare_detail'] = $this->model_adshare->get_adshare_detail($data['admin_order_detail']['admin_order_adshare_id']);
        //debug($data[ 'ashare_detail' ]);
		//$data['country'] = $this->model_country->find_by_pk($data[ 'admin_order_detail' ]['admin_order_country']);
		
		if(!array_filled($data[ 'admin_order_detail' ]))
			not_found("Invalid admin_order ID");

        // check is parent value ste (use when someone reserve adspace in adshare).
        /*if($data[ 'ashare_detail' ]['adshare_is_parent']!=null){
            $old_data = $data['ashare_detail'];
            //debug($old_data);
            $data['ashare_detail'] = $this->model_adshare->get_adshare_detail($data[ 'ashare_detail' ]['adshare_is_parent']);
            //debug($data['ashare_detail']);
            // set old data value to new data
            $data['ashare_detail']['adshare_is_parent'] = $old_data['adshare_is_parent'];
            $data['ashare_detail']['adshare_number'] = $old_data['adshare_number'];

            // Set adshare id for adshare info
            $adshare_id = $data[ 'ashare_detail' ]['adshare_is_parent'];
        }
        else{
            // Set adshare id for adshare info
            $adshare_id = $data['admin_order_detail']['admin_order_adshare_id'];
        }*/
        //debug($data['ashare_detail'],1);

		$total_quantity = 0;
		$total_amount = 0;
		$item_data = $this->model_admin_order_item->get_admin_order_items($admin_order_id);
        //debug($item_data,1);

		foreach ($item_data as $key => $value) {

			$options = unserialize($value['admin_order_item_option']);

			$amount = $value['admin_order_item_subtotal'];
			//if(isset($options['subscription_tenure'])){
			//	$tenure = ($options['subscription_tenure'] == 2 ? '3' : '1');
			//	$amount = ($value['admin_order_item_subtotal']*$tenure);
			//}
			$total_amount += $amount;

			$total_quantity += $value['admin_order_item_qty'];
			//$total_amount += $value['admin_order_item_subtotal'];
		}


        // JOIN
        /*$param['joins'][] = array(
            "table"=>"adshare_attachment" ,
            "joint"=>"adshare_attachment.adshare_attachment_adshare_id = adshare_id",
        );*/
        //$adshare = (array) $this->model_adshare->find_by_pk($adshare_id, true,$param);
		
		$data[ 'total_quantity' ] = $total_quantity;
		$data[ 'total_amount' ] = $total_amount;
		$data[ 'admin_order_items' ] = $item_data;
		//$data[ 'adshare_info' ] = $adshare;
		$data[ 'page_title_min' ] = "Detail";
		$data[ 'page_title' ] = "admin_order";
		$data[ 'class_name' ] = "admin_order";
		$data[ 'model_name' ] = "model_admin_order";
		$data[ 'model_obj' ] = $this->model_admin_order;
		$data[ 'dt_params' ] = $this->dt_params ;
		$data[ 'id' ] = $id;
		
		if($data['admin_order_detail']['admin_order_custom_field'] != '' && strpos($data['admin_order_detail']['admin_order_custom_field'],':'))
		{
		 //   debug($admin_order_data['admin_order_custom_field'],1);
		    if(strpos($data['admin_order_detail']['admin_order_custom_field'],','))
		    {
		        $tmp_arr1 = explode(",",$data['admin_order_detail']['admin_order_custom_field']);
		        foreach($tmp_arr1 as $key => $val)
		        {
		            $tmp_arr2[$key] = explode(":",$val);
		            $tmp_arr2[$key]['label'] = $tmp_arr2[$key][0];
		            $tmp_arr2[$key]['value'] = $tmp_arr2[$key][1];
		            unset($tmp_arr2[$key][0]);
		            unset($tmp_arr2[$key][1]);
		            $fin_arr = $tmp_arr2;
		        }
		    }
		    else{
		        $tmp_arr1 = explode(":",$data['admin_order_detail']['admin_order_custom_field']);
		        $fin_arr[0]['label'] = $tmp_arr1[0];
		        $fin_arr[0]['value'] = $tmp_arr1[1];
		    }
		    $data['admin_order_detail']['admin_order_custom_field'] = $fin_arr;
		  //  debug($fin_arr,1);
		}
        // debug($data,1);

		//$this->load_view("invoice" , $data);
		$this->load_view("detail" , $data);
	}

	public function index()
	{
		// Popluated LISTDATA in constructor
		parent::index();
		
	}
	
public function get_view($id=0)
	{
		global $config;
		$result = array();
		$class_name = $this->router->class;
		$model_name = 'model_'.$class_name ;
		$model_obj = $this->$model_name ;
		$form_fields = $model_obj->get_fields();
		if($id)
		{
			$result['record'] = $this->$model_name->find_by_pk($id);
			$result['record'] = $this->$model_name->prepare_view_data($result['record']);
			if(!$result['record'] )
				$result['failure'] = "No Item Found";
				// Load relation fields data
			$relation_data = $this->$model_name->get_relation_data($id);
			if(array_filled($relation_data))
				$result['record']['relation_data'] = $relation_data;
		}
		else
		{
			$result['failure'] = "No Item Found";
		}

		return $result;

	}
	
public function stripe_capture_payment()
	{
		$order_id = $this->input->post('order_id');
		$order = $this->model_order->find_by_pk($order_id);
		// debug($order,1);
		require_once(APPPATH . 'libraries/stripe-sdk/init.php');
		// $stripe_charge_id = $order['order_response'];
		// $param001['where']['config_variable'] = 'stripe_secret_key';
		// $data001 = $this->model_config->find_one($param001);
		// debug($data001,1);
		$order_response = unserialize($order['order_response']);
		// 	debug(unserialize($order['order_response']),1);
		// 	debug($order_response['id'],1);
		$stripe = new \Stripe\StripeClient(g('db.admin.stripe_secret_key'));

		$response = $stripe->charges->capture($order_response['id'],[]);
		if($response['captured'] == 1)
		{
			$update_param['order_payment_status'] = 3;
			$update_param['order_response_after_capture'] = serialize($response);
			$updated_id = $this->model_order->update_by_pk($order_id,$update_param);
			if($updated_id)
			{
				$order = $this->model_order->find_by_pk($order_id);
				$this->invoice_email($order);
			}
			$param['status'] = 1;
			$param['msg'] = "Success";    
		}
		else
		{
			$param['status'] = 0;
			$param['msg'] = "Failed";
		}
		echo json_encode($param);
	}

public function dispatch_order()
	{
		$order_id = $this->input->post('order_id');
		$tracking_id = $this->input->post('tracking_id');
		$order = $this->model_order->find_by_pk($order_id);
		if($order)
		{
			$update_param['order_tracking_number'] = $tracking_id;
			$update_param['order_payment_status'] = 4;
			$update_param['order_dispatch_status'] = 1;
			$update_param['order_payment_comments'] = 'Dispatched';
			$updated_id = $this->model_order->update_by_pk($order_id, $update_param);
			if($updated_id)
			{
				$order = $this->model_order->find_by_pk($order_id);
				$this->invoice_email($order);
			}
			$param['status'] = 1;
		}
		else
		{
			$param['status'] = 0;
		}
		echo json_encode($param);
	}

public function complete_order()
	{
		$order_id = $this->input->post('order_id');
		$order = $this->model_order->find_by_pk($order_id);
		if($order)
		{
			$update_param['order_payment_status'] = 1;
			$update_param['order_payment_comments'] = 'Completed';
			$updated_id = $this->model_order->update_by_pk($order_id, $update_param);
			
			if($updated_id)
			{
				$order = $this->model_order->find_by_pk($order_id);
				$this->invoice_email($order);
			}
			$param['status'] = 1;
		}
		else
		{
			$param['status'] = 0;
		}
		echo json_encode($param);
	}

public function stripe_refund_payment()
	{
		$order_id = $this->input->post('order_id');
		$amount = $this->input->post('refund_amount');
		$amount = $amount * 100; // $ to cents
		$order = $this->model_order->find_by_pk($order_id);
		// debug($order,1);
		require_once(APPPATH . 'libraries/stripe-sdk/init.php');
		// $stripe_charge_id = $order['order_response'];
		// $param001['where']['config_variable'] = 'stripe_secret_key';
		// $data001 = $this->model_config->find_one($param001);
		// debug($data001,1);
		$order_response = unserialize($order['order_response']);
		// 	debug(unserialize($order['order_response']),1);
		// 	debug($order_response['id'],1);
		// $stripe = new \Stripe\StripeClient($data001['config_value']);
		$stripe = new \Stripe\StripeClient(g('db.admin.stripe_secret_key'));

		$response = $stripe->refunds->create([
			'charge' => $order_response['id'],
			'amount' => $amount]);
		
		if($response['status'] == 'succeeded')
		{
			$update_param['order_payment_status'] = 8;
			$update_param['order_payment_comments'] = 'Refunded';
			$update_param['order_refund_amount'] = $amount + $order['order_refund_amount'];
			$update_param['order_response_after_refund'] = serialize($response);
			$updated_id = $this->model_order->update_by_pk($order_id,$update_param);
			if($updated_id)
			{
				$order = $this->model_order->find_by_pk($order_id);
				$this->invoice_email($order);
			}

			$param['status'] = 1;
			$param['msg'] = "Success";    
		}
		else
		{
			$param['status'] = 0;
			$param['msg'] = "Failed";
		}
		echo json_encode($param);
	}

public function stripe_cancel_payment()
	{
		$order_id = $this->input->post('order_id');
		$order = $this->model_order->find_by_pk($order_id);
		// debug($order,1);
		require_once(APPPATH . 'libraries/stripe-sdk/init.php');
		// $stripe_charge_id = $order['order_response'];
		// $param001['where']['config_variable'] = 'stripe_secret_key';
		// $data001 = $this->model_config->find_one($param001);
		// debug($data001,1);
		$order_response = unserialize($order['order_response']);
		// 	debug(unserialize($order['order_response']),1);
		// 	debug($order_response['id'],1);
		// $stripe = new \Stripe\StripeClient($data001['config_value']);
		$stripe = new \Stripe\StripeClient(g('db.admin.stripe_secret_key'));

		$response = $stripe->refunds->create([
			'charge' => $order_response['id']]);
		
		if($response['status'] == 'succeeded')
		{
			$update_param['order_payment_status'] = 6;
			$update_param['order_payment_comments'] = 'Cancelled';
			$update_param['order_response_after_refund'] = serialize($response);
			$updated_id = $this->model_order->update_by_pk($order_id,$update_param);
			if($updated_id)
			{
				$order = $this->model_order->find_by_pk($order_id);
				$this->invoice_email($order);
			}
			$param['status'] = 1;
			$param['msg'] = "Success";    
		}
		else
		{
			$param['status'] = 0;
			$param['msg'] = "Failed";
		}
		echo json_encode($param);
	}

public function invoice_email($getorderDetail)
        //public function invoice_email()
	{
		/*$order_id = 28;
		$getorderDetail = $this->model_order->find_by_pk($order_id);*/

		// $title = 'Order Confirmation - Invoice #' . $getorderDetail['order_id'];
		if($getorderDetail['order_payment_status'] == 1){
			$title = 'Order Completed - Invoice #'.$getorderDetail['order_id']; 

			} 
			elseif($getorderDetail['order_payment_status'] == 2){
			$title = 'Order Created - Invoice #'.$getorderDetail['order_id'];}

		    elseif($getorderDetail['order_payment_status'] == 3){ 
			$title = 'Order Payment Approved - Invoice #'.$getorderDetail['order_id'];}

			elseif($getorderDetail['order_payment_status'] == 4){ 
			$title = 'Order Dispatched - Invoice #'.$getorderDetail['order_id'].' - Tracking #'.$getorderDetail['order_tracking_number'];}

			elseif($getorderDetail['order_payment_status'] == 5){ 
			$title = 'Order Hold - Invoice #'.$getorderDetail['order_id'];}

    		elseif($getorderDetail['order_payment_status'] == 6){
    			$title = 'Order Cancelled - Invoice #'.$getorderDetail['order_id'];}
    
    		elseif($getorderDetail['order_payment_status'] == 7){
    			$title = 'Order Declined - Invoice #'.$getorderDetail['order_id'];}
    
    		elseif($getorderDetail['order_payment_status'] == 8){
    			$title = 'Order Payment Refunded - Invoice #'.$getorderDetail['order_id'];
    			}

		$param['joins'][] = array(
			"table" => "product",
			"joint" => "product.product_id = order_item.order_item_product_id"
		);

		$param['where']['order_item_order_id'] = $getorderDetail['order_id'];
		$data['cart'] = $this->model_order_item->find_all($param);
		$data['order_detail'] = $getorderDetail;
		$data['userdata'] = $this->user_info;

		$template = $this->load->view("_layout/email_template/invoice", $data, true);
		//$template = $this->load->view("_layout/email_template/invoice",$data,false);

		$to = $data['order_detail']['order_billing_email'];
		//  debug($to); 
		//  debug(g("db.admin.email")); 
		//  debug($title); 
		//  debug($template,1);
		parent::create_invoice_pdf($data);
		$this->model_email->invoice_email_temp($to, $template, $title);
		$to = g("db.admin.email");
        $this->model_email->invoice_email_temp($to, $template, $title);
	}

public function refresh_cart()
{
	$cart_data = $this->cart->contents();
	$cart_count = count($this->cart->contents());
	$cart_total = $this->cart->total();
	$total_weight = 0;
	$cart_body = '';
	// debug($cart_data,1);
	foreach($cart_data as $key=>$value):
	$total_product_weight = $value['options']['product_weight']*$value['qty'];
	$total_weight = $total_weight + $total_product_weight;
	$cart_body .= "
		<tr>
			<td>{$value['options']['product_sku']}</td>
			<td>{$value['name']}</td>
			<td>$ {$value['price']}</td>
			<td>{$value['qty']}</td>
			<td>$ {$value['subtotal']}</td>
		</tr";
	endforeach;
	
	$cart_info = "
	<li><strong style='color:#333'>Total Products</strong> : <span id='cart_total_items'>{$cart_count}</span> </li>
	<li><strong style='color:#333'>Total Weight</strong> : <span id='cart_total_weight'>{$total_weight} oz</span></li>
	<li><strong style='color:#333'>Total Price</strong> : <span id='cart_total'>$ {$cart_total}</span>  </li>";

	$param['cart_body'] =$cart_body;
	$param['cart_info'] =$cart_info;
	echo json_encode($param);
}

public function create_admin_order()
	{
		if($this->validate('model_admin_order'))
		{
			$admin_order_data = $this->input->post('admin_order');
			$admin_order_data['admin_order_status'] = 1; // 1 - Checkout needed // 0 - Checkout already done
			
			$admin_order_data['admin_order_firstname'] = $admin_order_data['admin_order_billing_firstname'];
            $admin_order_data['admin_order_lastname'] = $admin_order_data['admin_order_billing_lastname'];
            $admin_order_data['admin_order_company'] = $admin_order_data['admin_order_billing_company'];
            $admin_order_data['admin_order_address1'] = $admin_order_data['admin_order_billing_address'];
            $admin_order_data['admin_order_city'] = $admin_order_data['admin_order_billing_city'];
            $admin_order_data['admin_order_country'] = $admin_order_data['admin_order_billing_country'];
            $admin_order_data['admin_order_phone'] = $admin_order_data['admin_order_billing_phone'];
            $admin_order_data['admin_order_email'] = $admin_order_data['admin_order_billing_email'];
            $admin_order_data['admin_order_state'] = $admin_order_data['admin_order_billing_state'];
            $admin_order_data['admin_order_zip'] = $admin_order_data['admin_order_billing_zip'];
			
			$order_state = $this->model_state->find_by_pk($admin_order_data['admin_order_state']);
			$admin_order_data['admin_order_state'] = $order_state['state_name'];

			$shipping_state = $this->model_state->find_by_pk($admin_order_data['admin_order_shipping_state']);
			$admin_order_data['admin_order_shipping_state'] = $shipping_state['state_name'];
			
			$billing_state = $this->model_state->find_by_pk($admin_order_data['admin_order_billing_state']);
			$admin_order_data['admin_order_billing_state'] = $billing_state['state_name'];

			$admin_order_data['admin_order_total'] = $this->cart->total();
			$admin_order_data['admin_order_amount'] = $this->cart->total() + $admin_order_data['admin_order_tax'] + $admin_order_data['admin_order_shipment_price'];
    			
    			if($admin_order_data['admin_order_custom_field'] != '' && strpos($admin_order_data['admin_order_custom_field'],':'))
    			{
    			 //   debug($admin_order_data['admin_order_custom_field'],1);
    			    if(strpos($admin_order_data['admin_order_custom_field'],','))
    			    {
    			        $tmp_arr1 = explode(",",$admin_order_data['admin_order_custom_field']);
    			        foreach($tmp_arr1 as $key => $val)
    			        {
    			            $tmp_arr2[$key] = explode(":",$val);
    			            $fin_val += $tmp_arr2[$key][1]; 
    			        }
    			    }
    			    else{
    			        $tmp_arr1 = explode(":",$admin_order_data['admin_order_custom_field']);
    			        $fin_val += $tmp_arr1[1];
    			    }
    			    $admin_order_data['admin_order_amount'] += $fin_val;
    			}

				$merchantfee = $admin_order_data['admin_order_merchantfee'] ;
				if($merchantfee == g('db.admin.custom_charges')){
				    $tt = g('db.admin.custom_charges');
				}
				else{
    			    $tt = number_format((($admin_order_data['admin_order_amount'] / 100) * $merchantfee), 2, '.', ''); 
		        }
    			
    			$admin_order_data['admin_order_amount'] += $tt;
    			
			$inserted_id = $this->model_admin_order->insert_record($admin_order_data);

			
			
			if ($inserted_id > 0) 
			{
				$cart_data = $this->cart->contents();
				//debug($cart_data,1);
				/** Add items **/

				foreach ($cart_data as $key => $value)
					{
						//$oitem['order_currency_type'] = $this->currency;
						$oitem['admin_order_item_status'] = 1;
						$oitem['admin_order_item_order_id'] = $inserted_id;
						$oitem['admin_order_item_product_id'] = $value['id'];
						$oitem['admin_order_item_price'] = $value['price'];
						$oitem['admin_order_item_subtotal'] = $value['subtotal'];
						$oitem['admin_order_item_qty'] = $value['qty'];
						$oitem['admin_order_item_name'] = $value['name'];
						$oitem['admin_order_item_user_id'] = $this->userid;
						$oitem['admin_order_item_option'] = serialize($value['options']);
						$this->model_admin_order_item->insert_record($oitem);
						// debug($oitem);
					}

					$admin_order_param['admin_order_token'] = md5($inserted_id.time());
					$admin_order_param['admin_order_link'] = base_url().'checkout/step1/'.$admin_order_param['admin_order_token'];
					$this->model_admin_order->update_by_pk($inserted_id, $admin_order_param);
					$this->cart->destroy();
					$param['status'] = 1;
					$param['txt'] = 'Admin Order Created Successfully';
					$param['url'] = $url;
					$param['oid'] = $inserted_id;
					$param['order_amount'] = $order_data['order_total'];
					// debug($url,1);
					echo json_encode($param);
			}
			else 
			{
				$param['status'] = 0;
				$param['txt'] = 'Failed to create order. Please try later.';
				echo json_encode($param);
			}
		
				// debug($admin_order_data,1);
		}
	
	else 
	{
		$param['status'] = 0;
		$param['txt'] = validation_errors();
		//$param['txt'] = 'Please complete all required fields';
		echo json_encode($param);
	}

}

public function get_order_item_total_price($order_id)
{
	$orderItemParam['where']['admin_order_item_order_id'] = $order_id;
	$oldOrderItems = $this->model_admin_order_item->find_all($orderItemParam);
	$total = 0;
	foreach($oldOrderItems as $key=>$value)
	{
		$total += $value['admin_order_item_subtotal'];
	}
	return $total;
}

public function update_admin_order()
{
	if($this->validate('model_admin_order'))
	{
		$admin_order_data = $this->input->post('admin_order');
		$oldOrderItemsTotal = $this->get_order_item_total_price($admin_order_data['admin_order_id']);
		// debug($oldOrderItemsTotal,1);

		$order_state = $this->model_state->find_by_pk($admin_order_data['admin_order_state']);
		$admin_order_data['admin_order_state'] = $order_state['state_name'];

		$shipping_state = $this->model_state->find_by_pk($admin_order_data['admin_order_shipping_state']);
		$admin_order_data['admin_order_shipping_state'] = $shipping_state['state_name'];
		
		$billing_state = $this->model_state->find_by_pk($admin_order_data['admin_order_billing_state']);
		$admin_order_data['admin_order_billing_state'] = $billing_state['state_name'];

		$admin_order_data['admin_order_total'] = $this->cart->total() + $oldOrderItemsTotal;
		$admin_order_data['admin_order_amount'] = $admin_order_data['admin_order_total'] + $admin_order_data['admin_order_tax'] + 
													$admin_order_data['admin_order_shipment_price'];
													
		
		if($admin_order_data['admin_order_custom_field'] != '' && strpos($admin_order_data['admin_order_custom_field'],':'))
		{
		 //   debug($admin_order_data['admin_order_custom_field'],1);
		    if(strpos($admin_order_data['admin_order_custom_field'],','))
		    {
		        $tmp_arr1 = explode(",",$admin_order_data['admin_order_custom_field']);
		        foreach($tmp_arr1 as $key => $val)
		        {
		            $tmp_arr2[$key] = explode(":",$val);
		            $fin_val += $tmp_arr2[$key][1]; 
		        }
		    }
		    else{
		        $tmp_arr1 = explode(":",$admin_order_data['admin_order_custom_field']);
		        $fin_val += $tmp_arr1[1];
		    }
		    $admin_order_data['admin_order_amount'] += $fin_val;
		}

		$merchantfee = $admin_order_data['admin_order_merchantfee'] ;
		
		if($merchantfee == g('db.admin.custom_charges')){
				    $tt = g('db.admin.custom_charges');
		}
		else{
		    $tt = number_format((($admin_order_data['admin_order_amount'] / 100) * $merchantfee), 2, '.', ''); 
        }
		
// 		$tt = number_format((($admin_order_data['admin_order_amount'] / 100) * $merchantfee), 3, '.', ''); 
    			
		$admin_order_data['admin_order_amount'] += $tt;
		
		$isAffected = $this->model_admin_order->update_by_pk($admin_order_data['admin_order_id'],$admin_order_data);
		// debug($this->db->last_query());
		// debug($inserted_id,1);

		$cart_data = $this->cart->contents();
		//debug($cart_data,1);
		/** Add items **/
		// debug($cart_data,1);
		$newItems = 0;
			
		foreach ($cart_data as $key => $value)
		{
			//$oitem['order_currency_type'] = $this->currency;
			$oitem['admin_order_item_status'] = 1;
			$oitem['admin_order_item_order_id'] = $admin_order_data['admin_order_id'];
			$oitem['admin_order_item_product_id'] = $value['id'];
			$oitem['admin_order_item_price'] = $value['price'];
			$oitem['admin_order_item_subtotal'] = $value['subtotal'];
			$oitem['admin_order_item_name'] = $value['name'];
			$oitem['admin_order_item_qty'] = $value['qty'];
			$oitem['admin_order_item_user_id'] = $this->userid;
			$oitem['admin_order_item_option'] = serialize($value['options']);
			$newItems += $this->model_admin_order_item->insert_record($oitem);
			// debug($oitem);
		}

		// $admin_order_param['admin_order_token'] = md5($inserted_id.time());
		// $admin_order_param['admin_order_link'] = base_url().'checkout/step2/'.$admin_order_param['admin_order_token'];
		// $this->model_admin_order->update_by_pk($inserted_id, $admin_order_param);
		$this->cart->destroy();

		if($isAffected == 1 && $newItems>0)
		{
			$param['status'] = 1;
			$param['txt'] = 'Admin Order Saved Successfully';
			$param['url'] = $url;
			$param['oid'] = $admin_order_data['admin_order_id'];
			$param['order_amount'] = $order_data['order_total'];
		}
		// debug($url,1);
			
		elseif($isAffected == 1 && $newItems < 1)
		{
			$param['status'] = 1;
			$param['txt'] = 'Admin Order Saved Successfully';
			$param['url'] = $url;
			$param['oid'] = $admin_order_data['admin_order_id'];
			$param['order_amount'] = $order_data['order_total'];
		}
		elseif($isAffected == 0 && $newItems>0)
		{
			$param['status'] = 1;
			$param['txt'] = 'Admin Order Saved Successfully';
			$param['url'] = $url;
			$param['oid'] = $admin_order_data['admin_order_id'];
			$param['order_amount'] = $order_data['order_total'];
		}
		else
		{
			$param['status'] = 0;
			$param['txt'] = 'No changes in order to save.';
		}
		echo json_encode($param);
	
			// debug($admin_order_data,1);
	}
	
	else 
	{
		$param['status'] = 0;
		$param['txt'] = validation_errors();
		//$param['txt'] = 'Please complete all required fields';
		echo json_encode($param);
	}
}

}


/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
