<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class User extends MY_Controller
{

    /**
     * User Controller
     *
     * @package        User Controller
     * @version        1.0
     * @since        11-Apr-2018
     */

    private $json_param = array();


    public function __construct()
    {
        // Call the Model constructor latest_product
        parent::__construct();
        if ($this->userid > 1)
            $this->load_view('login');
    }

    // Login/Signup View
    public function index()
    {
        // Temporary redirect
        // redirect(l('portal'));
        global $config;
        $data=array();
        // Redirect user if session set
        // if($this->userid){
        //     redirect(l(''));
        // }
        // Get banner
        // $data['banner'] = $this->model_inner_banner->find_by_pk(2);
        // Sign up / Login main page
        //$this->load_view('login', $data);
        $this->load_view('index', $data);
    }

    // Login Viewlogin-process
    public function login()
    {
        global $config;

        // $user_id = $this->session->userdata('userdata')['signup_id'];

        // $this->cart->destroy();

        // // Clear user session
        // $this->session->unset_userdata('userdata');
        // redirect(l('login'));

        // Redirect user if session set
        // if($this->userid){
        //     redirect(l(''));
        // }
        // Get banner
        // $data['banner'] = $this->model_inner_banner->find_by_pk(8);
        // Sign up / Login main page
        $data['meta_dat']['title'] = 'Login';
        $this->load_view('login', $data);
    }

    // Sign up View
    public function register()
    {
        global $config;

        // Redirect user if session set
        if($this->userid){
            redirect(l(''));
        }
        // Get banner
        // $data['banner'] = $this->model_banner->get_banners(7);
        // Get Countries
        //$data['countries'] = $this->model_country->find_all_active();
        // Sign up / Login main page
        $this->load_view('register');
    }

    // Sign up View
    public function signup()
    {
        global $config;

        // Redirect user if session set
        if($this->userid){
            redirect(l(''));
        }
        // Get banner
        $data['banner'] = $this->model_inner_banner->find_by_pk(7);
        // Get Countries
        //$data['countries'] = $this->model_country->find_all_active();
        // Sign up / Login main page
        $this->load_view('signup', $data);
    }

    // Insert Record
    public function save()
    {
        global $config;
        $signup = $this->input->post('signup');
        // Get post data
        // debug( $signup,1);
        if (array_filled($signup) > 0) {

            $custom_rule = array(
                'signup_password_confirm'=>array(
                    'field'=>'signup_password_confirm',
                    'label'=>'Confirm Password',
                    'rules'=>'required|md5|trim|matches[signup[signup_password]]'
                )
            );
            if ($this->validate("model_signup")) 
            {
                $signup['signup_token'] = "";
                $signup['signup_status'] = STATUS_ACTIVE;
                $signup['signup_password'] = md5($signup['signup_password']);
                $this->model_signup->set_attributes($signup);
                $inserted_id = $this->model_signup->insert_record($signup);
                // Record insert successfully
                if($inserted_id > 0)
                {
                    // if(ENVIRONMENT!='development'){
                        // Send confirmation email
                        //$this->model_email->_verification_email($signup,$inserted_id);
                        //sleep(2);
                        // Welcome email
                        // $this->model_email->send_welcome_email($signup['signup_email']);

                    // }

                    $this->model_signup->auto_login($inserted_id);
                    $this->json_param['status'] = true;
                    $this->json_param['txt'] = 'Registered successfully. Page will be redirected automatically within 5 seconds..';
                }
                else
                {
                    $this->json_param['status'] = false;
                    $this->json_param['txt'] = 'Something went wrong.Please try later.';
                }

            }
            // Validation failed
            else
            {
                $this->json_param['status'] = false;
                $this->json_param['txt'] = 'Given email is already registered';
            }
        }
        echo json_encode($this->json_param);
    }

    // Email Verification
    public function confirmation()
    {
        // Get data
        $email = $this->input->get('email');
        $token = $this->input->get('token');

        if((!empty($email)) && (!empty($token))){
            // Where condition
            $params['where']['signup_email'] = $email;
            $params['where']['signup_token'] = $token;

            // Run query
            $query = $this->model_signup->find_one($params);

            //Check record found or not
            if(count($query)>0){
                // Change user status active
                $upd_data = array(
                    'signup_token'=>'',
                    'signup_status'=>1
                );

                $upd_query = $this->model_signup->update_by_pk($query['signup_id'],$upd_data);
                $msg = 'Thank you! Your Email has been verified successfully.';
                redirect(l('?msgtype=success&msg=' . urlencode($msg)));
            }
            else{
                $msg = 'Something went wrong.Please try later.';
                redirect(l('404'));
            }
        }
        else{
            $msg = 'Invalid credentials.';
            redirect(l('?msgtype=error&msg=' . urlencode($msg)));
        }
    }

    // Login action
    public function login_process()
    {
        // debug($_POST,1);
        // Get post data
        $login = $this->input->post('signup');
        //$refer_url = $this->input->post('refer');

        if(array_filled(array_filter($login)) > 0)
        {
            // debug($login,1);
            // Set params
            $params['where']['signup_userid'] = $login['signup_userid'];
            // Query
            $params['where']['signup_status !='] = STATUS_DELETE;
            $data = $this->model_signup->find_one($params);

        

            // Login success
            if($login['signup_userid'] == $data['signup_userid'] && (md5($login['signup_password'])) ==
                $data['signup_password']  && ($data['signup_status']=='1'))
            {
                // Set user session (session will be set on layout data
                $this->model_signup->set_user_session($data);
               // echo "dfgdfgdfg".$this->session->userdata('signup_user');
               // exit();
                
                $this->json_param['status'] = true;
                $this->json_param['txt'] = 'Login successfully.';
                // debug($this->cart->contents());
                if($data['signup_type'] == 1 && count($this->cart->contents()) > 0){
                    $cartData = $this->cart->contents();
                    foreach($cartData as $key => $val){
                        $param['where']['product_id'] = $val['id'];
                        $param['fields'] = 'product_id,proudct_wholesale_discount';
                        $disPrice = $this->model_product->find_one($param);
                        $disPrice['price'] = $val['qty'] * $disPrice['proudct_wholesale_discount'];

                        $data['rowid'] = $key;
                        $data['price'] = $disPrice['proudct_wholesale_discount'];
                        $data['subtotal'] = $val['qty'] * $disPrice['proudct_wholesale_discount'];

                        $this->cart->update($data);
                    }
                    // debug($this->cart->contents(),1);
                }
            }
            // Deleted Account
            elseif($data['signup_status']=='2'){
                $this->json_param['status'] = false;
                $this->json_param['txt'] = 'Account is Deleted.';
            }
            // Inactive and unverified
            elseif($data['signup_status']=='0' && (!empty($data['signup_token']))){
                $this->json_param['status'] = false;
                $this->json_param['txt'] = 'Account verification is required.Kindly Check your inbox.';
            }
            // In active
            elseif($data['signup_status']=='0'){
                $this->json_param['status'] = false;
                $this->json_param['txt'] = 'Account suspended.';
            }
            // Login fail
            else
            {
                $this->json_param['status'] = false;
                $this->json_param['txt'] = 'Invalid UserID / password';
                //$this->json_param['refer'] = g('base_url');
            }

        }
        else{
            $this->json_param['status'] = false;
            $this->json_param['txt'] = 'Fields required';
            //$this->json_param['refer'] = g('base_url');
        }
        // $this->cart->destroy();
        echo json_encode($this->json_param);

    }

    // Load edit user view
    public function edit()
    {
        // Redirect user if session not set
        if($this->session->userdata('userdata')==null){
            redirect(l('login'));
        }

        // Define layout
        $this->layout = 's8_main';

        // Set body class
        $this->layout_data['body_class'] = "responsive timelineBody";

       // Define page
        $this->load_view('edit_profile');
    }

    // Check user password
    public function password_check($str)
    {
        $user_id = $this->session->userdata('userdata')['signup_id'];
        $params['where']['signup_id'] = $user_id;
        $params['where']['signup_password'] = md5($str);
        if($this->model_signup->find_one($params, true)){
            return TRUE;
        }
        else{
            $this->form_validation->set_message('password_check', lang('invalid_pass'));
            return FALSE;
        }
    }

    // Delete Record
    public function delete()
    {

    }

    // Forgot Password
    public function forgot()
    {
        // Get Post Data
        $email = $this->input->post('signup');
        // Get Captcha
      //  $captcha_answer = $this->input->post('g-recaptcha-response');
        // $this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'required');

        // check Input data empty or not
        $this->form_validation->set_rules('signup[signup_email]', 'Email', 'required|valid_email');
        // Set validation rules for google captcha
        // $this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'required');
        $this->form_validation->set_error_delimiters("<span style=\"color:white;\" for=\"%s\" class=\"has-error help-block\">", '</span>');

        if ($this->form_validation->run() == FALSE)
        {
            $this->json_param['status'] = false;
            $this->json_param['txt'] = validation_errors();
        }
        else
        {
            // Verify user's answer
            // $response = $this->recaptcha->verifyResponse($captcha_answer);
            // debug($response,1);
            // Processing ...
            if (2==2) {
                // Send email
                // Query to check email exists or not
                $params['where']['signup_email'] = $email['signup_email'];
                $query = $this->model_signup->find_one_active($params);
                if(count($query)>0){
                    // Remove old token if exist
                    $where_params['where']['token_user_id'] = $query['signup_id'];
                    $data = array(
                        'token_status'=>STATUS_INACTIVE
                    );
                    $this->model_token->update_model($where_params,$data);
                    // Generate token
                    $token = md5(time());
                    $data = array(
                        'token_user'=>$token,
                        'token_user_id'=>$query['signup_id'],
                        'token_status'=>1
                    );
                    // Save token
                    $this->model_token->set_attributes($data);
                    $this->model_token->save();

                    // debug($query,1);
                    // Send email
                    // CHANGE THIS FOR OTHER PROJECT
                    $this->model_email->_notification_forgot_password($query,$token);
                // $this->model_email->_notification_forgot_password_smtp($query,$token);
                    $this->json_param['status'] = true;
                    $this->json_param['txt'] = 'If your email address exists in our database, you will receive a password recovery link at your email address in a few minutes.';
                }
                else{
                    $this->json_param['status'] = true;
                    $this->json_param['txt'] = 'If your email address exists in our database, you will receive a password recovery link at your email address in a few minutes.';
                }
            }
            else{
                // Something goes wrong
                $this->json_param['status'] = 0;
                $this->json_param['txt'] = 'Captcha not verified';
            }
        }
        echo json_encode($this->json_param);

    }

    // Forgot Password View
    public function forgot_password()
    {
        // Get data
        $user_id = $this->input->get('id');
        $token   = $this->input->get('token');

        if((!empty($user_id)) && (!empty($token)) && (!$this->session->userdata('userdata')['signup_id'])){
            // Where condition for token expire
            $params['where']['token_user_id'] = $user_id;
            $params['where']['token_user']    = $token;

            // Token found
            if($this->model_token->find_one_active($params)){
                // Run query
                $params_user['where']['signup_id'] = $user_id;
                $query = $this->model_signup->find_one($params_user);

                // Set banner heading
                $data['banner_heading'] = "Reset Password";

                //Check record found
                if(count($query)>0){
                    $data['token_user'] = $token;
                    $data['user_id'] = $user_id;

                    // Get banner
                    $data['inner_banner'] = $this->model_inner_banner->find_by_pk(9);

                    $this->load_view('forgot_password',$data);
                }
                // User ID not found
                else{
                    redirect(l('404'));
                }
            }
            // Token not found
            else{
                redirect(l('404'));
            }
        }
        // Invalid credentials
        else{
            redirect(l('404'));
        }
    }

    public function reset_password()
    {
        // Get Post data
        $user_id  = $this->input->post('user_id');
        $token    = $this->input->post('token');
        $password = $this->input->post('password');

        // check Input data empty or not
        $this->form_validation->set_rules('user_id', 'User ID', 'required|trim');
        $this->form_validation->set_rules('token', 'Token', 'required|trim');
        $this->form_validation->set_rules('password', 'Password', 'required|trim');
        $this->form_validation->set_error_delimiters("<span style=\"color:white;\" for=\"%s\" class=\"has-error help-block\">", '</span>');

        // Validation error
        if ($this->form_validation->run() == FALSE)
        {
            $this->json_param['status'] = false;
            $this->json_param['txt'] = validation_errors();
        }
        // No validation
        else{
            // Where condition for token expire
            $params['where']['token_user_id'] = $user_id;
            $params['where']['token_user']    = $token;

            // Token found
            if($this->model_token->find_one_active($params)){
                // Set token status to 0
                $this->model_token->update_model($params,array('token_status'=>STATUS_INACTIVE));

                // Change password
                $this->model_signup->update_by_pk($user_id,array('signup_password'=>md5($password)));

                $this->json_param['status'] = true;
                $this->json_param['txt'] = 'Reset password successfully.';

            }
            // Token not found
            else{
                $this->json_param['status'] = false;
                $this->json_param['txt'] = 'Authentication fail.';
            }
        }

        echo json_encode($this->json_param);
    }


    function pay_with_paypal() {
        if($_POST) {          
            $postDetail = $_POST['orderDetails'];
            $token = $this->token();
            $order_url = $postDetail['links'][0]['href']; // Replace with the actual order URL
            $access_token = $token; // Replace with your PayPal access token
            $ch = curl_init($order_url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Authorization: Bearer '.$access_token
            ));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            if(curl_errno($ch)) {
                echo 'cURL error: '.curl_error($ch);
            } else {
                $order_data = json_decode($response);
                if(isset($order_data->id)) {                    
                    $params = $_SESSION['signupdata'];
                    $params['signup_payment_status'] = 1;
                    $params['signup_status'] = 1;
                    $params['signup_payment_comments'] = 'Completed';
                    $params['signup_merchant'] = 'Paypal';
                    $params['signup_merchant_response'] = serialize($response);
                    $params['signup_amount'] = $_POST['price'];
                    $inserted_id= $this->model_signup->insert_record($params);
                    $params2['booking_course_id']=$_POST['booking_course_id'];
                    $params2['booking_time_slots']=$_POST['slotId'];
                    $params2['booking_amount']=$_POST['price'];
                    $params2['booking_amount_type']=$_SESSION['payment'];
                    $params2['booking_userid']=$inserted_id;
                    $params2['booking_payment_status']='1';
                    $inserted_id2= $this->model_booking->insert_record($params2);
                   if($inserted_id2 > 0){
                  
                   $result= $this->model_signup->find_by_pk($inserted_id);
                    $data['course']= $this->model_course->find_by_pk($_POST['booking_course_id']);
                    $data['time_detail'] = $this->db->select('*')->from('fb_time_slots')->where('time_slots_id', $_POST['slotId'])->get()->row_array();
                    if($data['time_detail']['time_slots_seats'] != NULL){
                        $this->db->where('time_slots_id', $data['slotId'])->update('fb_time_slots',array('time_slots_seats'=>$data['time_detail']['time_slots_seats']-1));
                     }
                    // $this->db->where('time_slots_id', $_POST['slotId'])->update('fb_time_slots',array('time_slots_seats'=>$data['time_detail']['time_slots_seats']-1));
                    $data['signupdata']=$_SESSION['signupdata'];
                    $data['logo'] = $this->model_logo->find_one_active();
                    $template=$this->load->view('_layout/email_template/course_template',$data , true);
                    $this->model_email->course_mail($template,$result['signup_email']);

                    $this->session->sess_destroy();
                    $this->json_param['status'] = true;
                    $this->json_param['txt'] = 'Registered successfully. You will be logged in automatically. Page will be redirected automatically within 5 seconds..';
                    $this->json_param['url'] = base_url().'thankyou';
                    echo json_encode($this->json_param);
                   }
                } else {
                    $this->json_param['status'] = false;
                    $this->json_param['txt'] = "Payment canceled. If you have any questions, please contact support.";
                    echo json_encode($this->json_param);
                }
            }
            curl_close($ch);
        }
    }


    function token() {
        // PayPal OAuth 2.0 token endpoint URL

        $env = g('db.admin.paypal_enviroment');
        $client_id = g('db.admin.paypal_client_id');
        $client_secret = g('db.admin.paypal_secret_key');

        if($env == 'sandbox') {
            $token_url = 'https://api.sandbox.paypal.com/v1/oauth2/token'; // For the sandbox environment

        } else {

            $token_url = 'https://api.paypal.com/v1/oauth2/token';
        }


        // Create a basic authorization header
        $authorization = base64_encode($client_id.':'.$client_secret);

        // Set cURL options for the token request
        $ch = curl_init($token_url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Basic '.$authorization));
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'grant_type=client_credentials');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Execute the cURL request
        $response = curl_exec($ch);

        // Check for cURL errors
        if(curl_errno($ch)) {
            echo 'cURL error: '.curl_error($ch);
            // Handle the error as needed
        } else {
            // Decode the JSON response
            $token_data = json_decode($response);

            // Check if the request was successful
            if(isset($token_data->access_token)) {
                // Access token is in $token_data->access_token
                return $token_data->access_token;
            } else {
                echo 'Error obtaining access token';
                // Handle the error as needed
            }
        }

        // Close cURL session
        curl_close($ch);
    }



    // Logout
    public function logout()
    {
        $user_id = $this->session->userdata('userdata')['signup_id'];

        $this->cart->destroy();

        // Clear user session
        $this->session->unset_userdata('userdata');
        redirect(l());
    }
}