<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require APPPATH.'libraries/square-php-sdk/autoload.php';
use Square\SquareClient;
use Square\Environment;
class Home extends MY_Controller
{
    /**
     * Default Controller
     */

    public $per_page = 12;
    public function __construct()
    {
        // Call the Model constructor latest_product
        parent::__construct();
    }

    // Default Home Page
    public function index()
    {
        // global $config;
        $data['meta_dat']['title'] = 'Classes for Everyone, See Schedule | Temple Hills, MD';
        $data['meta_dat']['description'] = 'Check out our diverse class schedule in Temple Hills, MD. From phlebotomy to CPR, find the right training for your needs. Enroll now!';
        $data['banner'] = $this->model_banner->find_by_pk(1);

        //     $data['cms_about'] = $this->model_cms_page->find_by_pk(1);
        //     $data['cms_sec_one'] = $this->model_cms_page->find_by_pk(2);
        //     $data['cms_elda_blog'] = $this->model_cms_page->find_by_pk(3);
        //     $data['cms_devotion'] = $this->model_cms_page->find_by_pk(4);
        //     $data['cms_become'] = $this->model_cms_page->find_by_pk(5);
        //     $data['cms_verse'] = $this->model_cms_page->find_by_pk(6);
        //     $data['cms_testimonial'] = $this->model_cms_page->find_by_pk(7);
        //     $data['cms_subscribe'] = $this->model_cms_page->find_by_pk(8);

        //     $data['latest_blogs'] = $this->model_blog->get_latest_blogs(2);
        //     $data['elda_blog'] = $this->model_blog->get_blogs_random(2);

        //     $param['order'] = 'testimonial_id DESC';
        //     $param['limit'] = 2;
        //     $data['testimonial'] = $this->model_testimonial->find_all_active($param);
        // //

        // $param['joins'][] = array(
        //     "table" => "time_slots",
        //     "joint" => "time_slots.time_slots_course_id = course.course_id",
        //     // "type" => "left"
        // );
        // $result = $this->model_course->find_all($param);
        // // debug($this->db->last_query(),1);
        // $courses = [];
        // foreach ($result as $row) {
        //     $courseId = $row['course_id'];
        //     $courseName = $row['course_name'];
        //     $detail = $row['course_detail'];
        //     $image = $row['course_image_path'] . $row['course_image'];
        //     $logo = $row['course_image_path'] . $row['course_logo'];
        //     if (!isset($courses[$courseId])) {
        //         $courses[$courseId] = [
        //             'course_id' => $courseId,
        //             'course_name' => $courseName,
        //             'detail' => $detail,
        //             'images' => $image,
        //             'logo' => $logo,
        //             'time_slots' => [],
        //         ];
        //     }
        //     $courses[$courseId]['time_slots'][] = [
        //         'time_slots_start_date' => $row['time_slots_start_date'],
        //         'time_slots_end_date' => $row['time_slots_end_date'],
        //         'time_slots_start_time' => $row['time_slots_start_time'],
        //         'time_slots_end_time' => $row['time_slots_end_time'],
        //         'time_slots_evening_start_time' => $row['time_slots_evening_start_time'],
        //         'time_slots_evening_end_time' => $row['time_slots_evening_end_time'],
        //         'time_slots_type' => $row['time_slots_type'],
        //         'time_slots_course_id' => $row['time_slots_course_id']
        //     ];
        // }
        // // debug($this->db->last_query());

        // $data['course'] = $courses;
        $course = $this->model_course->find_all_active();
        $courseData = [];

        foreach ($course as $courses) {
            $param['where']['time_slots_course_id'] = $courses['course_id'];
            $slots = $this->model_time_slots->find_all_active($param);
            $courseData[] = [
                'course' => $courses,
                'timeslots' => $slots,
            ];
        }
        $data['course'] = $courseData;
        // debug($data['course'],1);
        $this->load_view('index', $data);
    }
    public function detail($slug, $slot)
    {
        $data['course'] = $this->model_course->find_by_slug($slug);
        $data['time_detail'] = $this->db->select('*')->from('fb_time_slots')->where('md5(time_slots_id)', $slot)->get()->row_array();

        $data['slot'] = $slot;
        $data['slug'] = $slug;
        $this->load_view('detail', $data);
    }
    public function register($slug, $slot)
    {
        $data['course'] = $this->model_course->find_by_slug($slug);
        $data['time_detail'] = $this->db->where('md5(time_slots_id)', $slot)->select('*')->from('fb_time_slots')->get()->row_array();
// debug($data['time_detail'],1);
        $data['slot'] = $slot;
        $data['slug'] = $slug;
        $data['cms'] = $this->model_cms_page->find_by_pk(1);
        $data['state'] = $this->model_state->find_all();
        $this->load_view('register', $data);
    }
    public function register_2($slug, $slot)
    {
        // debug($_SESSION);
        if (empty($_SESSION['signupdata'])) {
            redirect(l(''));
        }
        $data['course'] = $this->model_course->find_by_slug($slug);
        $data['time_detail'] = $this->db->select('*')->from('fb_time_slots')->where('md5(time_slots_id)', $slot)->get()->row_array();
        // debug($data['time_detail'], 1);
        $data['slot'] = $slot;
        $data['slug'] = $slug;
        $this->load_view('register_2', $data);
    }
    public function thankyou()
    {
        $this->load_view('thankyou');
    }
    function blog_detail($slug = '')
    {
        $param['where']['blog_slug'] = $slug;
        $data['blog'] = $this->model_blog->find_one_active($param);
        if ($data['blog']) {
            $data['banner'] = $this->model_banner->find_by_pk(6);
            $data['meta_dat']['title'] = $data['blog']['blog_title'] . ' | Dynamic Phlebotomy';
            $this->load_view('blog_detail', $data);
        } else {
            redirect(l('404'), true);
        }
    }

    function blog()
    {
        $slug = $this->uri->segment(2);
        $data['meta_dat']['title'] = 'Blogs | Dynamic Phlebotomy';
        $data['banner'] = $this->model_banner->find_by_pk(6);
        $param01['joins'][] = [
            'table' => 'blog_category',
            'joint' => 'blog_category.blog_category_id = blog.blog_category',
            'type' => '',
        ];
        if ($slug != '') {
            $param01['where']['blog_category_slug'] = $slug;
        }
        $param01['order'] = 'blog_id DESC';
        $data['blogs'] = $this->model_blog->find_all_active($param01);
        $this->load_view('blog', $data);
    }
    public function about()
    {
        $data['meta_dat']['title'] = 'About | Dynamic Phlebotomy';
        $data['banner'] = $this->model_banner->find_by_pk(2);
        $data['cms_data'] = $this->model_cms_page->find_by_pk(1);
        $this->load_view('about', $data);
    }

    public function contact()
    {
        $data['meta_dat']['title'] = 'Contact Us | Dynamic Phlebotomy';
        $data['banner'] = $this->model_banner->find_by_pk(12);
        $this->load_view('contact', $data);
    }
    public function inquirySubmit()
    {
        $formData = $_POST;
        $inserted_id = $this->model_inquiry->insert_record($formData);
        if ($inserted_id) {
            $param['status'] = 1;
            $param['txt'] = 'Form Submitted Sucessfully';
        } else {
            $param['status'] = 0;
            $param['txt'] = 'Form Not Submitted';
        }
        echo json_encode($param);
    }
    public function testimonial()
    {
        $data['meta_dat']['title'] = 'Testimonials | Dynamic Phlebotomy';
        $data['banner'] = $this->model_banner->find_by_pk(7);

        $param['order'] = 'testimonial_id DESC';
        $data['testimonial'] = $this->model_testimonial->find_all_active($param);
        $this->load_view('testimonial', $data);
    }

    public function faq()
    {
        $data['meta_dat']['title'] = 'FAQs | Dynamic Phlebotomy';
        $data['banner'] = $this->model_banner->find_by_pk(11);

        $data['faqs'] = $this->model_faq->find_all_active();
        $this->load_view('faq', $data);
    }

    function privacy_policy()
    {
        $data['banner'] = $this->model_banner->find_by_pk(15);
        $data['cms'] = $this->model_cms_page->find_by_pk(18);
        $this->load_view('privacy_policy', $data);
    }

    function term_conditions()
    {
        $data['meta_dat']['title'] = 'Terms | Dynamic Phlebotomy';
        $data['banner'] = $this->model_banner->find_by_pk(14);
        $data['cms'] = $this->model_cms_page->find_by_pk(17);
        $this->load_view('term_conditions', $data);
    }

    public function newsletter()
    {
        global $config;
        if (count($_POST) > 0) {
            if ($this->validate('model_newsletter')) {
                $data = $_POST['newsletter'];
                $data['newsletter_status'] = 1;
                $inserted_id = $this->model_newsletter->insert_record($data);

                if ($inserted_id > 0) {
                    $param['status'] = 1;
                    $param['txt'] = 'Thank you for subscribing with us..';
                    echo json_encode($param);
                } else {
                    $param['status'] = 0;
                    $param['txt'] = 'Operation failed due to unknown reason, please try again later or contact support if the problem persists.';
                    echo json_encode($param);
                }
            } else {
                $param['status'] = 0;
                $param['txt'] = validation_errors();
                echo json_encode($param);
            }
        }
    }
    function get_time_slots()
    {
        // debug($_POST);
        $course = $this->model_course->find_by_pk($_POST['courseId']);
        $a = '';
        if ($_POST['type'] == '1') {
            $param = ['time_slots_course_id' => $_POST['courseId'], 'time_slots_type' => $_POST['type'], 'time_slots_status' => 1];
            $result = $this->db->where($param)->select('*')->from('fb_time_slots')->order_by('time_slots_start_date', 'ASC')->get()->result_array();
            // debug($result, 1);
            if (!empty($result)) {
                foreach ($result as $row) {
                    $timess=[date('h:i A',strtotime($row['time_slots_start_time'])),date('h:i A',strtotime($row['time_slots_end_time']))];
                    // $timess=date('h:i A',strtotime($row['time_slots_start_time'])).' - '.date('h:i A',strtotime($row['time_slots_end_time']));
                    $startDate = new DateTime($row['time_slots_start_date']);
                    $endDate = new DateTime($row['time_slots_end_date']);
                    $startDayName = $startDate->format('l');
                    $endDayName = $endDate->format('l');    
                    $times = implode(' or ',  $timess);
                    $startDayWithSuffix = $startDate->format('jS');
                    $endDayWithSuffix = $endDate->format('jS');
                    $month = $startDate->format('F');
                    $b= "$startDayName or $endDayName $times ($startDayWithSuffix or $endDayWithSuffix $month)";
                    $a .= '<a  data-id="' . $row['time_slots_type'] . '" href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($row['time_slots_id']) . '" class="mb-2">' .$b.'</a>';

                }
            } else {
                $a .= '<p style="margin-top: 14px;color: red;margin-left: 22px;">Time Slots Not Available</p>';
            }
        } 
        elseif($_POST['type'] == '3'){
                // debug('if');
                $param = ['time_slots_course_id' => $_POST['courseId'], 'time_slots_type' => $_POST['type'], 'time_slots_status' => 1];
                $result = $this->db->where($param)->select('*')->from('fb_time_slots')->order_by('time_slots_start_date', 'ASC')->get()->result_array();
                // debug($result, 1);
                if (!empty($result)) {
                    foreach ($result as $row) {
                        if ($row['time_slots_day_or_date'] == '1') {
                            if($row['time_slots_seats'] ==NULL || $row['time_slots_seats'] >0){
                                if($row['time_slots_seats'] != NULL){
                                  $slots='<span style="color:#b9000e">Available Slots:<b>'.$row['time_slots_seats'].'</b></span>';
                                }
                                else {
                                    $slots='';
                                }
                                if($_POST['courseId'] == 1 || $_POST['courseId'] == 3){
                                    $a .= '<a  data-id="' . $row['time_slots_type'] . '" href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($row['time_slots_id']) . '" class="mb-2">' .$slots.  date('F jS', strtotime($row['time_slots_start_date'])) . ' - ' . date('F jS', strtotime($row['time_slots_end_date'])) . ' Morning Class: ' . date('g:i a', strtotime($row['time_slots_start_time'])) . ' - ' . date('g:i a', strtotime($row['time_slots_end_time'])).' (Monday - Thursday)</a>';
                                }else{
                                    $a .= '<a  data-id="' . $row['time_slots_type'] . '" href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($row['time_slots_id']) . '" class="mb-2">' .$slots.  date('F jS', strtotime($row['time_slots_start_date'])) . ' - ' . date('F jS', strtotime($row['time_slots_end_date'])) . ' Morning Class: ' . date('g:i a', strtotime($row['time_slots_start_time'])) . ' - ' . date('g:i a', strtotime($row['time_slots_end_time'])).'</a>';
                                }
                       
                            }
                            else {
                                $a .= '<span style="color:grey">Available Slots:0</b></span><a class="mb-2" style="color:grey !important;">' . date('F jS', strtotime($row['time_slots_start_date'])) . ' - ' . date('F jS', strtotime($row['time_slots_end_date'])) . ' Morning Class: ' . date('g:i a', strtotime($row['time_slots_start_time'])) . ' - ' . date('g:i a', strtotime($row['time_slots_end_time'])) .'</a>';
                       
                            }
                         }
                        if ($row['time_slots_day_or_date'] == '2') {
                            if($row['time_slots_seats'] ==NULL || $row['time_slots_seats'] >0){
                                if($row['time_slots_seats'] != NULL){
                                    $slots='<span style="color:#b9000e">Available Slots:<b>'.$row['time_slots_seats'].'</b></span>';
                                }
                                    else {
                                        $slots='';
                                    }
                            $a .= '<a  data-id="' . $row['time_slots_type'] . '" href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($row['time_slots_id']) . '" class="mb-2">' .$slots.  $row['time_slots_day'] . ' ' . date('g:i a', strtotime($row['time_slots_start_time'])) . ' - ' . date('g:i a', strtotime($row['time_slots_end_time'])) . '</a>';
                            }
                            else {
                                $a .= '<span style="color:grey">Available Slots:0</b></span><a   style="color:grey !important;" class="mb-2">' . $row['time_slots_day'] . ' ' . date('g:i a', strtotime($row['time_slots_start_time'])) . ' - ' . date('g:i a', strtotime($row['time_slots_end_time'])) . '</a>';
                            
                            }
                        }
                    }
                } else {
                    $a .= '<p style="margin-top: 14px;color: red;margin-left: 22px;">Time Slots Not Available</p>';
                }
            
        }
        elseif($_POST['type'] == '4'){
            $param = ['time_slots_course_id' => $_POST['courseId'], 'time_slots_type' => $_POST['type'], 'time_slots_status' => 1];
            $result = $this->db->where($param)->select('*')->from('fb_time_slots')->order_by('time_slots_start_date', 'ASC')->get()->result_array();
            // debug($result, 1);
            if (!empty($result)) {
                foreach ($result as $row) {
                    if ($row['time_slots_day_or_date'] == '1') {
                        if($row['time_slots_seats'] ==NULL || $row['time_slots_seats'] >0){
                            if($row['time_slots_seats'] != NULL){
                              $slots='<span style="color:#b9000e">Available Slots:<b>'.$row['time_slots_seats'].'</b></span>';
                            }
                            else {
                                $slots='';
                            }
                            if($_POST['courseId'] == 1 || $_POST['courseId'] == 3){
                                $a .= '<a  data-id="' . $row['time_slots_type'] . '" href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($row['time_slots_id']) . '" class="mb-2">' .$slots.  date('F jS', strtotime($row['time_slots_start_date'])) . ' - ' . date('F jS', strtotime($row['time_slots_end_date'])) . ' Evening Class: ' . date('g:i a', strtotime($row['time_slots_start_time'])) . ' - ' . date('g:i a', strtotime($row['time_slots_end_time'])).' (Monday - Thursday)</a>';
                            }else{
                                $a .= '<a  data-id="' . $row['time_slots_type'] . '" href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($row['time_slots_id']) . '" class="mb-2">' .$slots.  date('F jS', strtotime($row['time_slots_start_date'])) . ' - ' . date('F jS', strtotime($row['time_slots_end_date'])) . ' Evening Class: ' . date('g:i a', strtotime($row['time_slots_start_time'])) . ' - ' . date('g:i a', strtotime($row['time_slots_end_time'])).'</a>';   
                            }
                        }
                        else {
                            $a .= '<span style="color:grey">Available Slots:0</b></span><a class="mb-2" style="color:grey !important;">' . date('F jS', strtotime($row['time_slots_start_date'])) . ' - ' . date('F jS', strtotime($row['time_slots_end_date'])) . ' Evening Class: ' . date('g:i a', strtotime($row['time_slots_start_time'])) . ' - ' . date('g:i a', strtotime($row['time_slots_end_time'])) .'</a>';
                   
                        }
                     }
                    if ($row['time_slots_day_or_date'] == '2') {
                        if($row['time_slots_seats'] ==NULL || $row['time_slots_seats'] >0){
                            if($row['time_slots_seats'] != NULL){
                                $slots='<span style="color:#b9000e">Available Slots:<b>'.$row['time_slots_seats'].'</b></span>';
                            }
                            else {
                                $slots='';
                            }
                            $a .= '<a  data-id="' . $row['time_slots_type'] . '" href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($row['time_slots_id']) . '" class="mb-2">' .$slots.  $row['time_slots_day'] . ' ' . date('g:i a', strtotime($row['time_slots_start_time'])) . ' - ' . date('g:i a', strtotime($row['time_slots_end_time'])) . '</a>';
                        }
                        else {
                            $a .= '<span style="color:grey">Available Slots:0</b></span><a   style="color:grey !important;" class="mb-2">' . $row['time_slots_day'] . ' ' . date('g:i a', strtotime($row['time_slots_start_time'])) . ' - ' . date('g:i a', strtotime($row['time_slots_end_time'])) . '</a>';
                        }
                    }
                }
            } else {
                $a .= '<p style="margin-top: 14px;color: red;margin-left: 22px;">Time Slots Not Available</p>';
            }
        
        }
        elseif($_POST['type'] == '2') {
            // debug('else');
            $param = ['time_slots_course_id' => $_POST['courseId'], 'time_slots_type' => $_POST['type'], 'time_slots_status' => 1];
            $result = $this->db->where($param)->select('*')->from('fb_time_slots')->order_by('time_slots_start_date', 'ASC')->get()->result_array();

            if (!empty($result)) {

                    if($result['0']['time_slots_seats'] ==NULL || $result['0']['time_slots_seats'] >0){
                            if($result['0']['time_slots_seats'] != NULL){
                                $slots='<span style="color:#b9000e">Available Slots:<b>'.$result['0']['time_slots_seats'].'</b></span>';
                                }
                                else {
                                    $slots='';
                                }
                            }
                            // echo $slots;
                $groupedDates = [];
                foreach ($result as $row) {
                    $times=date('h:i A',strtotime($row['time_slots_start_time'])).' - '.date('h:i A',strtotime($row['time_slots_end_time']));
                    $dateTime = new DateTime($row['time_slots_start_date']);
                    $dateTimeEnd = new DateTime($row['time_slots_end_date']);
                    $monthYear = $dateTime->format('F Y'); // Get the full month name and year
                    $monthYearEnd = $dateTimeEnd->format('F Y'); // Get the full month name and year
                    $courseId_8_month = $dateTime->format('F'); // Get the full month name and year
                    $courseId_8_month_End = $dateTimeEnd->format('F'); // Get the full month name and year
                    $dayWithSuffix = $dateTime->format('jS'); // Get the day with suffix
                    $EnddayWithSuffix = $dateTimeEnd->format('jS'); // Get the day with suffix
                    $dayEndWithSuffix = $dateTimeEnd->format('jS'); // Get the day with suffix
                    $time = $row['time']; // Get the associated time
                    if($_POST['courseId'] == 1){
                        $groupedDates[$monthYear][] = ['day' => $dayWithSuffix. ' ' . $monthYear . ' - ' . $dayEndWithSuffix .' '. $monthYearEnd, 'time' => $times,'time_slots_seats'=>$row['time_slots_seats'],'time_slots_id' => $row['time_slots_id']]; 
                    }else if($_POST['courseId'] == 8){
                        $monthYear_8 = $dateTime->format('F'); // Get the full month name and year
                        $monthYearEnd_8 = $dateTimeEnd->format('F'); // Get the full month name and year
                        $groupedDates[$monthYear][] = ['day' => $monthYear_8.' '.$dayWithSuffix. ' - ' . $monthYearEnd_8.' '.$dayEndWithSuffix , 'time' => $times,'time_slots_seats'=>$row['time_slots_seats'],'time_slots_id' => $row['time_slots_id']]; 
                    }else{
                        $groupedDates[$monthYear][] = ['day' => $dayWithSuffix ,'end_day' => $EnddayWithSuffix, 'time' => $times,'time_slots_seats'=>$row['time_slots_seats'],'time_slots_id' => $row['time_slots_id']];
                        // debug($groupedDates);
                    }
                }


                foreach ($groupedDates as $month => $dates) {
                    $ad.=$slots.'<br>';
                    //  $ad.="$month:<br>";
                    $slots='<span style="color:#b9000e">Available Slots:<b>'.$dates['0']['time_slots_seats'].'</b></span>';
                    // Create a temporary array to hold dates grouped by time within the month
                    $timeGrouped = [];
                    foreach ($dates as $date) {
                        $timeGrouped[$date['time']][] = $date['day'];
                        $end_day = $date['end_day'];
                    }
                    // Display the dates grouped by time within the month
                    // debug($end_day);
                    foreach ($timeGrouped as $time => $days) {
                        $dayString = implode(', ', $days);
                        $as= "$dayString Weekend Class: $time ";
                        
                        // if($_POST['courseId'] == 2 || $_POST['courseId'] == 1){
                        if($_POST['courseId'] == 1){
                            $asd= '<a  href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($dates['0']['time_slots_id']) . '" class="mb-2">' ."$slots $month:<br>".$as. '<br> Saturdays and Sundays</a>';
                        }else if($_POST['courseId'] == 2){
                            $asd= '<a  href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($dates['0']['time_slots_id']) . '" class="mb-2">' ."$slots $month: ".$as. '<br> Sundays Only</a>';
                        }else if($_POST['courseId'] == 8){
                            $asd= '<a  href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($dates['0']['time_slots_id']) . '" class="mb-2">' ."$slots Medical Assistant Weekends Only</br> ".$dayString.'<br> Saturday and Sunday '.$time.'</a>';
                        }else{
                            $asd= '<a  href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($dates['0']['time_slots_id']) . '" class="mb-2">' ."$slots $month:<br>".$as. '<br></a>';
                        }
                        
                    }
                    $a .=  $asd."<br>"; // Add a line break between months
                }

            } else {
                $a .= '<p style="margin-top: 14px;color: red;margin-left: 22px;">Time Slots Not Available</p>';
            }
        }
        elseif($_POST['type'] == '5') {
            $param = ['time_slots_course_id' => $_POST['courseId'], 'time_slots_type' => $_POST['type'], 'time_slots_status' => 1];
            $result = $this->db->where($param)->select('*')->from('fb_time_slots')->order_by('time_slots_start_date', 'ASC')->get()->result_array();
            // debug($result, 1);
            if (!empty($result)) {
                foreach ($result as $row) {
                    $timess=[date('h:i A',strtotime($row['time_slots_start_time'])),date('h:i A',strtotime($row['time_slots_end_time']))];
                    // $timess=date('h:i A',strtotime($row['time_slots_start_time'])).' - '.date('h:i A',strtotime($row['time_slots_end_time']));
                    $startDate = new DateTime($row['time_slots_start_date']);
                    $endDate = new DateTime($row['time_slots_end_date']);
                    $startDayName = $startDate->format('l');
                    $endDayName = $endDate->format('l');    
                    $times = implode(' or ',  $timess);
                    $startDayWithSuffix = $startDate->format('jS');
                    $endDayWithSuffix = $endDate->format('jS');
                    $month = $startDate->format('F');
                    if($_POST['courseId'] == 4 || $_POST['courseId'] == 6 || $_POST['courseId'] == 5){
                        $b= "$startDayName or $endDayName $times";
                    }else{
                        $b= "$startDayName or $endDayName $times ($startDayWithSuffix or $endDayWithSuffix $month)";
                    }
                    
                    $a .= '<a  data-id="' . $row['time_slots_type'] . '" href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($row['time_slots_id']) . '" class="mb-2">' .$b.'</a>';

                }
            } else {
                $a .= '<p style="margin-top: 14px;color: red;margin-left: 22px;">Time Slots Not Available</p>';
            }
        }        
        elseif($_POST['type'] == '6') {
            // debug('else');
            $param = ['time_slots_course_id' => $_POST['courseId'], 'time_slots_type' => $_POST['type'], 'time_slots_status' => 1];
            $result = $this->db->where($param)->select('*')->from('fb_time_slots')->order_by('time_slots_start_date', 'ASC')->get()->result_array();
            if (!empty($result)) {

                    if($result['0']['time_slots_seats'] ==NULL || $result['0']['time_slots_seats'] >0){
                            if($result['0']['time_slots_seats'] != NULL){
                                $slots='<span style="color:#b9000e">Available Slots:<b>'.$result['0']['time_slots_seats'].'</b></span>';
                                }
                                else {
                                    $slots='';
                                }
                            }
                            // echo $slots;
                $groupedDates = [];
                foreach ($result as $row) {
                    $times=date('h:i A',strtotime($row['time_slots_start_time'])).' - '.date('h:i A',strtotime($row['time_slots_end_time']));
                    $dateTime = new DateTime($row['time_slots_start_date']);
                    $month = $dateTime->format('F'); // Get the full month name
                    $dayWithSuffix = $dateTime->format('jS'); // Get the day with suffix
                    $time = $row['time']; // Get the associated time
                    $groupedDates[$month][] = ['day' => $dayWithSuffix, 'time' => $times,'time_slots_seats'=>$row['time_slots_seats'],'time_slots_id' => $row['time_slots_id']];
                
                }

                foreach ($groupedDates as $month => $dates) {
                    // debug($dates);
                    $ad.=$slots.'<br>';
                    //  $ad.="$month:<br>";
                    if($dates['0']['time_slots_seats'] != ''){
                        $slots='<span style="color:#b9000e">Available Slots:<b>'.$dates['0']['time_slots_seats'].'</b></span>';
                    }else{
                        $slots ='';
                    }
                    // Create a temporary array to hold dates grouped by time within the month
                    $timeGrouped = [];
                    foreach ($dates as $date) {
                        $timeGrouped[$date['time']][] = $date['day'];
                    }
                    
                    // Display the dates grouped by time within the month
                    foreach ($timeGrouped as $time => $days) {
                        $dayString = implode(', ', $days);
                        $as= "$dayString Weekend Class: $time ";
                        $asd= '<a  href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($dates['0']['time_slots_id']) . '" class="mb-2">' ."$slots $month:<br>".$as. '<br></a>';
                    }
                    $a .=  $asd."<br>"; // Add a line break between months
                }

            } else {
                $a .= '<p style="margin-top: 14px;color: red;margin-left: 22px;">Time Slots Not Available</p>';
            }
        }
        elseif($_POST['type'] == '7') {
            $param = ['time_slots_course_id' => $_POST['courseId'], 'time_slots_type' => $_POST['type'], 'time_slots_status' => 1];
            $result = $this->db->where($param)->select('*')->from('fb_time_slots')->order_by('time_slots_start_date', 'ASC')->get()->result_array();
            if (!empty($result)) {

                    if($result['0']['time_slots_seats'] ==NULL || $result['0']['time_slots_seats'] >0){
                            if($result['0']['time_slots_seats'] != NULL){
                                $slots='<span style="color:#b9000e">Available Slots:<b>'.$result['0']['time_slots_seats'].'</b></span>';
                                }
                                else {
                                    $slots='';
                                }
                            }
                            // echo $slots;
                $groupedDates = [];
                foreach ($result as $row) {
                    $times=date('h:i A',strtotime($row['time_slots_start_time'])).' - '.date('h:i A',strtotime($row['time_slots_end_time']));
                    $dateTime = new DateTime($row['time_slots_start_date']);
                    $month = $dateTime->format('F'); // Get the full month name
                    $dayWithSuffix = $dateTime->format('jS'); // Get the day with suffix
                    $time = $row['time']; // Get the associated time
                    // $groupedDates[$month][] = ['day' => $dayWithSuffix, 'time' => $times,'time_slots_seats'=>$row['time_slots_seats'],'time_slots_id' => $row['time_slots_id']];
                // debug($month);

                    $dateTimeEnd = new DateTime($row['time_slots_end_date']);
                    $monthYear = $dateTime->format('F Y'); // Get the full month name and year
                    $monthYearEnd = $dateTimeEnd->format('F Y'); // Get the full month name and year
                    $dayWithSuffix = $dateTime->format('jS'); // Get the day with suffix
                    $EnddayWithSuffix = $dateTimeEnd->format('jS'); // Get the day with suffix
                    $time = $row['time']; // Get the associated time
                    if($_POST['courseId'] == 3){
                        $groupedDates[$monthYear][] = ['day' => $dayWithSuffix ,'end_day' => $EnddayWithSuffix, 'time' => $times,'time_slots_seats'=>$row['time_slots_seats'],'time_slots_id' => $row['time_slots_id']];
                    }else{
                        $groupedDates[$month][] = ['day' => $dayWithSuffix, 'time' => $times,'time_slots_seats'=>$row['time_slots_seats'],'time_slots_id' => $row['time_slots_id']];
                    }
                }

                foreach ($groupedDates as $month => $dates) {
                    if($month !='February 2025'){
                    // debug($month);
                    $ad.=$slots.'<br>';
                    //  $ad.="$month:<br>";
                    if($dates['0']['time_slots_seats'] != ''){
                        $slots='<span style="color:#b9000e">Available Slots:<b>'.$dates['0']['time_slots_seats'].'</b></span>';
                    }else{
                        $slots ='';
                    }
                    // Create a temporary array to hold dates grouped by time within the month
                    $timeGrouped = [];
                    foreach ($dates as $date) {
                        $timeGrouped[$date['time']][] = $date['day'];
                    }
                    
                    // Display the dates grouped by time within the month
                    foreach ($timeGrouped as $time => $days) {
                        $dayString = implode(', ', $days);
                        $as= "$dayString Weekend Class: $time ";
                        if($_POST['courseId'] == 3){
                            $asd= '<a  href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($dates['0']['time_slots_id']) . '" class="mb-2">' ."$slots $month: ".$as. '<br> (Sundays Only)</a>';
                        }else{
                            $asd= '<a  href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($dates['0']['time_slots_id']) . '" class="mb-2">' ."$slots $month:<br>".$as. '<br></a>';
                        }
                    }
                    $a .=  $asd."<br>"; // Add a line break between months
                }
            }
            } else {
                $a .= '<p style="margin-top: 14px;color: red;margin-left: 22px;">Time Slots Not Available</p>';
            }
        }
        elseif($_POST['type'] == '8') {
            // debug('else');
            $param = ['time_slots_course_id' => $_POST['courseId'], 'time_slots_type' => $_POST['type'], 'time_slots_status' => 1];
            $result = $this->db->where($param)->select('*')->from('fb_time_slots')->order_by('time_slots_start_date', 'ASC')->get()->result_array();
            // debug($result);
            if (!empty($result)) {

                    if($result['0']['time_slots_seats'] ==NULL || $result['0']['time_slots_seats'] >0){
                            if($result['0']['time_slots_seats'] != NULL){
                                $slots='<span style="color:#b9000e">Available Slots:<b>'.$result['0']['time_slots_seats'].'</b></span>';
                                }
                                else {
                                    $slots='';
                                }
                            }
                            // echo $slots;
                $groupedDates = [];
                foreach ($result as $row) {
                    $times=date('h:i A',strtotime($row['time_slots_start_time'])).' - '.date('h:i A',strtotime($row['time_slots_end_time']));                    
                    $dateTime = new DateTime($row['time_slots_start_date']);
                    $dateTimeEnd = new DateTime($row['time_slots_end_date']);
                    $month = $dateTime->format('F'); // Get the full month name
                    $courseId_3_month = $dateTime->format('F'); // Get the full month name and year
                    $courseId_3_month_End = $dateTimeEnd->format('F');
                    $dayWithSuffix = $dateTime->format('jS'); // Get the day with suffix
                    $enddayWithSuffix = $dateTimeEnd->format('jS'); // Get the day with suffix
                    $time = $row['time']; // Get the associated time
                    $groupedDates[$month][] = ['day' => $dayWithSuffix,'end_month' => $courseId_3_month_End,'end_day' => $enddayWithSuffix ,'time' => $times,'time_slots_seats'=>$row['time_slots_seats'],'time_slots_id' => $row['time_slots_id']];
                    // debug($courseId_3_month);
                }
                
                foreach ($groupedDates as $month => $dates) {
                    $ad.=$slots.'<br>';
                    //  $ad.="$month:<br>";
                    if($dates['0']['time_slots_seats'] != ''){
                        $slots='<span style="color:#b9000e">Available Slots:<b>'.$dates['0']['time_slots_seats'].'</b></span>';
                    }else{
                        $slots ='';
                    }
                    // Create a temporary array to hold dates grouped by time within the month
                    // debug($dates);
                    $timeGrouped = [];
                    foreach ($dates as $date) {
                        $timeGrouped[$date['time']][] = $date['day'];
                        $end_day = $date['end_day'];
                        $end_month = $date['end_month'];
                        $start_month = $month;
                    }
                    // Display the dates grouped by time within the month
                    foreach ($timeGrouped as $time => $days) {
                        $dayString = implode(', ', $days);
                        $as= "$dayString Weekend Class: $time ";
                        if($_POST['courseId'] == 3){
                            $asd= '<a  href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($dates['0']['time_slots_id']) . '" class="mb-2">' ."$slots  $start_month ".$dayString.' - '.$end_month.' '.$end_day.' Weekend Class '.$time.'<br> (Saturday and Sunday) </a>';
                        }else{
                            $asd= '<a  href="' . base_url() . 'detail/' . $course['course_slug'] . '/' . md5($dates['0']['time_slots_id']) . '" class="mb-2">' ."$slots $month:<br>".$as. '<br></a>';
                        }
                    }
                    $a .=  $asd."<br>"; // Add a line break between months
                }
            } else {
                $a .= '<p style="margin-top: 14px;color: red;margin-left: 22px;">Time Slots Not Available</p>';
            }
        }
        echo $a;
    }

    function customer_store_data()
    {
        // debug($_POST,1);

        $signup = $_POST['signup'];
        if (!empty($signup)) {
            $check_email = $signup['signup_email'];
            $validate_email = $this->db->query("SELECT `signup_email` FROM `fb_signup` WHERE `signup_email` = '" . $check_email . "' ")->row_array();
            $validate_email = $validate_email['signup_email'];
            if (!$validate_email) {
                if ($this->validate('model_signup')) {
                    $course = $this->model_course->find_by_pk($_POST['courseId']);
                    $this->session->set_userdata('signupdata', $signup);
                    $this->session->set_userdata('paymet', $_POST['flexRadioDefault']);
                    $this->json_param['status'] = true;
                    $this->json_param['url'] = base_url() . 'step2/' . $course['course_slug'] . '/' . md5($_POST['timeslot']);
                    echo json_encode($this->json_param);
                } else {
                    $this->json_param['status'] = false;
                    $this->json_param['txt'] = validation_errors();
                    echo json_encode($this->json_param);
                }
            } else {
                $this->json_param['status'] = false;
                $this->json_param['txt'] = 'Given email is already Exists';
                echo json_encode($this->json_param);
            }
        }
    }

    public function page_not_found()
    {
        $this->load_view('404');
    }

    // SQUARE PAYMENT METHOD
    public function square_payments()
    {
        $data = file_get_contents('php://input');
        $parsedData = json_decode($data, true);
        // debug($_SESSION, 1);
        // $booking_id = $parsedData['booking_id'];
        // debug($booking_id);
        // $param01['where']['booking_id'] = $booking_id;
        // $booking_data = $this->model_booking->find_one($param01);
        // debug($booking_data, 1);
        // $locationId = $parsedData['locationId'];
        $sourceId = $parsedData['sourceId'];
        // $verificationToken = $parsedData['verificationToken'];
        $idempotencyKey = $parsedData['idempotencyKey'];
        $client = new SquareClient([
            'accessToken' => 'EAAAl4jTZLfeOJH2jJx6x53UB0p6LgZODSqeufFGWy5cZc2VujFGNUSFdOMD4kLz',
            'environment' => Environment::SANDBOX,
        ]);
        $amount_money = new \Square\Models\Money();
        $amount_money->setAmount($parsedData['bookingAmount']*100);
        $amount_money->setCurrency('USD');
        // debug($sourceId);
        // debug($idempotencyKey);
        $body = new \Square\Models\CreatePaymentRequest($sourceId, $idempotencyKey);
        $body->setAmountMoney($amount_money);

        $api_response = $client->getPaymentsApi()->createPayment($body);
        if ($api_response->isSuccess()) {
            $postData['result'] = $api_response->getResult();
            $response = self::finalizeOrder($postData['result'], 'Sqaure' ,$parsedData);
            echo json_encode($response);
        } else {
            $result = $api_response->getErrors();
        }
    }
    public function finalizeOrder($response,$merchant,$data)
    {
        $params = $_SESSION['signupdata'];
        $params['signup_payment_status'] = 1;
        $params['signup_status'] = 1;
        $params['signup_payment_comments'] = 'Completed';
        $params['signup_merchant'] = $merchant;
        $params['signup_merchant_response'] = serialize($response);
        $params['signup_amount'] = $data['bookingAmount'];
        $inserted_id = $this->model_signup->insert_record($params);
        $params2['booking_course_id'] = $data['booking_course_id'];
        $params2['booking_time_slots'] = $data['slotId'];
        $params2['booking_amount'] = $data['bookingAmount'];
        $params2['booking_amount_type'] = $_SESSION['paymet'];
        $params2['booking_userid'] = $inserted_id;
        $params2['booking_payment_status'] = '1';
        $inserted_id2 = $this->model_booking->insert_record($params2);
        if ($inserted_id2 > 0) {
            $result = $this->model_signup->find_by_pk($inserted_id);
            $data['course'] = $this->model_course->find_by_pk($data['booking_course_id']);
            $data['time_detail'] = $this->db
                ->select('*')
                ->from('fb_time_slots')
                ->where('time_slots_id', $data['slotId'])
                ->get()
                ->row_array();
                $slotdetail= $this->db->select('*')->from('fb_time_slots')->where('time_slots_id', $data['slotId'])->get()->row_array();
                if($slotdetail['time_slots_seats'] != NULL){
                   $this->db->where('time_slots_id', $data['slotId'])->update('fb_time_slots',array('time_slots_seats'=>$data['time_detail']['time_slots_seats']-1));
                }
            $data['signupdata'] = $_SESSION['signupdata'];
            $data['logo'] = $this->model_logo->find_one_active();
            $template = $this->load->view('_layout/email_template/course_template', $data, true);
            $this->model_email->course_mail($template, $result['signup_email']);

            $this->session->sess_destroy();
            $this->json_param['status'] = 1;
            $this->json_param['txt'] = 'Booking created successfully, please wait..';
            $this->json_param['url'] = base_url() . 'thankyou';
            return($this->json_param);
        }
    }
}
