<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Dashboard extends MY_Controller {

	/**
	 * Account Controller
	 *
	 */
	
	public function __construct()
    {
    	// Call the Model constructor latest_product
        parent::__construct();
        if($this->userid <= 0){
			redirect(g('base_url').'employee-area');
		}
    }

    // Default Profile page
	public function index()
	{ 
		if($this->userid <= 0){
			redirect(g('base_url').'employee-area');
		}
		global $config;
        
        // Set banner heading
        //$data['banner_heading'] = "My Account";

        // $data['inner_banner'] = $this->model_inner_banner->find_by_pk(12);
        // print_r($data['inner_banner'] );
        // Get and set cms data
        // $data['content'] = $this->model_cms_page->get_page(12);
        // $data['sec12'] = $this->model_cms_page->get_page(12);

        // Get banner
        // $data['inner_banner'] = $this->model_banner->get_banners(8);

        //$data['inner_banner'] = $this->model_inner_banner->find_by_pk(2);
        $data['media']=$this->model_media->find_all_active();
		$this->load_view("index",$data);
	}

    //Account profile page
    public function profile(){
        if($this->userid <= 0){
			redirect(g('base_url').'login');
		}
		global $config;
      
        //$model = $this->cuser_model;
		//$this->add_script(array('innerstyle.css','font-awesome.min.css'));
		$data['userEmail'] = $this->session->userdata['userdata']['signup_email'];
		$data['userdata'] = $this->model_signup->find_by_pk($this->userid);
        // $param['fields'] = 'state_name';
        // $data['state'] = $this->model_state->find_all_active($param);
        $data['logo'] = $this->model_logo->find_all_active();

      
        $this->load_view("profile",$data);
    }

    // Account info page
	public function info(){
		if($this->userid <= 0){
			redirect(g('base_url').'login');
		}
		global $config;
        //$model = $this->cuser_model;
		//$this->add_script(array('innerstyle.css','font-awesome.min.css'));
		$data['userEmail'] = $this->session->userdata['logged_in']['email'];
		$data['userdata'] = $this->model_signup->find_by_pk($this->userid);

        // Get Countries
        $data['countries'] = $this->model_country->find_all_active();

        $data['inner_banner'] = $this->model_inner_banner->find_by_pk(14);

		//$data['title'] = 'My Account Info';
        // Set banner heading
        $data['banner_heading'] = "Account Info";

        // 1:parent/teacher , 2:kid
        //$view = ($this->user_type==1)?'info':'kid/info';

		$this->load_view("info" , $data);
	}

    public function update_info()
    {
        $signup_data = $this->input->post('signup');
      

        if((count($_POST) > 0) && (array_filled($signup_data)))
        {
            
                $status = $this->model_signup->update_by_pk($this->userid,$signup_data);

                if($status > 0)
                {
                    // Update session
                    $this->model_signup->update_user_session($signup_data);

                    $param['status'] = 1;
                    $param['txt'] = 'Data has been updated successfully.';
                    echo json_encode($param);
                }
                else
                {
                    $param['status'] = 0;
                    $param['txt'] = 'Fail to update record';
                    echo json_encode($param);
                }
            }
      
        else{
            $param['status'] = 0;
            $param['txt'] = "Please enter required field";
            echo json_encode($param);
        }
    }

    public function update_shipping()
    {
        $signup_data = $this->input->post('signup');
        
        if((count($_POST) > 0) && (array_filled($signup_data)))
        {
            // if($this->validate("model_signup"))
            // {
                $status = $this->model_signup->update_by_pk($this->userid,$signup_data);

                if($status > 0)
                {
                    // Update session
                    $this->model_signup->update_user_session($signup_data);

                    $param['status'] = 1;
                    $param['txt'] = 'Data has been updated successfully.';
                    echo json_encode($param);
                }
                else
                {
                    $param['status'] = 0;
                    $param['txt'] = 'Fail to update record';
                    echo json_encode($param);
                }
            }
      
        else{
            $param['status'] = 0;
            $param['txt'] = "Please enter required field";
            echo json_encode($param);
        }
    }

    public function orderhistory(){
		if($this->userid <= 0){
			redirect(g('base_url').'login');
		}
		global $config;
		$data['userEmail'] = $this->session->userdata['logged_in']['email'];     
     

		$data['title'] = 'Order History';

		$this->load_view("orderhistory" , $data);
	}
	

    public function addspotsubscription(){

        $data['userEmail'] = $this->session->userdata['logged_in']['email'];
		$data['userdata'] = $this->model_signup->find_by_pk($this->userid);    
        $data['addSpot'] = $this->model_add_spot->find_all_active();
        
        $this->load_view("addspotsubscription", $data);
    }

    public function addspotcheckout($slug="")
    {   
        if(!$this->userid){
            redirect(g('base_url').'login');      
        }
        
        $data['userdata'] = $this->model_signup->find_by_pk($this->userid);
        $param['where']['add_spot_slug'] = $slug;
        $data['add_spot_plan'] = $this->model_add_spot->find_one($param);
        $data['merchant'] = g('db.admin.merchant');
        if($data['add_spot_plan']){

            $this->load_view("addspotcheckout", $data);
        }else{
            $this->load_view('404');
        }   
    }

    public function save_order()
    {
        if (1) {
            $signupID = 0;
            $form_name = 'order';
            $order_data = $_POST['order'];
            $planid = $_POST['plan']['add_plan_id'];
            $userdata = $this->model_signup->find_by_pk($this->userid);
        
            $order_data['order_user_id'] = $this->userid;           
            
            $order_data['order_amount'] = round($order_data['order_amount'],2);
            $order_data['order_total'] = $order_data['order_amount'];
            $order_data['order_payment_status'] = 0;
            $order_data['order_status'] = 1; 
            $order_data['order_email'] = $userdata['signup_email'];
            $order_data['order_shipping_firstname'] = $order_data['order_firstname'];
            $order_data['order_shipping_lastname'] = $order_data['order_lastname'];
            $order_data['order_shipping_address1'] = $order_data['order_address1'];
            $order_data['order_shipping_phone'] = $order_data['order_phone'];
            $order_data['order_add_spot_id'] = $planid;
            // debug($order_data,1);
            
            $inserted_id = $this->model_order->insert_record($order_data);
            $order_number_param['order_number'] = 'CoulduTell-Add-Spot-'.$inserted_id;
            $this->model_order->update_by_pk($inserted_id, $order_number_param);
            
            if ($inserted_id > 0) {                              

              
                $url = g('base_url') . "dashboard/step3?oid=" . $inserted_id;
                
                $param['status'] = 1;
                $param['txt'] = 'Order Saved Successfully';
                $param['url'] = $url;
                $param['oid'] = $inserted_id;
                $param['order_amount'] = $order_data['order_amount'];
                // debug($url,1);
                echo json_encode($param);
            } else {
                $param['status'] = 0;
                $param['txt'] = 'Failed to create order. Please try later.';
                echo json_encode($param);
            }
        } else {
            $param['status'] = 0;
            $param['txt'] = validation_errors();
            //$param['txt'] = 'Please complete all required fields';
            echo json_encode($param);
        }

    }

    public function stripe_payment()
    {
       
        $response = "";
        if (isset($_POST) && array_filled($_POST)) {
            $order_id = intval($this->input->post('oid'));
            // debug($order_id,1);

            try {
                require_once(APPPATH . 'libraries/stripe-sdk/init.php');//or you
                // \Stripe\Stripe::setApiKey(STRIPE_SECRET_KEY);
                \Stripe\Stripe::setApiKey(g('db.admin.stripe_secret_key'));

                $token = $this->input->post('stripeToken');

                $getorderDetail = $this->model_order->find_by_pk($order_id);

   
                $custom_amount = $getorderDetail['order_total'];
 

                           
                ////FETCH ORDER DETAILS FOR MERCHANT/////////
                $pa['where']['order_id'] = $order_id;
                $pa['fields'] = 'order_firstname,order_lastname,order_shipping_email,order_id';
                $da = $this->model_order->find_one($pa);

               
                
                ////CHECK IF CUSTOMER EXISTS ELSE CREATE////
                $exist = \Stripe\Customer::all(array(
                    'email' => $da['order_shipping_email'],
                ));
                // debug($exist,1);
                if(isset($exist['data'][0]['id']))
                    {
                        $test['id'] = $exist['data'][0]['id'];
                        $test12 = \Stripe\Customer::update(
                            $test['id'],
                            ['source' => $token]
                        );
                    }
                    else{
                        $test = \Stripe\Customer::create(array(
                                'name' => $da['order_firstname'].' '.$da['order_lastname'],
                                'email' => $da['order_shipping_email'],
                                'source' => $token
                            ));
                    }

                $charge_param = array(
                    "amount" => $custom_amount * 100,
                    "currency" => 'USD',
                    // "card" => $token,
                    "description" => 'SC-'.$da['order_id'],
                    "statement_descriptor" => 'Could u tell| Add-Spot',
                    "customer" => $test['id'],
                    "capture" => true,
                );

                
                ////CHARGE THE EXISTING CUSTOMER//////    
                $charge = \Stripe\Charge::create($charge_param);
                // debug($charge,1);
                // debug($this->total_amount,1);


                $charge = str_replace('Stripe\Charge JSON:', '', $charge);
                // debug($charge,1);

                $response = json_decode($charge, true);
                // debug($response,1);
                if ($response['status'] == 'succeeded' && $response['captured'] == '1'){
                    $order_payment_status = 1; // pending
                    //$this->email_invoice($order_id); Will be send on success method
                } else {
                    $title = "Error found please try again";
                    $order_payment_status = 0;
                    $msg_type = 'error';
                }

            } // Since it's a decline, \Stripe\Error\Card will be caught
            catch (\Stripe\Error\Card $e) {
                echo "Since it's a decline, \Stripe\Error\Card will be caught";
                $body = $e->getJsonBody();
                $err = $body['error'];
                $title = $err;
                $order_payment_status = 0;
                $msg_type = 'error';
            } // Invalid parameters were supplied to Stripe's API
            catch (\Stripe\Error\InvalidRequest $e) {
                echo "Invalid parameters were supplied to Stripe's API";
                $body = $e->getJsonBody();
                $err = $body['error'];
                $title = $err;
                $order_payment_status = 0;
                $msg_type = 'error';
            } // Authentication with Stripe's API failed
            catch (\Stripe\Error\Authentication $e) {
                echo "Authentication with Stripe's API failed";
                $body = $e->getJsonBody();
                $err = $body['error'];
                $title = $err;
                $order_payment_status = 0;
                $msg_type = 'error';
            } // Network communication with Stripe failed
            catch (\Stripe\Error\ApiConnection $e) {
                echo "Network communication with Stripe failed";
                $body = $e->getJsonBody();
                $err = $body['error'];
                $title = $err;
                $order_payment_status = 0;
                $msg_type = 'error';
            } // Display a very generic error to the user, and maybe send
            catch (\Stripe\Error\Base $e) {
                echo "Display a very generic error to the user, and maybe send";
                $body = $e->getJsonBody();
                $err = $body['error'];
                $title = $err;
                $order_payment_status = 0;
                $msg_type = 'error';
            } // Since it's a decline, \Stripe\Error\Card will be caught
            catch (\Stripe\Exception\CardException $e) {
                $body = $e->getJsonBody();
                $err = $body['error'];
                $title = $err;
                $order_payment_status = 7;
                $msg_type = 'error';
            }
            catch (Exception $e) {
                // echo "Something else happened, completely unrelated to Stripe";
                $body = $e->getJsonBody();
                $err = $body['error'];
                $title = $err;
                $msg_type = 'error';
            }

            // debug($body);
            // debug($response,1);
            if ($order_payment_status == 1) 
            {
                // $data11['is_success'] = 1;
                // $this->session->set_userdata($data11);
                $params = array();
                $params['order_payment_status'] = 1;
                $params['order_status'] = 1;
                $params['order_payment_comments'] = 'Completed';
                $params['order_merchant'] = 'Stripe';
                $params['order_response'] = serialize($response);
                // debug($update,1);
                $update = $this->model_order->update_by_pk($order_id, $params);

                $addSpot = $this->model_add_spot->find_by_pk($getorderDetail['order_add_spot_id']);
                $userparam['signup_add_spot_package_id'] = $getorderDetail['order_add_spot_id'];
                $userparam['signup_add_spot_day_limit'] = $addSpot['add_spot_day_limit'];
                $userparam['signup_add_spot_adds_limit'] = $addSpot['add_spot_adds_limit'];
                $userparam['signup_add_spot_status'] = 1;
                               
                $update1 = $this->model_signup->update_by_pk($this->userid, $userparam);
                
                redirect(l('dashboard/success?oid=' . $order_id), true);
              
            } 
            
            // // Pending, to be captured later
            elseif ($order_payment_status == 2) 
            {   
                $params = array();
                $params['order_payment_status'] = 2;
                $params['order_status'] = 0;
                $params['order_charge_id'] = $response['charge_id'];
                $params['order_payment_comments'] = 'Pending due to admin approval';
                $params['order_merchant'] = 'Stripe';
                $params['order_response'] = serialize($response);
                // debug($update,1);
                $update = $this->model_order->update_by_pk($order_id, $params);
                $admin_params['admin_order_status'] = 0;
                $order_detail_c = $this->model_order->find_by_pk($order_id);
                $update = $this->model_admin_order->update_by_pk($order_detail_c['admin_order_id'], $admin_params);
                redirect(l('dashboard/success?oid=' . $order_id), true);
            }
            
            // Card Error/Declined
            elseif ($order_payment_status == 7) 
            {   
                $params = array();
                $params['order_payment_status'] = 7;
                $params['order_status'] = 0;
                $code = $body['error']['code']=='card_declined' ? $body['error']['decline_code'] : $body['error']['code'];
                $params['order_payment_comments'] = $body['error']['message'].' Error: '.$code;
                $params['order_merchant'] = 'Stripe';
                $params['order_response'] = serialize($response);
                // debug($update,1);
                $update = $this->model_order->update_by_pk($order_id, $params);
                redirect(l('checkout/error?oid=' . $order_id."&error=".$body['error']['message']), true);
            }
                
            else 
            {
                // debug($order_id,1);
                $this->save_order_delete($order_id);
                redirect(l('checkout/error?oid=' . $order_id."&error=".$body['error']['message']), true);
            }
        }
    }
    public function success()
    {
        // debug('asdajshd',1);
        $order_id = $_GET['oid'];

        
        
        $data['heading'] = "Success Payment";

        $data['text'] = "Thank you! Payment process has been completed.";

        if (ENVIRONMENT != 'development') {
            // get order detail
            $getorderDetail = $this->model_order->find_by_pk($order_id);
            // $this->invoice_email($getorderDetail);
        }
     
        $getorderDetail = $this->model_order->find_by_pk($order_id);

        $data['order_number'] = $getorderDetail['order_number'];
        $data['order_amount'] = $getorderDetail['order_amount'];
        $data['order_total'] = $getorderDetail['order_total'];

        $data['meta_dat']['title'] = "ThankYou";
       
        $this->load_view("success" , $data);
    }
	
    	public function upload_tax_file()
	{
	    $id = $this->userid;
	    $upload_path = './assets/uploads/signup';
        $filename = 'tax-document-'.md5($id);
        $param001['where']['signup_id'] = $id;
        $param001['fields'] = 'signup_tax_exempted_states';
        $data = $this->model_signup->find_all($param001);
        // debug(unserialize($data[0]['signup_tax_exempted_states']));
	    $tax_exempted_states_id = serialize($this->input->post('tax_exempted_states').','.unserialize($data[0]['signup_tax_exempted_states']));
	    if($data[0]['signup_tax_exempted_states'] != ''){
	        $tax_exempted_states_id = $this->input->post('tax_exempted_states').','.unserialize($data[0]['signup_tax_exempted_states']);
	    }
	    else{
	        $tax_exempted_states_id = $this->input->post('tax_exempted_states');
	    }
	    
	    $tax_exempted_states_id = serialize(implode(',',array_unique(explode(',',$tax_exempted_states_id))));
	    

	    $updateSignupParam['signup_tax_exempted_states'] = $tax_exempted_states_id;
	    $updateSignupParam['signup_tax_document_upload_path'] = $upload_path.'/';
	    
	   // if (!is_dir('assets/uploads/signup')) {
    //     mkdir('assets/uploads/tax_documents', 0777, TRUE);}
        
	    $config['upload_path']          = $upload_path;
	    $config['file_name']            = $filename;
        $config['allowed_types']        = 'jpg|png|pdf|docx|doc';
        $config['max_size']             = 1024;
        $config['overwrite']            = TRUE;
        
        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('file'))
        {
            $param['status'] = 0;
            $param['error'] = $this->upload->display_errors();
        }
        else
        {
            $updateSignupParam['signup_tax_document'] = $this->upload->data()['file_name'];
            $isUpdated = $this->model_signup->update_by_pk($id, $updateSignupParam);
            if($isUpdated > 0)
            {
                $param['status'] = 1;
                $param['upload_data'] = $this->upload->data();
            }
        }
        
        echo json_encode($param);
	}





    public function tax()
	{
	    if($this->userid <= 0){
			redirect(g('base_url').'login');
		}
		global $config;
		$user = $this->model_signup->find_by_pk($this->userid);
		$state_names = array();
        $param['where']['tax_exempted_signup_id'] = $this->userid;
        // debug($param,1);
        $tax_exempted_states = $this->model_tax_exempted_state->find_all($param);
        // debug($tax_exempted_states,1);
        foreach ($tax_exempted_states as $key=>$value):
            $stateData = $this->model_state->find_by_pk($value['tax_exempted_state']);
            array_push($state_names, $stateData['state_name']);
            // debug ($stateData);
        endforeach;
        
        $data['states'] = $this->model_state->find_all();
        $data['tax_document'] = $user['signup_tax_document'];
        $data['upload_path'] = $user['signup_tax_document_upload_path'];
        $data['tax_exempted_states'] = $state_names;
        $applied_states = explode(',',unserialize($user['signup_tax_exempted_states']));
        $res_state = array();
        foreach ($applied_states as $key => $val){
            $app = $this->model_state->find_by_pk($val);
            array_push($res_state,$app['state_name']);
        }
        $data['applied_states'] = $res_state;
        
		$this->load_view("tax" , $data);
	}

    public function getinvoice(){

        $order_id = intval($_POST['order_id']);
        $data['order_detail'] = $this->model_order->find_by_pk($order_id);
        $data['order_items'] = $this->model_order_item->find_all(
            array('where'=>array('order_item_order_id'=>$order_id))
        );
        $message = $this->load->view("account/invoiceTemplate",
            $data,
            true
        );
        echo $message;
    }



    public function my_favorites(){
        if($this->userid <= 0){
            redirect(g('base_url').'');
        }
        global $config;
        $data['banner_heading'] = "Account Info";

        $data['result'] = $this->model_favorite->get_my_fav($this->userid);

        $this->load_view("my_favorites" , $data);
    }

	public function addwishlist(){
		if($this->userid <= 0){
			echo json_encode(array('status'=>0,'message'=>'You are not logged in'));
		}
		else{
			$data['wishlist_user_id'] = $this->userid;
			$data['wishlist_product_id'] = intval($_POST['product_id']);
			$status = $this->model_wishlist->insert_record($data);
			if($status > 0){
				echo json_encode(array('status'=>1,'message'=>'Your item has been added into your wishlist.'));
			}
			else{
				echo json_encode(array('status'=>0,'message'=>'Please try again'));
			}
		}
	}

    // Change password view
	public function change_password(){

		if($this->userid <= 0){
			redirect(g('base_url').'login');
		}
		global $config;
        $data['inner_banner'] = $this->model_inner_banner->find_by_pk(14);
        // Get and set cms data
        $data['content'] = $this->model_cms_page->get_page(12);
		//$this->add_script(array('innerstyle.css','font-awesome.min.css'));
		$data['userEmail'] = $this->session->userdata['userdata']['email'];
		$data['userdata'] = $this->model_signup->find_by_pk($this->userid);
        $data['banner_heading'] = "Change Password";

		$this->load_view("changepassword" , $data);
	}

    // update_password
	public function update_password(){
		if($this->userid <= 0){
			$param['status'] = 0;
			$param['txt'] = "you are not registered";
			echo json_encode($param);
		}
		else{
            if($_POST['password'] == $_POST['confirmPassword'])
            {
                if((count($_POST) > 0) && (isset($_POST['confirmPassword'])) && (!empty($_POST['confirmPassword']))) {
                    $param['signup_password'] = md5($_POST['confirmPassword']);
                    //debug($param['signup_password']);
                    $status = $this->model_signup->update_by_pk($this->userid,$param);
                    //debug($status);
                    if($status){
                        $this->json_param['status'] = 1;
                        $this->json_param['txt'] = 'Password has been changed.';
                        echo json_encode($this->json_param);
                    }
                }
                else{
                    $this->json_param['status'] = 0;
                    $this->json_param['txt'] = 'Record Not Found.';
                    echo json_encode($this->json_param);
                }
            }else{
                $this->json_param['status'] = 0;
                $this->json_param['txt'] = 'Entered passwords must be same..';
                echo json_encode($this->json_param);
            }
		}
	}

	public function resetpasswordclient(){
		$id = $_POST['id'];
  		//$encodedID = "yrt15".$result['id']."xyurt8576412";
  		$id = str_replace("yrt15", "", $id);
  		$id = str_replace("xyurt8576412", "", $id);

  		if(isset($_POST['password']) && empty($_POST['password'])){
  			echo json_encode(array('status'=>0,'txt'=>'Please provide the password'));
  		}
  		else{
  			$password = md5($_POST['password']);
  			$status = $this->model_signup->update_by_pk($id,array('signup_password'=>$password));
  			if($status){
  				echo json_encode(array('status'=>1,'txt'=>'Your password has been changed.'));		
  			}
  			else{
  				echo json_encode(array('status'=>0,'txt'=>'Please try again or use different password'));		
  			}
  		}
	}

    // Update profile image
    public function update_profile_image()
    {
        // Get User id
        $user_id = $this->userid;
        // Success
        if((count($_FILES)>0) && ($user_id!=null)){
            // Get temp file
            $tmp = $_FILES['file']['tmp_name'];
            // Generate file name
            $name = mt_rand().$_FILES['file']['name'];
            // Get upload path
            $upload_path = $this->config->item('site_upload_signup');
            // Set data
            $data = array(
                'signup_logo_image' => $name,
                'signup_logo_image_path' => $upload_path,
            );
            // Upload new file
            move_uploaded_file( $tmp,$upload_path.$name);
            $inserted_id = $this->model_signup->update_by_pk($user_id, $data);
            if($inserted_id > 0)
            {
                $profile_image_url = array(
                    'signup_image'=>$upload_path . $name
                );
                // Update session profile
                $this->model_signup->update_user_session($profile_image_url);
                // save log ends

                $this->json_param['status'] = true;
                $this->json_param['txt'] = 'Updated successfully.';
            }
            else{
                $this->json_param['status'] = false;
                $this->json_param['txt'] = 'Something went wrong.Please try later.';
            }
        }
        // Error
        else{
            $this->json_param['status'] = false;
            $this->json_param['txt'] = lang('something_wrong');
        }

        echo json_encode($this->json_param);

    }

    function createSlug($string) {
        // Remove special characters, punctuation, and symbols
        $string = preg_replace('/[^a-zA-Z0-9]+/', ' ', $string);
        // Convert the string to lowercase and replace spaces with hyphens
        $slug = strtolower(trim(str_replace(' ', '-', $string)));
        return $slug;
    }

}



/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */